"""Default Hyperparameter configuration."""

import ml_collections


def d(**kwargs):
  """Helper of creating a config dict."""
  return ml_collections.ConfigDict(initial_dictionary=kwargs)


seed = 0


def get_config():
  """Get the default hyperparameter configuration."""
  config = ml_collections.ConfigDict()
  config.train_data_config = d(
    seed=seed,
    data_spec="/home/yiboyang/data/mnist/x_train.npy",
    shuffle=True,
    batchsize=100,
    mode='swrep',
    fixed_batch=False,  # Use one batch from the empirical distribution.
    img_shape=(28, 28, 1),
    append_channel_dim=True
  )
  config.eval_data_config = d(
    shuffle=False,
    data_spec="/home/yiboyang/data/mnist/x_test.npy",
    batchsize=1000,  # Using 'all' would cause OOM.
    mode='once',
    fixed_batch=False,
    img_shape=(28, 28, 1),
    append_channel_dim=True
  )
  config.train_eval_config = d(
    num_train_steps=30000,
    # num_eval_steps=1,
    num_eval_steps=None,  # Run eval by looping through the (finite) eval_ds.
    log_metrics_every_steps=100,
    log_imgs_every_steps=1000,
    checkpoint_every_steps=int(1e9),
    eval_every_steps=1000,
    seed=seed,
    # warm_start="",
  )

  config.model_config = d(
    rd_lambda=100.0,
    latent_dim=128,
    num_samples=40000,  # NERDlagr.py
    distort_type='mse',
    scheduled_num_steps=config.train_eval_config.num_train_steps,
    transform_config=d(
      # decoder_type='mlp',
      decoder_type='dcgan',
      nn_size=32,
      img_shape=config.train_data_config.img_shape,
      decoder_activation='relu',
      # decoder_activation='leaky_relu',
      # decoder_activation=None,
      prior_type='std_gaussian',
      # ar_hidden_units=[10, 10],
      # ar_activation='softplus',
      # maf_stacks=2,
      # iaf_stacks=0
    ),
    optimizer_config=d(
      name='adam',
      # name='sgd',
      # lr_decay=True,
      # lr_decay_rate=1e-3,
      learning_rate=5e-4,
      # clip_norm=1.0,
    )
  )
  config.ckpt_restore_dir = 'None'
  return config


def get_cfg_str(config):
  from collections import OrderedDict
  runname_dict = OrderedDict()
  runname_dict['ldim'] = config.model_config.latent_dim
  runname_dict['n'] = config.model_config.num_samples
  runname_dict['rd_lambda'] = config.model_config.rd_lambda
  # runname_dict['tseed'] = config.train_eval_config.seed

  from common import utils
  return utils.config_dict_to_str(runname_dict)


def get_hyper():
  """
  Produce a list of flattened dicts, each containing a hparam configuration overriding the one in
  get_config(), corresponding to one hparam trial/experiment/work unit.
  :return:
  """
  from common import hyper
  rd_lambdas = [1000, 500, 300, 100, 30, 10, 1]
  rd_lambdas = hyper.sweep('model_config.rd_lambda', rd_lambdas)

  hparam_cfgs = hyper.product(rd_lambdas)
  return hparam_cfgs
