"""Default Hyperparameter configuration."""

import ml_collections


def d(**kwargs):
  """Helper of creating a config dict."""
  return ml_collections.ConfigDict(initial_dictionary=kwargs)


seed = 0


def get_config():
  """Get the default hyperparameter configuration."""
  config = ml_collections.ConfigDict()
  config.train_data_config = d(
    seed=seed,
    data_spec="banana",
    data_dim=2,
    batchsize=10000,
    # gaussian_noise_var=0
    fixed_batch=True  # Use one batch from the empirical distribution.
  )
  config.eval_data_config = dict(config.train_data_config)
  config.train_eval_config = d(
    # epochs=100,
    # steps_per_epoch=10000,
    num_train_steps=2000,
    substeps=1,
    num_eval_steps=1,
    log_metrics_every_steps=100,
    checkpoint_every_steps=1000,
    eval_every_steps=500,
    seed=seed,
    # warm_start="",
  )

  config.model_config = d(
    rd_lambda=1.0,
    distort_type='half_sse',
    # nu_support_size=128,
    nu_support_size=config.train_data_config.batchsize,
  )
  # Below optimizer_config not used, but still provide it for compliance with
  # the API of jax_experiment.Experiment.
  config.optimizer_config = d(
    name='adam',
    args=dict(),  # b1, b2, etc.
    learning_rate=0,
    lr_decay=False,
    # gradient_clip_norm=1.0,
  )
  config.ckpt_restore_dir = 'None'
  return config


def get_cfg_str(config):
  from collections import OrderedDict
  runname_dict = OrderedDict()
  runname_dict['rd_lambda'] = config.model_config.rd_lambda

  from common import utils
  return utils.config_dict_to_str(runname_dict)


def get_hyper():
  """
  Produce a list of flattened dicts, each containing a hparam configuration overriding the one in
  get_config(), corresponding to one hparam trial/experiment/work unit.
  :return:
  """
  from common import hyper
  # import numpy as np
  # rd_lambdas = [0.01, 0.03, 0.1, 0.3, 1., 3., 10.]
  rd_lambdas = [0.01, 0.1, 1.]
  rd_lambdas = hyper.sweep('model_config.rd_lambda', rd_lambdas)
  hparam_cfgs = rd_lambdas
  return hparam_cfgs
