;; gorilla-repl.fileformat = 1

;; **
;;; # Gorilla REPL
;;; 
;;; Welcome to gorilla :-)
;;; 
;;; Shift + enter evaluates code. Hit alt+g twice in quick succession or click the menu icon (upper-right corner) for more commands ...
;;; 
;;; It's a good habit to run each worksheet in its own namespace: feel free to use the declaration we've provided below if you'd like.
;; **

;; @@
(ns model
  (:require [gorilla-plot.core :as plot])
  (:use [anglican core emit runtime stat
          [state :only [get-predicts get-log-weight get-result]]]))

(defdist geometric
"Geometric distribution on support {0,1,2....}"
[p] []
(sample* [this]
        (loop [value 0]
            (if (sample* (flip p))
            value
            (recur (inc value)))))
(observe* [this value] (+ (log p) (* value (log (- 1 p))))))

(defdist dirac [x]
    (sample* [this] x)
    (observe* [this value]
              (if (= value x)
                0
                (- (/ 1.0 0.0)))))


(with-primitive-procedures [dirac geometric]
  (defquery nested2 [method- options-  a b c d]
    (let [
          c (sample (bernoulli 0.5))
          [ a b c d] (cond
            (= c 0)
            (let [
                  d (sample (bernoulli 0.1))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  d (sample (bernoulli 0.9))
                 ]
              [ a b c d ]
            )
          )
          [ a b c d] (cond
            (= b 1)
            (let [
                  _unused (observe (flip 1.0) (= d 0))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  _unused (observe (flip 1.0) (= d 1))
                 ]
              [ a b c d ]
            )
          )
         ]
      [ a b c d ]
    )

  )
  (defquery nested1 [method- options-  a b c d]
    (let [
          c (sample (bernoulli 0.5))
          [ a b c d] (cond
            (= c 0)
            (let [
                  d (sample (bernoulli 0.1))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  d (sample (bernoulli 0.9))
                 ]
              [ a b c d ]
            )
          )
          [ a b c d] (cond
            (= b 1)
            (let [
                  _unused (observe (flip 1.0) (= d 0))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  _unused (observe (flip 1.0) (= d 1))
                 ]
              [ a b c d ]
            )
          )
         ]
      [ a b c d ]
    )

  )
  (defquery nested0 [method- options-  a b c d]
    (let [
          c (sample (bernoulli 0.5))
          [ a b c d] (cond
            (= c 0)
            (let [
                  d (sample (bernoulli 0.1))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  d (sample (bernoulli 0.9))
                 ]
              [ a b c d ]
            )
          )
          [ a b c d] (cond
            (= b 1)
            (let [
                  _unused (observe (flip 1.0) (= d 0))
                 ]
              [ a b c d ]
            )
            :else
            (let [
                  _unused (observe (flip 1.0) (= d 1))
                 ]
              [ a b c d ]
            )
          )
         ]
      [ a b c d ]
    )

  )
  (defquery model [method- options- ]
    (let [[ a b c d] [ 0 0 0 0 ]
          [ a b c d]
          (let [
                a (sample (uniform-continuous 0 1))
                b (sample (bernoulli a))
                [ a b c d] (sample ((apply conditional nested0 method- options-) method- options-  a b c d))

                _unused (observe (flip 1.0) (= c 1))
                b (sample (bernoulli a))
                [ a b c d] (sample ((apply conditional nested1 method- options-) method- options-  a b c d))

                _unused (observe (flip 1.0) (= c 1))
                b (sample (bernoulli a))
                [ a b c d] (sample ((apply conditional nested2 method- options-) method- options-  a b c d))

                _unused (observe (flip 1.0) (= c 1))
                b (sample (bernoulli a))
               ]
            [ a b c d ]
          )
         ]
    b
    )
  )

)


(def model_name "preference1")
(def outfile "preference1_anglican.json")

; (def configurations [:rmh []])
(def configurations
  [
    [:importance []]
    [:lmh []]
    [:smc []]
    [:pgibbs []]
    [:ipmcmc []]
  ])

; (def num_samples_options [1000])
(def num_samples_options [1000 10000])
(def thinning 1)

(spit outfile "[\n" :append false)

(def num-chains 20)

(doall
  (for [ num_samples num_samples_options
         [method options] configurations
         chain (range 0 num-chains)]
    (do
      (println (format "\nMethod %s with options %s" method options))
      (println (format "Chain no. %s" chain))
      (let [start (. System (nanoTime))
            warmup (/ num_samples 5)
            samples (take-nth thinning (take (* num_samples thinning) (drop warmup (apply doquery method model [method options] options))))
            results (collect-results samples)
            values (map (fn [s] (get-result s)) samples)
            max-value (apply max values)
            mean (empirical-mean results)
            variance (empirical-variance results)
            std (empirical-std results)
            skewness (if (zero? std) (/ 0.0 0.0) (empirical-skew results))
            kurtosis (if (zero? std) (/ 0.0 0.0) (empirical-kurtosis results))
            distribution (empirical-distribution (collect-results samples))
            masses (for [n (range 0 (inc max-value))] (get distribution n 0.0))
            end (. System (nanoTime))
            elapsed_ms (/ (- end start) 1e6)]
        (println (format "Elapsed time: %s ms" elapsed_ms))
        (println (format "Empirical mean: %s" mean))
        (println (format "Empirical variance: %s" variance))
        (println (format "Empirical std: %s" std))
        (println (format "Empirical skewness: %s" skewness))
        (println (format "Empirical kurtosis: %s" kurtosis))
        (spit outfile (format
                   "{\"model\": \"%s\", \"system\": \"anglican\", \"method\": \"%s\", \"options\": \"%s\", \"num_samples\": %s, \"time_ms\": %s, \"total\": 1.0, \"mean\": %s, \"variance\": %s, \"stddev\": %s, \"skewness\": %s, \"kurtosis\": %s, \"masses\": [%s] },\n"
                   model_name method options num_samples elapsed_ms mean variance std skewness kurtosis
                   (clojure.string/join ", " masses)) :append true)
        (if false (do
          (println "Empirical distribution:")
          (doall (for [n (range 0 (inc max-value))]
            (println (format "p(%s) = %s" n (get distribution n 0.0)))))))
        ; (println "List of samples (format: sample log-weight):")
        ; (doall (map (fn [s] (println (format "%s %s" (get-result s) (get-log-weight s)))) samples))
        ; values need to be adjusted if they are weighted!
        ; (plot/histogram values :normalize :probability)
      )
    )
  )
)

(spit outfile "]\n" :append true)



;; @@
;; ->
;;; 
;;; Method :importance with options []
;;; Chain no. 0
;;; Elapsed time: 3927.395858 ms
;;; Empirical mean: 0.3399999999999997
;;; Empirical variance: 0.22439999999999993
;;; Empirical std: 0.47370877129308037
;;; Empirical skewness: 0.6755205294732001
;;; Empirical kurtosis: 1.4563279857397529
;;; 
;;; Method :importance with options []
;;; Chain no. 1
;;; Elapsed time: 3703.478147 ms
;;; Empirical mean: 0.3489999999999997
;;; Empirical variance: 0.2271989999999999
;;; Empirical std: 0.4766539625346672
;;; Empirical skewness: 0.6335833198450251
;;; Empirical kurtosis: 1.4014278231858437
;;; 
;;; Method :importance with options []
;;; Chain no. 2
;;; Elapsed time: 3694.96747 ms
;;; Empirical mean: 0.31099999999999983
;;; Empirical variance: 0.21427899999999994
;;; Empirical std: 0.4629027975720172
;;; Empirical skewness: 0.8165861212821727
;;; Empirical kurtosis: 1.6668128934706632
;;; 
;;; Method :importance with options []
;;; Chain no. 3
;;; Elapsed time: 3810.941748 ms
;;; Empirical mean: 0.33599999999999974
;;; Empirical variance: 0.2231039999999999
;;; Empirical std: 0.47233886141201625
;;; Empirical skewness: 0.6944167139232897
;;; Empirical kurtosis: 1.48221457257602
;;; 
;;; Method :importance with options []
;;; Chain no. 4
;;; Elapsed time: 4106.580558 ms
;;; Empirical mean: 0.29699999999999993
;;; Empirical variance: 0.208791
;;; Empirical std: 0.45693653826324726
;;; Empirical skewness: 0.8885260118246396
;;; Empirical kurtosis: 1.789478473688999
;;; 
;;; Method :importance with options []
;;; Chain no. 5
;;; Elapsed time: 3614.864464 ms
;;; Empirical mean: 0.33399999999999985
;;; Empirical variance: 0.22244399999999995
;;; Empirical std: 0.47163969298607594
;;; Empirical skewness: 0.7039271819935691
;;; Empirical kurtosis: 1.4955134775494072
;;; 
;;; Method :importance with options []
;;; Chain no. 6
;;; Elapsed time: 3774.331902 ms
;;; Empirical mean: 0.33599999999999974
;;; Empirical variance: 0.2231039999999999
;;; Empirical std: 0.47233886141201625
;;; Empirical skewness: 0.6944167139232897
;;; Empirical kurtosis: 1.48221457257602
;;; 
;;; Method :importance with options []
;;; Chain no. 7
;;; Elapsed time: 3506.722499 ms
;;; Empirical mean: 0.3299999999999998
;;; Empirical variance: 0.2210999999999999
;;; Empirical std: 0.4702127178203498
;;; Empirical skewness: 0.7230769971004934
;;; Empirical kurtosis: 1.5228403437358673
;;; 
;;; Method :importance with options []
;;; Chain no. 8
;;; Elapsed time: 3773.294525 ms
;;; Empirical mean: 0.3099999999999998
;;; Empirical variance: 0.2138999999999999
;;; Empirical std: 0.462493243193887
;;; Empirical skewness: 0.8216336251223807
;;; Empirical kurtosis: 1.6750818139317447
;;; 
;;; Method :importance with options []
;;; Chain no. 9
;;; Elapsed time: 3662.446292 ms
;;; Empirical mean: 0.3149999999999997
;;; Empirical variance: 0.2157749999999999
;;; Empirical std: 0.46451587701606056
;;; Empirical skewness: 0.7965282099221077
;;; Empirical kurtosis: 1.634457189201717
;;; 
;;; Method :importance with options []
;;; Chain no. 10
;;; Elapsed time: 3767.924627 ms
;;; Empirical mean: 0.29699999999999993
;;; Empirical variance: 0.208791
;;; Empirical std: 0.45693653826324726
;;; Empirical skewness: 0.8885260118246396
;;; Empirical kurtosis: 1.789478473688999
;;; 
;;; Method :importance with options []
;;; Chain no. 11
;;; Elapsed time: 3821.5376 ms
;;; Empirical mean: 0.32599999999999973
;;; Empirical variance: 0.21972399999999992
;;; Empirical std: 0.46874726665869737
;;; Empirical skewness: 0.7424043290547552
;;; Empirical kurtosis: 1.551164187799241
;;; 
;;; Method :importance with options []
;;; Chain no. 12
;;; Elapsed time: 3609.601538 ms
;;; Empirical mean: 0.3299999999999998
;;; Empirical variance: 0.2210999999999999
;;; Empirical std: 0.4702127178203498
;;; Empirical skewness: 0.7230769971004934
;;; Empirical kurtosis: 1.5228403437358673
;;; 
;;; Method :importance with options []
;;; Chain no. 13
;;; Elapsed time: 3739.953596 ms
;;; Empirical mean: 0.3319999999999998
;;; Empirical variance: 0.22177599999999986
;;; Empirical std: 0.47093099282166584
;;; Empirical skewness: 0.7134803296482939
;;; Empirical kurtosis: 1.5090541807950386
;;; 
;;; Method :importance with options []
;;; Chain no. 14
;;; Elapsed time: 3528.869706 ms
;;; Empirical mean: 0.3079999999999998
;;; Empirical variance: 0.21313599999999985
;;; Empirical std: 0.4616665463297074
;;; Empirical skewness: 0.8317691698756097
;;; Empirical kurtosis: 1.6918399519555611
;;; 
;;; Method :importance with options []
;;; Chain no. 15
;;; Elapsed time: 3849.69324 ms
;;; Empirical mean: 0.3139999999999998
;;; Empirical variance: 0.2154039999999999
;;; Empirical std: 0.4641163647190216
;;; Empirical skewness: 0.801523127126127
;;; Empirical kurtosis: 1.642439323318046
;;; 
;;; Method :importance with options []
;;; Chain no. 16
;;; Elapsed time: 3503.510673 ms
;;; Empirical mean: 0.3229999999999998
;;; Empirical variance: 0.21867099999999998
;;; Empirical std: 0.46762271116788157
;;; Empirical skewness: 0.7570205457213363
;;; Empirical kurtosis: 1.5730801066442293
;;; 
;;; Method :importance with options []
;;; Chain no. 17
;;; Elapsed time: 3481.339391 ms
;;; Empirical mean: 0.32599999999999973
;;; Empirical variance: 0.21972399999999992
;;; Empirical std: 0.46874726665869737
;;; Empirical skewness: 0.7424043290547552
;;; Empirical kurtosis: 1.551164187799241
;;; 
;;; Method :importance with options []
;;; Chain no. 18
;;; Elapsed time: 3889.514249 ms
;;; Empirical mean: 0.32499999999999973
;;; Empirical variance: 0.2193749999999999
;;; Empirical std: 0.46837484987987976
;;; Empirical skewness: 0.7472647177570746
;;; Empirical kurtosis: 1.5584045584045605
;;; 
;;; Method :importance with options []
;;; Chain no. 19
;;; Elapsed time: 3940.151461 ms
;;; Empirical mean: 0.3219999999999998
;;; Empirical variance: 0.2183159999999999
;;; Empirical std: 0.46724297747531734
;;; Empirical skewness: 0.7619162131094979
;;; Empirical kurtosis: 1.5805163157991176
;;; 
;;; Method :lmh with options []
;;; Chain no. 0
;;; Elapsed time: 683.232507 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 1
;;; Elapsed time: 673.703181 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 2
;;; Elapsed time: 687.864402 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 3
;;; Elapsed time: 693.947371 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 4
;;; Elapsed time: 818.876693 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 5
;;; Elapsed time: 921.590915 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 6
;;; Elapsed time: 699.196096 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 7
;;; Elapsed time: 712.735145 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 8
;;; Elapsed time: 671.9801 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 9
;;; Elapsed time: 787.360299 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 10
;;; Elapsed time: 746.306235 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 11
;;; Elapsed time: 740.782572 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 12
;;; Elapsed time: 825.38275 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 13
;;; Elapsed time: 683.604984 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 14
;;; Elapsed time: 668.516518 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 15
;;; Elapsed time: 745.885939 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 16
;;; Elapsed time: 744.030151 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 17
;;; Elapsed time: 711.188493 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 18
;;; Elapsed time: 651.170204 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 19
;;; Elapsed time: 683.692461 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :smc with options []
;;; Chain no. 0
;;; Elapsed time: 5145.691984 ms
;;; Empirical mean: 0.31899999999999973
;;; Empirical variance: 0.2172389999999999
;;; Empirical std: 0.46608904728603084
;;; Empirical skewness: 0.7766756204804084
;;; Empirical kurtosis: 1.6032250194486273
;;; 
;;; Method :smc with options []
;;; Chain no. 1
;;; Elapsed time: 4981.326101 ms
;;; Empirical mean: 0.3489999999999997
;;; Empirical variance: 0.2271989999999999
;;; Empirical std: 0.4766539625346672
;;; Empirical skewness: 0.6335833198450251
;;; Empirical kurtosis: 1.4014278231858437
;;; 
;;; Method :smc with options []
;;; Chain no. 2
;;; Elapsed time: 4955.676472 ms
;;; Empirical mean: 0.32499999999999973
;;; Empirical variance: 0.2193749999999999
;;; Empirical std: 0.46837484987987976
;;; Empirical skewness: 0.7472647177570746
;;; Empirical kurtosis: 1.5584045584045605
;;; 
;;; Method :smc with options []
;;; Chain no. 3
;;; Elapsed time: 5012.315122 ms
;;; Empirical mean: 0.3079999999999998
;;; Empirical variance: 0.21313599999999985
;;; Empirical std: 0.4616665463297074
;;; Empirical skewness: 0.8317691698756097
;;; Empirical kurtosis: 1.6918399519555611
;;; 
;;; Method :smc with options []
;;; Chain no. 4
;;; Elapsed time: 5393.987286 ms
;;; Empirical mean: 0.31099999999999983
;;; Empirical variance: 0.21427899999999994
;;; Empirical std: 0.4629027975720172
;;; Empirical skewness: 0.8165861212821727
;;; Empirical kurtosis: 1.6668128934706632
;;; 
;;; Method :smc with options []
;;; Chain no. 5
;;; Elapsed time: 5136.416984 ms
;;; Empirical mean: 0.3479999999999997
;;; Empirical variance: 0.22689599999999993
;;; Empirical std: 0.4763360158543546
;;; Empirical skewness: 0.6382049433208351
;;; Empirical kurtosis: 1.407305549679151
;;; 
;;; Method :smc with options []
;;; Chain no. 6
;;; Elapsed time: 4899.020393 ms
;;; Empirical mean: 0.3379999999999998
;;; Empirical variance: 0.22375599999999993
;;; Empirical std: 0.47302854036516645
;;; Empirical skewness: 0.6849481000657597
;;; Empirical kurtosis: 1.469153899783694
;;; 
;;; Method :smc with options []
;;; Chain no. 7
;;; Elapsed time: 5306.71015 ms
;;; Empirical mean: 0.31999999999999973
;;; Empirical variance: 0.2175999999999999
;;; Empirical std: 0.46647615158762396
;;; Empirical skewness: 0.7717436331412911
;;; Empirical kurtosis: 1.59558823529412
;;; 
;;; Method :smc with options []
;;; Chain no. 8
;;; Elapsed time: 5561.421745 ms
;;; Empirical mean: 0.33099999999999974
;;; Empirical variance: 0.2214389999999999
;;; Empirical std: 0.4705730549022117
;;; Empirical skewness: 0.7182731702949703
;;; Empirical kurtosis: 1.5159163471655874
;;; 
;;; Method :smc with options []
;;; Chain no. 9
;;; Elapsed time: 5105.08763 ms
;;; Empirical mean: 0.3399999999999997
;;; Empirical variance: 0.22439999999999993
;;; Empirical std: 0.47370877129308037
;;; Empirical skewness: 0.6755205294732001
;;; Empirical kurtosis: 1.4563279857397529
;;; 
;;; Method :smc with options []
;;; Chain no. 10
;;; Elapsed time: 5075.499307 ms
;;; Empirical mean: 0.3329999999999998
;;; Empirical variance: 0.22211099999999995
;;; Empirical std: 0.47128653704513984
;;; Empirical skewness: 0.7086983687123866
;;; Empirical kurtosis: 1.5022533778155978
;;; 
;;; Method :smc with options []
;;; Chain no. 11
;;; Elapsed time: 5613.119563 ms
;;; Empirical mean: 0.33399999999999985
;;; Empirical variance: 0.22244399999999995
;;; Empirical std: 0.47163969298607594
;;; Empirical skewness: 0.7039271819935691
;;; Empirical kurtosis: 1.4955134775494072
;;; 
;;; Method :smc with options []
;;; Chain no. 12
;;; Elapsed time: 5048.954685 ms
;;; Empirical mean: 0.34099999999999975
;;; Empirical variance: 0.22471899999999992
;;; Empirical std: 0.47404535647973595
;;; Empirical skewness: 0.6708218858243242
;;; Empirical kurtosis: 1.450002002500903
;;; 
;;; Method :smc with options []
;;; Chain no. 13
;;; Elapsed time: 5677.845423 ms
;;; Empirical mean: 0.3139999999999998
;;; Empirical variance: 0.2154039999999999
;;; Empirical std: 0.4641163647190216
;;; Empirical skewness: 0.801523127126127
;;; Empirical kurtosis: 1.642439323318046
;;; 
;;; Method :smc with options []
;;; Chain no. 14
;;; Elapsed time: 5511.589087 ms
;;; Empirical mean: 0.296
;;; Empirical variance: 0.20838399999999996
;;; Empirical std: 0.45649096376598736
;;; Empirical skewness: 0.8937745374717964
;;; Empirical kurtosis: 1.7988329238329237
;;; 
;;; Method :smc with options []
;;; Chain no. 15
;;; Elapsed time: 5160.612613 ms
;;; Empirical mean: 0.3129999999999997
;;; Empirical variance: 0.21503099999999986
;;; Empirical std: 0.4637143517295964
;;; Empirical skewness: 0.806531000399335
;;; Empirical kurtosis: 1.6504922546051524
;;; 
;;; Method :smc with options []
;;; Chain no. 16
;;; Elapsed time: 4973.521108 ms
;;; Empirical mean: 0.33599999999999974
;;; Empirical variance: 0.2231039999999999
;;; Empirical std: 0.47233886141201625
;;; Empirical skewness: 0.6944167139232897
;;; Empirical kurtosis: 1.48221457257602
;;; 
;;; Method :smc with options []
;;; Chain no. 17
;;; Elapsed time: 5513.459622 ms
;;; Empirical mean: 0.30899999999999983
;;; Empirical variance: 0.21351899999999996
;;; Empirical std: 0.46208116170214075
;;; Empirical skewness: 0.826694597530983
;;; Empirical kurtosis: 1.683423957586914
;;; 
;;; Method :smc with options []
;;; Chain no. 18
;;; Elapsed time: 5124.192474 ms
;;; Empirical mean: 0.29499999999999993
;;; Empirical variance: 0.20797499999999997
;;; Empirical std: 0.45604276115294273
;;; Empirical skewness: 0.899038500169283
;;; Empirical kurtosis: 1.8082702247866336
;;; 
;;; Method :smc with options []
;;; Chain no. 19
;;; Elapsed time: 5414.758347 ms
;;; Empirical mean: 0.29999999999999993
;;; Empirical variance: 0.20999999999999996
;;; Empirical std: 0.45825756949558394
;;; Empirical skewness: 0.8728715609439701
;;; Empirical kurtosis: 1.7619047619047628
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 0
;;; Elapsed time: 2067.2631 ms
;;; Empirical mean: 0.22454243652550115
;;; Empirical variance: 0.17412313072469246
;;; Empirical std: 0.4172806378502272
;;; Empirical skewness: 1.3202508742970611
;;; Empirical kurtosis: 2.7430623710821536
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 1
;;; Elapsed time: 1988.77927 ms
;;; Empirical mean: 0.2193314705008747
;;; Empirical variance: 0.17122517654879865
;;; Empirical std: 0.4137936400535884
;;; Empirical skewness: 1.3565628000603267
;;; Empirical kurtosis: 2.840262630507514
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 2
;;; Elapsed time: 2041.696806 ms
;;; Empirical mean: 0.2648109897384974
;;; Empirical variance: 0.19468612945221486
;;; Empirical std: 0.4412325117805972
;;; Empirical skewness: 1.06605476243079
;;; Empirical kurtosis: 2.1364727565013686
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 3
;;; Elapsed time: 1971.709798 ms
;;; Empirical mean: 0.21027805992889792
;;; Empirical variance: 0.16606119744143671
;;; Empirical std: 0.4075060704350755
;;; Empirical skewness: 1.421926990004244
;;; Empirical kurtosis: 3.0218763649025284
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 4
;;; Elapsed time: 1974.811085 ms
;;; Empirical mean: 0.22515868195729574
;;; Empirical variance: 0.1744622498965491
;;; Empirical std: 0.4176867844408644
;;; Empirical skewness: 1.316016346605843
;;; Empirical kurtosis: 2.73189902453379
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 5
;;; Elapsed time: 1998.473488 ms
;;; Empirical mean: 0.21380167168931571
;;; Empirical variance: 0.16809051687216975
;;; Empirical std: 0.4099884350468556
;;; Empirical skewness: 1.3961287872814072
;;; Empirical kurtosis: 2.9491755906758526
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 6
;;; Elapsed time: 1940.92942 ms
;;; Empirical mean: 0.21418885510148566
;;; Empirical variance: 0.16831198945180043
;;; Empirical std: 0.4102584422675546
;;; Empirical skewness: 1.393322430216412
;;; Empirical kurtosis: 2.941347394544169
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 7
;;; Elapsed time: 1997.420588 ms
;;; Empirical mean: 0.23427332130328096
;;; Empirical variance: 0.17938933222881065
;;; Empirical std: 0.4235437784088094
;;; Empirical skewness: 1.2547778635541027
;;; Empirical kurtosis: 2.574467486865398
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 8
;;; Elapsed time: 2041.25889 ms
;;; Empirical mean: 0.20083478138355376
;;; Empirical variance: 0.16050017197017388
;;; Empirical std: 0.40062472710776836
;;; Empirical skewness: 1.4934935283511377
;;; Empirical kurtosis: 3.230522919226731
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 9
;;; Elapsed time: 2046.158722 ms
;;; Empirical mean: 0.24348347805891535
;;; Empirical variance: 0.18419927397124905
;;; Empirical std: 0.42918442885459984
;;; Empirical skewness: 1.1953673278672834
;;; Empirical kurtosis: 2.4289030485325687
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 10
;;; Elapsed time: 1970.115464 ms
;;; Empirical mean: 0.24513539963479716
;;; Empirical variance: 0.18504403548068546
;;; Empirical std: 0.43016745051280375
;;; Empirical skewness: 1.1849553008317022
;;; Empirical kurtosis: 2.4041190649691493
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 11
;;; Elapsed time: 2019.605572 ms
;;; Empirical mean: 0.24315025476952207
;;; Empirical variance: 0.18402820837503855
;;; Empirical std: 0.4289850910871362
;;; Empirical skewness: 1.1974763252474252
;;; Empirical kurtosis: 2.433949549528077
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 12
;;; Elapsed time: 2025.961423 ms
;;; Empirical mean: 0.23644531971198196
;;; Empirical variance: 0.1805389304982806
;;; Empirical std: 0.42489872969718395
;;; Empirical skewness: 1.2405529217554863
;;; Empirical kurtosis: 2.5389715516760734
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 13
;;; Elapsed time: 1966.192937 ms
;;; Empirical mean: 0.2511579807631858
;;; Empirical variance: 0.18807764946214495
;;; Empirical std: 0.43367920109470887
;;; Empirical skewness: 1.1475856744279092
;;; Empirical kurtosis: 2.3169528801521593
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 14
;;; Elapsed time: 1997.816727 ms
;;; Empirical mean: 0.21686767433122028
;;; Empirical variance: 0.16983608616138804
;;; Empirical std: 0.41211173989755256
;;; Empirical skewness: 1.3740561030324636
;;; Empirical kurtosis: 2.88803017428076
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 15
;;; Elapsed time: 1964.549243 ms
;;; Empirical mean: 0.22390596961358997
;;; Empirical variance: 0.1737720863849881
;;; Empirical std: 0.4168597922383353
;;; Empirical skewness: 1.324637374614226
;;; Empirical kurtosis: 2.7546641742248683
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 16
;;; Elapsed time: 1972.209421 ms
;;; Empirical mean: 0.19530952521728914
;;; Empirical variance: 0.15716371457668626
;;; Empirical std: 0.3964387904540703
;;; Empirical skewness: 1.5371375461706276
;;; Empirical kurtosis: 3.362791835847459
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 17
;;; Elapsed time: 1927.069987 ms
;;; Empirical mean: 0.21537557710338612
;;; Empirical variance: 0.16898893789076952
;;; Empirical std: 0.41108264119367716
;;; Empirical skewness: 1.3847552505264566
;;; Empirical kurtosis: 2.9175471038605894
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 18
;;; Elapsed time: 1977.820657 ms
;;; Empirical mean: 0.24761933581284737
;;; Empirical variance: 0.1863040003444517
;;; Empirical std: 0.4316294711259319
;;; Empirical skewness: 1.169432029415425
;;; Empirical kurtosis: 2.3675712714226793
;;; 
;;; Method :smc with options [:number-of-particles 20]
;;; Chain no. 19
;;; Elapsed time: 2123.782611 ms
;;; Empirical mean: 0.23248953618533147
;;; Empirical variance: 0.1784381517496609
;;; Empirical std: 0.42241940266713707
;;; Empirical skewness: 1.2665633355173538
;;; Empirical kurtosis: 2.6041826828768446
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 0
;;; Elapsed time: 740.355311 ms
;;; Empirical mean: 0.19899999999999998
;;; Empirical variance: 0.159399
;;; Empirical std: 0.399248043201216
;;; Empirical skewness: 1.507834566133615
;;; Empirical kurtosis: 3.273565078827347
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 1
;;; Elapsed time: 743.265843 ms
;;; Empirical mean: 0.2399999999999998
;;; Empirical variance: 0.1823999999999999
;;; Empirical std: 0.4270831300812523
;;; Empirical skewness: 1.2175615550562038
;;; Empirical kurtosis: 2.4824561403508807
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 2
;;; Elapsed time: 730.179815 ms
;;; Empirical mean: 0.572
;;; Empirical variance: 0.24481599999999995
;;; Empirical std: 0.49478884385159694
;;; Empirical skewness: -0.2910332393088274
;;; Empirical kurtosis: 1.084700346382589
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 3
;;; Elapsed time: 726.202238 ms
;;; Empirical mean: 0.48000000000000004
;;; Empirical variance: 0.24960000000000004
;;; Empirical std: 0.4995998398718719
;;; Empirical skewness: 0.0800640769025435
;;; Empirical kurtosis: 1.0064102564102564
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 4
;;; Elapsed time: 740.798068 ms
;;; Empirical mean: 0.32399999999999973
;;; Empirical variance: 0.2190239999999999
;;; Empirical std: 0.4679999999999999
;;; Empirical skewness: 0.7521367521367537
;;; Empirical kurtosis: 1.565709693914824
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 5
;;; Elapsed time: 739.541448 ms
;;; Empirical mean: 0.15099999999999997
;;; Empirical variance: 0.12819899999999995
;;; Empirical std: 0.35804887934470614
;;; Empirical skewness: 1.9494545026295451
;;; Empirical kurtosis: 4.800372857822607
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 6
;;; Elapsed time: 714.865924 ms
;;; Empirical mean: 0.17299999999999996
;;; Empirical variance: 0.14307099999999998
;;; Empirical std: 0.3782472736187268
;;; Empirical skewness: 1.7290276642132052
;;; Empirical kurtosis: 3.989536663614572
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 7
;;; Elapsed time: 705.306648 ms
;;; Empirical mean: 0.16799999999999998
;;; Empirical variance: 0.139776
;;; Empirical std: 0.37386628625753354
;;; Empirical skewness: 1.7760360439202887
;;; Empirical kurtosis: 4.15430402930403
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 8
;;; Elapsed time: 721.634339 ms
;;; Empirical mean: 0.26399999999999985
;;; Empirical variance: 0.19430399999999998
;;; Empirical std: 0.44079927404658914
;;; Empirical skewness: 1.0707821627449265
;;; Empirical kurtosis: 2.1465744400527016
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 9
;;; Elapsed time: 708.456854 ms
;;; Empirical mean: 0.24599999999999983
;;; Empirical variance: 0.18548399999999993
;;; Empirical std: 0.4306785344082056
;;; Empirical skewness: 1.1795340594302939
;;; Empirical kurtosis: 2.391300597356109
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 10
;;; Elapsed time: 716.172799 ms
;;; Empirical mean: 0.296
;;; Empirical variance: 0.20838399999999996
;;; Empirical std: 0.45649096376598736
;;; Empirical skewness: 0.8937745374717964
;;; Empirical kurtosis: 1.7988329238329237
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 11
;;; Elapsed time: 797.04551 ms
;;; Empirical mean: 0.18299999999999997
;;; Empirical variance: 0.149511
;;; Empirical std: 0.38666652298847903
;;; Empirical skewness: 1.6396557816795807
;;; Empirical kurtosis: 3.6884710823952758
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 12
;;; Elapsed time: 782.441916 ms
;;; Empirical mean: 0.29499999999999993
;;; Empirical variance: 0.20797499999999997
;;; Empirical std: 0.45604276115294273
;;; Empirical skewness: 0.899038500169283
;;; Empirical kurtosis: 1.8082702247866336
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 13
;;; Elapsed time: 719.109326 ms
;;; Empirical mean: 0.30299999999999994
;;; Empirical variance: 0.21119099999999996
;;; Empirical std: 0.4595552197505757
;;; Empirical skewness: 0.8573507231924038
;;; Empirical kurtosis: 1.7350502625585376
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 14
;;; Elapsed time: 745.81278 ms
;;; Empirical mean: 0.2189999999999999
;;; Empirical variance: 0.17103899999999994
;;; Empirical std: 0.4135686158305535
;;; Empirical skewness: 1.3589038879832742
;;; Empirical kurtosis: 2.8466197767760586
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 15
;;; Elapsed time: 727.81506 ms
;;; Empirical mean: 0.3919999999999997
;;; Empirical variance: 0.23833599999999994
;;; Empirical std: 0.4881966816765554
;;; Empirical skewness: 0.4424446296075133
;;; Empirical kurtosis: 1.195757250268529
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 16
;;; Elapsed time: 699.186163 ms
;;; Empirical mean: 0.6590000000000004
;;; Empirical variance: 0.22471899999999992
;;; Empirical std: 0.47404535647973595
;;; Empirical skewness: -0.6708218858243248
;;; Empirical kurtosis: 1.4500020025009035
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 17
;;; Elapsed time: 740.528048 ms
;;; Empirical mean: 0.29299999999999987
;;; Empirical variance: 0.2071509999999999
;;; Empirical std: 0.4551384404771804
;;; Empirical skewness: 0.9096133465807695
;;; Empirical kurtosis: 1.827396440277868
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 18
;;; Elapsed time: 750.68224 ms
;;; Empirical mean: 0.34999999999999964
;;; Empirical variance: 0.2274999999999999
;;; Empirical std: 0.4769696007084727
;;; Empirical skewness: 0.628970902033153
;;; Empirical kurtosis: 1.3956043956043986
;;; 
;;; Method :pgibbs with options []
;;; Chain no. 19
;;; Elapsed time: 763.118882 ms
;;; Empirical mean: 0.3799999999999996
;;; Empirical variance: 0.23559999999999987
;;; Empirical std: 0.48538644398046377
;;; Empirical skewness: 0.49445138605819894
;;; Empirical kurtosis: 1.2444821731748736
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 0
;;; Elapsed time: 3831.937617 ms
;;; Empirical mean: 0.3433716236621284
;;; Empirical variance: 0.22546755172576205
;;; Empirical std: 0.4748342360506054
;;; Empirical skewness: 0.659718126648218
;;; Empirical kurtosis: 1.4352280066282346
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 1
;;; Elapsed time: 3988.606181 ms
;;; Empirical mean: 0.3180455750011995
;;; Empirical variance: 0.21689258722335591
;;; Empirical std: 0.46571728250447814
;;; Empirical skewness: 0.7813943430241971
;;; Empirical kurtosis: 1.6105771193102165
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 2
;;; Elapsed time: 3881.596148 ms
;;; Empirical mean: 0.275754279624966
;;; Empirical variance: 0.19971385689348206
;;; Empirical std: 0.446893563271482
;;; Empirical skewness: 1.0035755213543218
;;; Empirical kurtosis: 2.0071638270615986
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 3
;;; Elapsed time: 4392.472445 ms
;;; Empirical mean: 0.30900766084254383
;;; Empirical variance: 0.21352192638316322
;;; Empirical std: 0.46208432821635836
;;; Empirical skewness: 0.8266557746924035
;;; Empirical kurtosis: 1.6833597698322986
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 4
;;; Elapsed time: 4157.607022 ms
;;; Empirical mean: 0.30016621531692855
;;; Empirical variance: 0.21006645849923983
;;; Empirical std: 0.4583300759269894
;;; Empirical skewness: 0.8720081669478063
;;; Empirical kurtosis: 1.760398243223674
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 5
;;; Elapsed time: 4039.531427 ms
;;; Empirical mean: 0.2934677984143687
;;; Empirical variance: 0.20734444970819213
;;; Empirical std: 0.4553509083203767
;;; Empirical skewness: 0.907134246629498
;;; Empirical kurtosis: 1.8228925414080672
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 6
;;; Elapsed time: 4208.571574 ms
;;; Empirical mean: 0.26672864268045793
;;; Empirical variance: 0.19558447385429853
;;; Empirical std: 0.44224933448711773
;;; Empirical skewness: 1.0549314114404256
;;; Empirical kurtosis: 2.112880282843689
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 7
;;; Elapsed time: 4119.150573 ms
;;; Empirical mean: 0.3494999402475688
;;; Empirical variance: 0.22734973201451464
;;; Empirical std: 0.4768120510374236
;;; Empirical skewness: 0.6312762415504423
;;; Empirical kurtosis: 1.3985096931460526
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 8
;;; Elapsed time: 4181.612752 ms
;;; Empirical mean: 0.31936120270392515
;;; Empirical variance: 0.21736962491142756
;;; Empirical std: 0.46622915493502504
;;; Empirical skewness: 0.7748927555645856
;;; Empirical kurtosis: 1.600458782626476
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 9
;;; Elapsed time: 4256.48244 ms
;;; Empirical mean: 0.29331330123301563
;;; Empirical variance: 0.2072806085528059
;;; Empirical std: 0.45528080187155473
;;; Empirical skewness: 0.907952621403507
;;; Empirical kurtosis: 1.8243779627135
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 10
;;; Elapsed time: 4679.239816 ms
;;; Empirical mean: 0.34141583513970275
;;; Empirical variance: 0.2248510626555621
;;; Empirical std: 0.4741846292907037
;;; Empirical skewness: 0.6688709631837332
;;; Empirical kurtosis: 1.4473883653903348
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 11
;;; Elapsed time: 4373.531183 ms
;;; Empirical mean: 0.3066201436346888
;;; Empirical variance: 0.21260423115213162
;;; Empirical std: 0.46109026356249555
;;; Empirical skewness: 0.8387939266867682
;;; Empirical kurtosis: 1.7035752514466078
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 12
;;; Elapsed time: 4193.460402 ms
;;; Empirical mean: 0.4180672088932055
;;; Empirical variance: 0.24328701774145037
;;; Empirical std: 0.4932413382325638
;;; Empirical skewness: 0.33222191554497477
;;; Empirical kurtosis: 1.1103714011683719
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 13
;;; Elapsed time: 4450.610082 ms
;;; Empirical mean: 0.28042954994660907
;;; Empirical variance: 0.2017888174633514
;;; Empirical std: 0.44920910215995336
;;; Empirical skewness: 0.9775868253676071
;;; Empirical kurtosis: 1.9556760011323162
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 14
;;; Elapsed time: 4451.836494 ms
;;; Empirical mean: 0.2596370197661621
;;; Empirical variance: 0.19222563773310766
;;; Empirical std: 0.43843544306215443
;;; Empirical skewness: 1.096457798005911
;;; Empirical kurtosis: 2.202219702807971
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 15
;;; Elapsed time: 4424.848586 ms
;;; Empirical mean: 0.29462045643356616
;;; Empirical variance: 0.20781924308444327
;;; Empirical std: 0.4558719590898779
;;; Empirical skewness: 0.9010404762620726
;;; Empirical kurtosis: 1.8118739398625823
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 16
;;; Elapsed time: 4176.318788 ms
;;; Empirical mean: 0.27663979467651445
;;; Empirical variance: 0.20011021867785037
;;; Empirical std: 0.4473368067551008
;;; Empirical skewness: 0.9986220760312553
;;; Empirical kurtosis: 1.9972460507369743
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 17
;;; Elapsed time: 4379.011801 ms
;;; Empirical mean: 0.3705509360865559
;;; Empirical variance: 0.2332429398519331
;;; Empirical std: 0.48295231633354146
;;; Empirical skewness: 0.5360738919162473
;;; Empirical kurtosis: 1.2873752175942323
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 18
;;; Elapsed time: 4370.642876 ms
;;; Empirical mean: 0.30851887304713504
;;; Empirical variance: 0.21333497802086082
;;; Empirical std: 0.4618819957747442
;;; Empirical skewness: 0.829134405343864
;;; Empirical kurtosis: 1.6874638621249223
;;; 
;;; Method :ipmcmc with options []
;;; Chain no. 19
;;; Elapsed time: 4600.386592 ms
;;; Empirical mean: 0.30324763663244003
;;; Empirical variance: 0.21128850750927963
;;; Empirical std: 0.45966129651002774
;;; Empirical skewness: 0.8560753966514025
;;; Empirical kurtosis: 1.7328650847518556
;;; 
;;; Method :importance with options []
;;; Chain no. 0
;;; Elapsed time: 35589.31911 ms
;;; Empirical mean: 0.3201000000000002
;;; Empirical variance: 0.21763599000000006
;;; Empirical std: 0.46651472645566083
;;; Empirical skewness: 0.7712511086918413
;;; Empirical kurtosis: 1.5948282726583947
;;; 
;;; Method :importance with options []
;;; Chain no. 1
;;; Elapsed time: 36022.108865 ms
;;; Empirical mean: 0.30949999999999966
;;; Empirical variance: 0.21370974999999987
;;; Empirical std: 0.4622875187586183
;;; Empirical skewness: 0.8241624195762428
;;; Empirical kurtosis: 1.679243693841767
;;; 
;;; Method :importance with options []
;;; Chain no. 2
;;; Elapsed time: 35731.47856 ms
;;; Empirical mean: 0.31910000000000016
;;; Empirical variance: 0.21727519000000003
;;; Empirical std: 0.4661278687227358
;;; Empirical skewness: 0.7761818682744477
;;; Empirical kurtosis: 1.602458292638012
;;; 
;;; Method :importance with options []
;;; Chain no. 3
;;; Elapsed time: 37236.546739 ms
;;; Empirical mean: 0.32320000000000015
;;; Empirical variance: 0.21874176000000006
;;; Empirical std: 0.4676983643332528
;;; Empirical skewness: 0.7560428407828391
;;; Empirical kurtosis: 1.5716007770989855
;;; 
;;; Method :importance with options []
;;; Chain no. 4
;;; Elapsed time: 35682.430428 ms
;;; Empirical mean: 0.3274000000000003
;;; Empirical variance: 0.22020924000000008
;;; Empirical std: 0.469264573561653
;;; Empirical skewness: 0.7356191356615295
;;; Empirical kurtosis: 1.541135512751416
;;; 
;;; Method :importance with options []
;;; Chain no. 5
;;; Elapsed time: 37142.641876 ms
;;; Empirical mean: 0.3192000000000002
;;; Empirical variance: 0.2173113600000001
;;; Empirical std: 0.4661666654749137
;;; Empirical skewness: 0.7756882393802537
;;; Empirical kurtosis: 1.6016922447128374
;;; 
;;; Method :importance with options []
;;; Chain no. 6
;;; Elapsed time: 35956.31668 ms
;;; Empirical mean: 0.32370000000000015
;;; Empirical variance: 0.21891831000000006
;;; Empirical std: 0.46788706970806543
;;; Empirical skewness: 0.7536006503022232
;;; Empirical kurtosis: 1.5679139401359334
;;; 
;;; Method :importance with options []
;;; Chain no. 7
;;; Elapsed time: 36032.741575 ms
;;; Empirical mean: 0.32750000000000035
;;; Empirical variance: 0.22024375000000013
;;; Empirical std: 0.4693013424229683
;;; Empirical skewness: 0.7351353358990829
;;; Empirical kurtosis: 1.5404239620874576
;;; 
;;; Method :importance with options []
;;; Chain no. 8
;;; Elapsed time: 36884.237726 ms
;;; Empirical mean: 0.31580000000000014
;;; Empirical variance: 0.21607036000000007
;;; Empirical std: 0.46483369068947666
;;; Empirical skewness: 0.7925415205028725
;;; Empirical kurtosis: 1.628122061721005
;;; 
;;; Method :importance with options []
;;; Chain no. 9
;;; Elapsed time: 36570.689531 ms
;;; Empirical mean: 0.31830000000000025
;;; Empirical variance: 0.2169851100000001
;;; Empirical std: 0.4658166055434264
;;; Empirical skewness: 0.7801353487088621
;;; Empirical kurtosis: 1.6086111623050976
;;; 
;;; Method :importance with options []
;;; Chain no. 10
;;; Elapsed time: 37333.943484 ms
;;; Empirical mean: 0.33000000000000035
;;; Empirical variance: 0.22110000000000019
;;; Empirical std: 0.4702127178203501
;;; Empirical skewness: 0.7230769971004909
;;; Empirical kurtosis: 1.522840343735863
;;; 
;;; Method :importance with options []
;;; Chain no. 11
;;; Elapsed time: 35501.300528 ms
;;; Empirical mean: 0.32140000000000013
;;; Empirical variance: 0.21810204000000005
;;; Empirical std: 0.46701396124741285
;;; Empirical skewness: 0.7648593610475891
;;; Empirical kurtosis: 1.5850098421821261
;;; 
;;; Method :importance with options []
;;; Chain no. 12
;;; Elapsed time: 37146.778419 ms
;;; Empirical mean: 0.31950000000000023
;;; Empirical variance: 0.21741975000000008
;;; Empirical std: 0.46628290768588126
;;; Empirical skewness: 0.7742080913744168
;;; Empirical kurtosis: 1.5993981687496175
;;; 
;;; Method :importance with options []
;;; Chain no. 13
;;; Elapsed time: 36787.149103 ms
;;; Empirical mean: 0.31970000000000026
;;; Empirical variance: 0.21749191000000004
;;; Empirical std: 0.4663602791833799
;;; Empirical skewness: 0.7732219404093074
;;; Empirical kurtosis: 1.5978721691303346
;;; 
;;; Method :importance with options []
;;; Chain no. 14
;;; Elapsed time: 36584.583691 ms
;;; Empirical mean: 0.3190000000000002
;;; Empirical variance: 0.21723900000000007
;;; Empirical std: 0.466089047286031
;;; Empirical skewness: 0.7766756204804067
;;; Empirical kurtosis: 1.603225019448625
;;; 
;;; Method :importance with options []
;;; Chain no. 15
;;; Elapsed time: 36795.507705 ms
;;; Empirical mean: 0.3220000000000001
;;; Empirical variance: 0.2183160000000001
;;; Empirical std: 0.46724297747531757
;;; Empirical skewness: 0.7619162131094966
;;; Empirical kurtosis: 1.5805163157991156
;;; 
;;; Method :importance with options []
;;; Chain no. 16
;;; Elapsed time: 35927.652284 ms
;;; Empirical mean: 0.3202000000000002
;;; Empirical variance: 0.21767196000000003
;;; Empirical std: 0.4665532767005286
;;; Empirical skewness: 0.7707587063648895
;;; Empirical kurtosis: 1.5940689834372788
;;; 
;;; Method :importance with options []
;;; Chain no. 17
;;; Elapsed time: 37108.790209 ms
;;; Empirical mean: 0.32450000000000023
;;; Empirical variance: 0.21919975000000008
;;; Empirical std: 0.4681877294419409
;;; Empirical skewness: 0.7496992721666925
;;; Empirical kurtosis: 1.562048998687268
;;; 
;;; Method :importance with options []
;;; Chain no. 18
;;; Elapsed time: 37579.703527 ms
;;; Empirical mean: 0.31159999999999966
;;; Empirical variance: 0.21450543999999988
;;; Empirical std: 0.4631473199749728
;;; Empirical skewness: 0.813564029735424
;;; Empirical kurtosis: 1.6618864304793417
;;; 
;;; Method :importance with options []
;;; Chain no. 19
;;; Elapsed time: 37573.342684 ms
;;; Empirical mean: 0.32670000000000043
;;; Empirical variance: 0.21996711000000016
;;; Empirical std: 0.4690065138140409
;;; Empirical skewness: 0.7390089258705363
;;; Empirical kurtosis: 1.5461341925163241
;;; 
;;; Method :lmh with options []
;;; Chain no. 0
;;; Elapsed time: 6955.13527 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 1
;;; Elapsed time: 6794.653723 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 2
;;; Elapsed time: 6848.374788 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 3
;;; Elapsed time: 6964.002262 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 4
;;; Elapsed time: 7127.621433 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 5
;;; Elapsed time: 7198.561048 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 6
;;; Elapsed time: 7103.674266 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 7
;;; Elapsed time: 6883.26496 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 8
;;; Elapsed time: 6730.637632 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 9
;;; Elapsed time: 6757.882246 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 10
;;; Elapsed time: 6855.65472 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 11
;;; Elapsed time: 6817.971493 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 12
;;; Elapsed time: 6707.731488 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 13
;;; Elapsed time: 6926.549646 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 14
;;; Elapsed time: 7175.952148 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 15
;;; Elapsed time: 7191.604817 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 16
;;; Elapsed time: 7250.42282 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 17
;;; Elapsed time: 6887.445765 ms
;;; Empirical mean: 1.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 18
;;; Elapsed time: 6742.68781 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :lmh with options []
;;; Chain no. 19
;;; Elapsed time: 6993.703747 ms
;;; Empirical mean: 0.0
;;; Empirical variance: 0.0
;;; Empirical std: 0.0
;;; Empirical skewness: NaN
;;; Empirical kurtosis: NaN
;;; 
;;; Method :smc with options []
;;; Chain no. 0
;;; Elapsed time: 51207.204583 ms
;;; Empirical mean: 0.31860000000000027
;;; Empirical variance: 0.21709404000000015
;;; Empirical std: 0.4659335145704805
;;; Empirical skewness: 0.7786518648147591
;;; Empirical kurtosis: 1.6062987265795015
;;; 
;;; Method :smc with options []
;;; Chain no. 1
;;; Elapsed time: 50772.297944 ms
;;; Empirical mean: 0.32700000000000046
;;; Empirical variance: 0.2200710000000002
;;; Empirical std: 0.46911725613113
;;; Empirical skewness: 0.7375554735579445
;;; Empirical kurtosis: 1.5439880765752838
;;; 
;;; Method :smc with options []
;;; Chain no. 2
;;; Elapsed time: 50272.039673 ms
;;; Empirical mean: 0.32750000000000035
;;; Empirical variance: 0.22024375000000013
;;; Empirical std: 0.4693013424229683
;;; Empirical skewness: 0.7351353358990829
;;; Empirical kurtosis: 1.5404239620874576
;;; 
;;; Method :smc with options []
;;; Chain no. 3
;;; Elapsed time: 50405.702564 ms
;;; Empirical mean: 0.3246000000000003
;;; Empirical variance: 0.21923484000000015
;;; Empirical std: 0.46822520222645014
;;; Empirical skewness: 0.7492121276939305
;;; Empirical kurtosis: 1.5613188122836665
;;; 
;;; Method :smc with options []
;;; Chain no. 4
;;; Elapsed time: 52511.920141 ms
;;; Empirical mean: 0.32210000000000005
;;; Empirical variance: 0.21835159
;;; Empirical std: 0.4672810610328649
;;; Empirical skewness: 0.7614261087610736
;;; Empirical kurtosis: 1.5797697191030304
;;; 
;;; Method :smc with options []
;;; Chain no. 5
;;; Elapsed time: 51768.934572 ms
;;; Empirical mean: 0.31830000000000025
;;; Empirical variance: 0.2169851100000001
;;; Empirical std: 0.4658166055434264
;;; Empirical skewness: 0.7801353487088621
;;; Empirical kurtosis: 1.6086111623050976
;;; 
;;; Method :smc with options []
;;; Chain no. 6
;;; Elapsed time: 51459.033344 ms
;;; Empirical mean: 0.32790000000000036
;;; Empirical variance: 0.22038159000000015
;;; Empirical std: 0.469448176053545
;;; Empirical skewness: 0.7332012723822791
;;; Empirical kurtosis: 1.537584105822993
;;; 
;;; Method :smc with options []
;;; Chain no. 7
;;; Elapsed time: 50841.922209 ms
;;; Empirical mean: 0.3152000000000002
;;; Empirical variance: 0.2158489600000001
;;; Empirical std: 0.46459547996079353
;;; Empirical skewness: 0.7955307701899932
;;; Empirical kurtosis: 1.6328692063190837
;;; 
;;; Method :smc with options []
;;; Chain no. 8
;;; Elapsed time: 50734.462005 ms
;;; Empirical mean: 0.3152000000000002
;;; Empirical variance: 0.2158489600000001
;;; Empirical std: 0.46459547996079353
;;; Empirical skewness: 0.7955307701899932
;;; Empirical kurtosis: 1.6328692063190837
;;; 
;;; Method :smc with options []
;;; Chain no. 9
;;; Elapsed time: 50977.269984 ms
;;; Empirical mean: 0.32230000000000014
;;; Empirical variance: 0.21842271000000005
;;; Empirical std: 0.46735715464727834
;;; Empirical skewness: 0.7604462592815671
;;; Empirical kurtosis: 1.5782785132553285
;;; 
;;; Method :smc with options []
;;; Chain no. 10
;;; Elapsed time: 52087.976389 ms
;;; Empirical mean: 0.3124999999999999
;;; Empirical variance: 0.21484374999999994
;;; Empirical std: 0.4635124054434789
;;; Empirical skewness: 0.8090398349558907
;;; Empirical kurtosis: 1.654545454545455
;;; 
;;; Method :smc with options []
;;; Chain no. 11
;;; Elapsed time: 54833.897838 ms
;;; Empirical mean: 0.3144
;;; Empirical variance: 0.21555264000000002
;;; Empirical std: 0.46427646935850625
;;; Empirical skewness: 0.799523612542521
;;; Empirical kurtosis: 1.6392380070130435
;;; 
;;; Method :smc with options []
;;; Chain no. 12
;;; 
;; <-
;; =>
;;; {"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"list-like","open":"","close":"","separator":"</pre><pre>","items":[{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x93effc]</span>","value":"#multifn[print-method 0x93effc]"}],"value":"[nil,#multifn[print-method 0x93effc]]"},{"type":"html","content":"<span class='clj-unkown'>#multifn[print-method 0x93effc]</span>","value":"#multifn[print-method 0x93effc]"}],"value":"[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model</span>","value":"#'model/model"}],"value":"[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/model_name</span>","value":"#'model/model_name"}],"value":"[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/outfile</span>","value":"#'model/outfile"}],"value":"[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/configurations</span>","value":"#'model/configurations"}],"value":"[[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num_samples_options</span>","value":"#'model/num_samples_options"}],"value":"[[[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/thinning</span>","value":"#'model/thinning"}],"value":"[[[[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning]"},{"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}],"value":"[[[[[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil]"},{"type":"html","content":"<span class='clj-var'>#&#x27;model/num-chains</span>","value":"#'model/num-chains"}],"value":"[[[[[[[[[[nil,#multifn[print-method 0x93effc]],#multifn[print-method 0x93effc]],#'model/model],#'model/model_name],#'model/outfile],#'model/configurations],#'model/num_samples_options],#'model/thinning],nil],#'model/num-chains]"}
;; <=

;; @@

;; @@
