
data=/root/codespace/benchmark-it/benchmark_data/imagenet_val_5k.txt
gpu=1

###### mae #######
model="mae_vit"
model_weights="/root/codespace/benchmark-it/training/results/result_mae_vit_yellow/model.pd"

# bt
it=bt
sl=4

CUDA_VISIBLE_DEVICES=${gpu} nohup python evaluate_pgs.py --name ${it}-token --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it bt --save_eval_result 1 --it_configs "{\"start_layer\": ${sl}, \"ap_mode\": \"token\"}" >> output/eval-psg-${model}-${it}-token.log &    
pid[$gpu]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

CUDA_VISIBLE_DEVICES=${gpu} nohup python evaluate_pgs.py --name ${it}-head --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it bt --save_eval_result 1 --it_configs "{\"start_layer\": ${sl}, \"ap_mode\": \"head\"}" >> output/eval-psg-${model}-${it}-head.log &    
pid[$gpu]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi


# ga
it=ga
sl=4

CUDA_VISIBLE_DEVICES=${gpu} nohup python evaluate_pgs.py --name ${it}-${sl} --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it ga --save_eval_result 1 --it_configs "{\"start_layer\": ${sl}}" >> output/eval-psg-${model}-${it}.log &
pid[$gpu]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

##### sg #####
it=smoothgrad

CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it smoothgrad --it_configs "{\"noise_amount\": 0.001, \"n_samples\": 100}" --save_eval_result 1 >> output/eval-psg-${model}-${it}.log &
pid[$n]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --name 'smoothgrad-sq' --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it smoothgrad --it_configs "{\"noise_amount\": 0.001, \"n_samples\": 100}" --save_eval_result 1 >> output/eval-psg-${model}-${it}-sq.log &
pid[$n]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi


##### ig #####
it=intgrad

CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it intgrad --it_configs "{\"num_random_trials\": 5, \"baselines\": \"random\", \"steps\": 20}" --save_eval_result 1 >> output/eval-psg-${model}-${it}.log &
pid[$n]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi

CUDA_VISIBLE_DEVICES=$((gpu)) nohup python evaluate_pgs.py --name 'intgrad-sq' --data_list $data --model ${model} --num_classes 2 --model_weights ${model_weights} --it intgrad --it_configs "{\"num_random_trials\": 5, \"baselines\": \"random\", \"steps\": 20}" --save_eval_result 1 >> output/eval-psg-${model}-${it}-sq.log &
pid[$n]=$!
echo $gpu start: pid=$!
gpu=$((gpu+1))
if [[ $gpu -eq 8 ]]; then gpu=0; echo "8 tasks are running."; wait; fi
