""" 
Compare causal structure learning performances
"""
import CDExperimentSuite_DEV as CDES
from copy import deepcopy


def data(opt):
    """Data Generation"""
    dg = CDES.DataGenerator()
    dg.generate_and_save(opt)


def experiment(opt):
    """Experiment"""
    expR = CDES.ExperimentRunner(opt)
    expR.sortnregressIC_R2()
    expR.sortnregressIC()
    expR.randomregressIC()


def evaluate(opt):
    """Evaluation"""
    if isinstance(opt.thres, list):
        for i in opt.thres:
            opt_tmp = deepcopy(opt)._asdict()
            opt_tmp["thres"] = i
            opt_tmp = CDES.utils.Options(**opt_tmp)
            CDES.Evaluator(opt_tmp).evaluate(thresholding=opt_tmp.thres_type)
    else:
        CDES.Evaluator(opt).evaluate(thresholding=opt.thres_type)


def visualize(opt):
    """Visualization"""
    viz = CDES.Visualizer(opt)
    acc_measures = ["shd"]
    if opt.MEC:
        acc_measures += ["mec_sid", "mec_shd"]
    for acc_measure in acc_measures:
        viz.boxplot(
            acc_measure=acc_measure, filters={}, custom_name="", static_xlim=False
        )


def viz_compare(opt, opt_raw, opt_std):
    """do an x vs. y evaluation"""
    opt["exp_name"] = [opt_raw.exp_name, opt_std.exp_name]
    opt["scaler"] = None
    filters = {
        "algorithm": [
            "sortnregressIC_R2",
            "sortnregressIC",
            "randomregressIC",
        ]
    }
    acc_measures = ["shd"]  # "sid", "sid_upper", "sid_lower"]
    if opt["MEC"]:
        acc_measures += ["mec_sid", "mec_sid_lower", "mec_sid_upper", "mec_shd"]

    t = opt["thres"] if isinstance(opt["thres"], list) else [opt["thres"]]
    for i in t:
        opt_tmp = deepcopy(opt)
        opt_tmp["thres"] = i
        opt_tmp = CDES.utils.Options(**opt_tmp)
        viz = CDES.Visualizer(opt_tmp)
        for acc_measure in acc_measures:
            viz.boxplot(
                acc_measure=acc_measure,
                filters=filters,
                custom_name="",
                static_xlim=False,
            )
