# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from bosot.configs.models.base_model_config import BaseModelConfig
from bosot.configs.kernels.base_kernel_config import BaseKernelConfig
from bosot.models.gp_model_laplace import PredictionType


class BasicGPModelLaplaceConfig(BaseModelConfig):
    kernel_config: BaseKernelConfig
    observation_noise: float = 0.01
    expected_observation_noise: float = 0.1
    train_likelihood_variance: bool = True
    pertube_parameters_at_start: bool = True
    perform_multi_start_optimization: bool = True
    prediction_type: PredictionType = PredictionType.NORMAL_APPROXIMATION
    n_starts_for_multistart_opt: int = 5
    pertubation_for_multistart_opt: float = 0.5
    name = "GPModelLaplace"


if __name__ == "__main__":
    pass
