# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from typing import Tuple
from bosot.configs.kernels.base_kernel_config import BaseKernelConfig


class BasicHellingerKernelKernelConfig(BaseKernelConfig):
    base_lengthscale: float = 0.5
    base_variance: float = 1.0
    num_param_samples: int = 100
    num_virtual_points: int = 20
    use_sobol_virtual_points: bool = False
    use_hyperprior: bool = False
    lengthscale_prior_parameters: Tuple[float, float] = (0.1, 0.7)
    variance_prior_parameters: Tuple[float, float] = (0.4, 0.7)
    name = "BasicHellingerKernelKernel"
