# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from abc import ABC, abstractmethod
from typing import List


class CandidateGenerator(ABC):
    @abstractmethod
    def get_initial_candidates_trailing(self) -> List[object]:
        raise NotImplementedError

    @abstractmethod
    def get_random_canditates(self, n_candidates: int, seed=100, set_seed=False) -> List[object]:
        raise NotImplementedError

    @abstractmethod
    def get_additional_candidates_trailing(self, best_current_candidate: object) -> List[object]:
        raise NotImplementedError

    @abstractmethod
    def get_initial_for_evolutionary_opt(self, n_initial):
        raise NotImplementedError

    @abstractmethod
    def get_around_candidate_for_evolutionary_opt(self, candidate: object, n_around_candidate: int):
        raise NotImplementedError

    @abstractmethod
    def get_dataset_recursivly_generated(self, n_data: int, n_per_step: int) -> List[object]:
        raise NotImplementedError
