# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from bosot.configs.kernels.kernel_grammar_generators.base_kernel_grammar_generator_config import BaseKernelGrammarGeneratorConfig
from bosot.configs.kernels.kernel_grammar_generators.cks_high_dim_generator_config import CKSHighDimGeneratorConfig
from bosot.configs.kernels.kernel_grammar_generators.cks_with_rq_generator_config import CKSWithRQGeneratorConfig
from bosot.configs.kernels.kernel_grammar_generators.compositional_kernel_search_configs import CompositionalKernelSearchGeneratorConfig
from bosot.configs.kernels.kernel_grammar_generators.n_dim_full_kernels_generators_configs import NDimFullKernelsGrammarGeneratorConfig
from bosot.kernels.kernel_grammar.kernel_grammar_search_spaces import CKSHighDimSearchSpace, NDimFullKernelsSearchSpace, CKSWithRQSearchSpace, CompositionalKernelSearchSpace
from bosot.kernels.kernel_grammar.kernel_grammar_candidate_generator import KernelGrammarCandidateGenerator


class GeneratorFactory:
    @staticmethod
    def build(generator_config: BaseKernelGrammarGeneratorConfig):
        if isinstance(generator_config, NDimFullKernelsGrammarGeneratorConfig):
            search_space = NDimFullKernelsSearchSpace(generator_config.input_dimension)
            generator = KernelGrammarCandidateGenerator(search_space=search_space, **generator_config.dict())
            return generator
        elif isinstance(generator_config, CompositionalKernelSearchGeneratorConfig):
            search_space = CompositionalKernelSearchSpace(generator_config.input_dimension)
            generator = KernelGrammarCandidateGenerator(search_space=search_space, **generator_config.dict())
            return generator
        elif isinstance(generator_config, CKSWithRQGeneratorConfig):
            search_space = CKSWithRQSearchSpace(generator_config.input_dimension)
            generator = KernelGrammarCandidateGenerator(search_space=search_space, **generator_config.dict())
            return generator
        elif isinstance(generator_config, CKSHighDimGeneratorConfig):
            search_space = CKSHighDimSearchSpace(generator_config.input_dimension)
            generator = KernelGrammarCandidateGenerator(search_space=search_space, **generator_config.dict())
            return generator
