import matplotlib.pyplot as plt
import numpy as np

from octopus.fo_ncf_gd import experiment_fo_ncf_gd
from octopus.zo_ncf_gd import experiment_zo_ncf_gd

iters = 1000
x = [0 + 0.1 for i in range(30)]
print(x)
np.random.seed(50)


fo_ncf_gd_vals = experiment_fo_ncf_gd(x, iters)
zo_ncf_gd_vals = experiment_zo_ncf_gd(x, iters)


plt.rcParams.update({'font.size': 14})
plt.figure(figsize=(8, 8))


plt.plot(fo_ncf_gd_vals, 'o-', label='Neon2+GD')
plt.plot(zo_ncf_gd_vals, 'r--', label='ZO-NCF-GD')


plt.xlabel('Iterations')
plt.ylabel('$f(x_k)$')
plt.legend()
plt.show()