import matplotlib.pyplot as plt
import numpy as np
rc = {"pdf.fonttype": 42, 'text.usetex': True, 'text.latex.preview': True}

plt.rcParams.update(rc)

test_errors = np.load('metrics_conv/error.npy', allow_pickle=True)

test_errors = test_errors[:1000]
p = 0.5
plt.figure(figsize=(5 *  p, 4 * p))
plt.semilogx(test_errors, linewidth=3, color='#99d8c9', label='Test error')
plt.yticks([8, 20, 50], [r'8\%', r'20\%', r'50\%'])
plt.xlabel('Training steps')
plt.ylabel('Test error')

plt.legend()
plt.tight_layout()
plt.savefig('figures/errors_conv.pdf')

Q = np.load('metrics_conv/Q.npy')
plt.figure()
plt.matshow(Q)
plt.axis('off')
plt.savefig('figures/A_conv.pdf')
