/*
 * Decompiled with CFR 0.152.
 */
package levelGenerators.notch;

import engine.core.MarioLevelGenerator;
import engine.core.MarioLevelModel;
import engine.core.MarioTimer;
import java.util.Random;

public class LevelGenerator
implements MarioLevelGenerator {
    private static final int ODDS_STRAIGHT = 0;
    private static final int ODDS_HILL_STRAIGHT = 1;
    private static final int ODDS_TUBES = 2;
    private static final int ODDS_JUMP = 3;
    private static final int ODDS_CANNONS = 4;
    private int[] odds = new int[5];
    private int totalOdds;
    private int difficulty;
    private int type;
    private Random random = new Random();

    public LevelGenerator() {
        this.type = this.random.nextInt(3);
        this.difficulty = this.random.nextInt(5);
    }

    public LevelGenerator(int n, int n2) {
        this.type = n;
        this.difficulty = n2;
    }

    private int buildZone(MarioLevelModel marioLevelModel, int n, int n2) {
        int n3 = this.random.nextInt(this.totalOdds);
        int n4 = 0;
        for (int i = 0; i < this.odds.length; ++i) {
            if (this.odds[i] > n3) continue;
            n4 = i;
        }
        switch (n4) {
            case 0: {
                return this.buildStraight(marioLevelModel, n, n2, false);
            }
            case 1: {
                return this.buildHillStraight(marioLevelModel, n, n2);
            }
            case 2: {
                return this.buildTubes(marioLevelModel, n, n2);
            }
            case 3: {
                return this.buildJump(marioLevelModel, n, n2);
            }
            case 4: {
                return this.buildCannons(marioLevelModel, n, n2);
            }
        }
        return 0;
    }

    private int buildJump(MarioLevelModel marioLevelModel, int n, int n2) {
        int n3 = this.random.nextInt(4) + 2;
        int n4 = this.random.nextInt(2) + 2;
        int n5 = n3 * 2 + n4;
        boolean bl = this.random.nextInt(3) == 0;
        int n6 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        for (int i = n; i < n + n5; ++i) {
            if (i >= n + n3 && i <= n + n5 - n3 - 1) continue;
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                if (j >= n6) {
                    marioLevelModel.setBlock(i, j, 'X');
                    continue;
                }
                if (!bl) continue;
                if (i < n + n3) {
                    if (j < n6 - (i - n) + 1) continue;
                    marioLevelModel.setBlock(i, j, 'X');
                    continue;
                }
                if (j < n6 - (n + n5 - i) + 2) continue;
                marioLevelModel.setBlock(i, j, 'X');
            }
        }
        return n5;
    }

    private int buildCannons(MarioLevelModel marioLevelModel, int n, int n2) {
        int n3 = this.random.nextInt(10) + 2;
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        int n5 = n + 1 + this.random.nextInt(4);
        for (int i = n; i < n + n3; ++i) {
            if (i > n5) {
                n5 += 2 + this.random.nextInt(4);
            }
            if (n5 == n + n3 - 1) {
                n5 += 10;
            }
            int n6 = n4 - this.random.nextInt(4) - 1;
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                if (j >= n4) {
                    marioLevelModel.setBlock(i, j, 'X');
                    continue;
                }
                if (i != n5 || j < n6) continue;
                marioLevelModel.setBlock(i, j, '*');
            }
        }
        return n3;
    }

    private int buildHillStraight(MarioLevelModel marioLevelModel, int n, int n2) {
        int n3;
        int n4;
        int n5 = this.random.nextInt(10) + 10;
        if (n5 > n2) {
            n5 = n2;
        }
        int n6 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        for (n4 = n; n4 < n + n5; ++n4) {
            for (n3 = 0; n3 < marioLevelModel.getHeight(); ++n3) {
                if (n3 < n6) continue;
                marioLevelModel.setBlock(n4, n3, 'X');
            }
        }
        this.addEnemyLine(marioLevelModel, n + 1, n + n5 - 1, n6 - 1);
        n4 = n6;
        n3 = 1;
        boolean[] blArray = new boolean[n5];
        while (n3 != 0) {
            if ((n4 = n4 - 2 - this.random.nextInt(3)) <= 0) {
                n3 = 0;
                continue;
            }
            int n7 = this.random.nextInt(5) + 3;
            int n8 = this.random.nextInt(n5 - n7 - 2) + n + 1;
            if (blArray[n8 - n] || blArray[n8 - n + n7] || blArray[n8 - n - 1] || blArray[n8 - n + n7 + 1]) {
                n3 = 0;
                continue;
            }
            blArray[n8 - n] = true;
            blArray[n8 - n + n7] = true;
            this.addEnemyLine(marioLevelModel, n8, n8 + n7, n4 - 1);
            if (this.random.nextInt(4) == 0) {
                this.decorate(marioLevelModel, n8 - 1, n8 + n7 + 1, n4);
                n3 = 0;
            }
            for (int i = n8; i < n8 + n7; ++i) {
                for (int j = n4; j < n6; ++j) {
                    int n9 = 9;
                    if (j == n4) {
                        n9 = 8;
                    }
                    if (marioLevelModel.getBlock(i, j) != '-') continue;
                    if (n9 == 8) {
                        marioLevelModel.setBlock(i, j, '%');
                        continue;
                    }
                    marioLevelModel.setBlock(i, j, '|');
                }
            }
        }
        return n5;
    }

    private void addEnemyLine(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        char[] cArray = new char[]{'g', 'k', 'r', 'y'};
        for (int i = n; i < n2; ++i) {
            if (this.random.nextInt(35) >= this.difficulty + 1) continue;
            int n4 = this.random.nextInt(4);
            if (this.difficulty < 1) {
                n4 = 0;
            } else if (this.difficulty < 3) {
                n4 = 1 + this.random.nextInt(3);
            }
            marioLevelModel.setBlock(i, n3, MarioLevelModel.getWingedEnemyVersion(cArray[n4], this.random.nextInt(35) < this.difficulty));
        }
    }

    private int buildTubes(MarioLevelModel marioLevelModel, int n, int n2) {
        int n3 = this.random.nextInt(10) + 5;
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        int n5 = n + 1 + this.random.nextInt(4);
        int n6 = n4 - this.random.nextInt(2) - 2;
        for (int i = n; i < n + n3; ++i) {
            if (i > n5 + 1) {
                n5 += 3 + this.random.nextInt(4);
                n6 = n4 - this.random.nextInt(2) - 2;
            }
            if (n5 >= n + n3 - 2) {
                n5 += 10;
            }
            char c = 't';
            if (i == n5 && this.random.nextInt(11) < this.difficulty + 1) {
                c = 'T';
            }
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                if (j >= n4) {
                    marioLevelModel.setBlock(i, j, 'X');
                    continue;
                }
                if (i != n5 && i != n5 + 1 || j < n6) continue;
                marioLevelModel.setBlock(i, j, c);
            }
        }
        return n3;
    }

    private int buildStraight(MarioLevelModel marioLevelModel, int n, int n2, boolean bl) {
        int n3 = this.random.nextInt(10) + 2;
        if (bl) {
            n3 = 10 + this.random.nextInt(5);
        }
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        for (int i = n; i < n + n3; ++i) {
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                if (j < n4) continue;
                marioLevelModel.setBlock(i, j, 'X');
            }
        }
        if (!bl && n3 > 5) {
            this.decorate(marioLevelModel, n, n + n3, n4);
        }
        return n3;
    }

    private void decorate(MarioLevelModel marioLevelModel, int n, int n2, int n3) {
        int n4;
        if (n3 < 1) {
            return;
        }
        boolean bl = true;
        this.addEnemyLine(marioLevelModel, n + 1, n2 - 1, n3 - 1);
        int n5 = this.random.nextInt(4);
        int n6 = this.random.nextInt(4);
        if (n3 - 2 > 0 && n2 - 1 - n6 - (n + 1 + n5) > 1) {
            for (n4 = n + 1 + n5; n4 < n2 - 1 - n6; ++n4) {
                marioLevelModel.setBlock(n4, n3 - 2, 'o');
            }
        }
        n5 = this.random.nextInt(4);
        n6 = this.random.nextInt(4);
        if (n3 - 4 > 0 && n2 - 1 - n6 - (n + 1 + n5) > 2) {
            for (n4 = n + 1 + n5; n4 < n2 - 1 - n6; ++n4) {
                if (!bl) continue;
                if (n4 != n + 1 && n4 != n2 - 2 && this.random.nextInt(3) == 0) {
                    if (this.random.nextInt(4) == 0) {
                        marioLevelModel.setBlock(n4, n3 - 4, 'S');
                        continue;
                    }
                    marioLevelModel.setBlock(n4, n3 - 4, 'S');
                    continue;
                }
                if (this.random.nextInt(4) == 0) {
                    if (this.random.nextInt(4) == 0) {
                        marioLevelModel.setBlock(n4, n3 - 4, 'o');
                        continue;
                    }
                    marioLevelModel.setBlock(n4, n3 - 4, 'o');
                    continue;
                }
                marioLevelModel.setBlock(n4, n3 - 4, 'o');
            }
        }
    }

    @Override
    public String getGeneratedLevel(MarioLevelModel marioLevelModel, MarioTimer marioTimer) {
        int n;
        int n2;
        int n3;
        marioLevelModel.clearMap();
        this.odds[0] = 20;
        this.odds[1] = 10;
        this.odds[2] = 2 + 1 * this.difficulty;
        this.odds[3] = 2 * this.difficulty;
        this.odds[4] = -10 + 5 * this.difficulty;
        if (this.type > 0) {
            this.odds[1] = 0;
        }
        for (n3 = 0; n3 < this.odds.length; ++n3) {
            if (this.odds[n3] < 0) {
                this.odds[n3] = 0;
            }
            this.totalOdds += this.odds[n3];
            this.odds[n3] = this.totalOdds - this.odds[n3];
        }
        n3 = 0;
        n3 += this.buildStraight(marioLevelModel, 0, marioLevelModel.getWidth(), true);
        while (n3 < marioLevelModel.getWidth()) {
            n3 += this.buildZone(marioLevelModel, n3, marioLevelModel.getWidth() - n3);
        }
        int n4 = marioLevelModel.getHeight() - 1 - this.random.nextInt(4);
        for (n2 = n3; n2 < marioLevelModel.getWidth(); ++n2) {
            for (n = 0; n < marioLevelModel.getHeight(); ++n) {
                if (n < n4) continue;
                marioLevelModel.setBlock(n2, n, 'X');
            }
        }
        if (this.type > 0) {
            n2 = 0;
            n = 0;
            for (int i = 0; i < marioLevelModel.getWidth(); ++i) {
                if (n-- <= 0 && i > 4) {
                    n2 = this.random.nextInt(4);
                    n = this.random.nextInt(4) + 4;
                }
                for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                    if ((i <= 4 || j > n2) && i >= 1) continue;
                    marioLevelModel.setBlock(i, j, 'S');
                }
            }
        }
        return marioLevelModel.getMap();
    }

    @Override
    public String getGeneratorName() {
        return "NotchLevelGenerator";
    }
}

