/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import agents.human.Agent;
import engine.core.MarioAgent;
import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioRender;
import engine.core.MarioResult;
import engine.core.MarioTimer;
import engine.core.MarioWorld;
import engine.helper.GameStatus;
import engine.helper.MarioActions;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import javax.swing.JFrame;

public class MarioGame {
    public static final long maxTime = 40L;
    public static final long graceTime = 10L;
    public static final int width = 256;
    public static final int height = 256;
    public static final int tileWidth = 16;
    public static final int tileHeight = 16;
    public static final boolean verbose = false;
    public boolean pause = false;
    private MarioEvent[] killEvents;
    private JFrame window = null;
    private MarioRender render = null;
    private MarioAgent agent = null;
    private MarioWorld world = null;

    public MarioGame() {
    }

    public MarioGame(MarioEvent[] marioEventArray) {
        this.killEvents = marioEventArray;
    }

    private int getDelay(int n) {
        if (n <= 0) {
            return 0;
        }
        return 1000 / n;
    }

    private void setAgent(MarioAgent marioAgent) {
        this.agent = marioAgent;
        if (marioAgent instanceof KeyAdapter) {
            this.render.addKeyListener((KeyAdapter)((Object)this.agent));
        }
    }

    public MarioResult playGame(String string, int n) {
        return this.runGame(new Agent(), string, n, 0, true, 30, 2.0f);
    }

    public MarioResult playGame(String string, int n, int n2) {
        return this.runGame(new Agent(), string, n, n2, true, 30, 2.0f);
    }

    public MarioResult playGame(String string, int n, int n2, int n3) {
        return this.runGame(new Agent(), string, n, n2, true, n3, 2.0f);
    }

    public MarioResult playGame(String string, int n, int n2, int n3, float f) {
        return this.runGame(new Agent(), string, n, n2, true, n3, f);
    }

    public MarioResult runGame(MarioAgent marioAgent, String string, int n) {
        return this.runGame(marioAgent, string, n, 0, false, 0, 2.0f);
    }

    public MarioResult runGame(MarioAgent marioAgent, String string, int n, int n2) {
        return this.runGame(marioAgent, string, n, n2, false, 0, 2.0f);
    }

    public MarioResult runGame(MarioAgent marioAgent, String string, int n, int n2, boolean bl) {
        return this.runGame(marioAgent, string, n, n2, bl, bl ? 30 : 0, 2.0f);
    }

    public MarioResult runGame(MarioAgent marioAgent, String string, int n, int n2, boolean bl, int n3) {
        return this.runGame(marioAgent, string, n, n2, bl, n3, 2.0f);
    }

    public MarioResult runGame(MarioAgent marioAgent, String string, int n, int n2, boolean bl, int n3, float f) {
        if (bl) {
            this.window = new JFrame("Mario AI Framework");
            this.render = new MarioRender(f);
            this.window.setContentPane(this.render);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setDefaultCloseOperation(3);
            this.render.init();
            this.window.setVisible(true);
        }
        this.setAgent(marioAgent);
        return this.gameLoop(string, n, n2, bl, n3);
    }

    private MarioResult gameLoop(String string, int n, int n2, boolean bl, int n3) {
        this.world = new MarioWorld(this.killEvents);
        this.world.visuals = bl;
        this.world.initializeLevel(string, 1000 * n);
        if (bl) {
            this.world.initializeVisuals(this.render.getGraphicsConfiguration());
        }
        this.world.mario.isLarge = n2 > 0;
        this.world.mario.isFire = n2 > 1;
        this.world.update(new boolean[MarioActions.numberOfActions()]);
        long l = System.currentTimeMillis();
        VolatileImage volatileImage = null;
        Graphics graphics = null;
        Graphics graphics2 = null;
        if (bl) {
            volatileImage = this.render.createVolatileImage(256, 256);
            graphics = this.render.getGraphics();
            graphics2 = volatileImage.getGraphics();
            this.render.addFocusListener(this.render);
        }
        MarioTimer marioTimer = new MarioTimer(40L);
        this.agent.initialize(new MarioForwardModel(this.world.clone()), marioTimer);
        ArrayList<MarioEvent> arrayList = new ArrayList<MarioEvent>();
        ArrayList<MarioAgentEvent> arrayList2 = new ArrayList<MarioAgentEvent>();
        while (this.world.gameStatus == GameStatus.RUNNING) {
            if (!this.pause) {
                marioTimer = new MarioTimer(40L);
                boolean[] blArray = this.agent.getActions(new MarioForwardModel(this.world.clone()), marioTimer);
                this.world.update(blArray);
                arrayList.addAll(this.world.lastFrameEvents);
                arrayList2.add(new MarioAgentEvent(blArray, this.world.mario.x, this.world.mario.y, (this.world.mario.isLarge ? 1 : 0) + (this.world.mario.isFire ? 1 : 0), this.world.mario.onGround, this.world.currentTick));
            }
            if (bl) {
                this.render.renderWorld(this.world, volatileImage, graphics, graphics2);
            }
            if (this.getDelay(n3) <= 0) continue;
            try {
                Thread.sleep(Math.max(0L, (l += (long)this.getDelay(n3)) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        return new MarioResult(this.world, arrayList, arrayList2);
    }
}

