/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioEvent;
import engine.core.MarioSprite;
import engine.core.MarioWorld;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import java.util.ArrayList;

public class MarioForwardModel {
    private static final int OBS_SCENE_SHIFT = 16;
    public static final int OBS_NONE = 0;
    public static final int OBS_UNDEF = -42;
    public static final int OBS_SOLID = 17;
    public static final int OBS_BRICK = 22;
    public static final int OBS_QUESTION_BLOCK = 24;
    public static final int OBS_COIN = 31;
    public static final int OBS_PYRAMID_SOLID = 18;
    public static final int OBS_PIPE_BODY_RIGHT = 37;
    public static final int OBS_PIPE_BODY_LEFT = 36;
    public static final int OBS_PIPE_TOP_RIGHT = 35;
    public static final int OBS_PIPE_TOP_LEFT = 34;
    public static final int OBS_USED_BLOCK = 30;
    public static final int OBS_BULLET_BILL_BODY = 21;
    public static final int OBS_BULLET_BILL_NECT = 20;
    public static final int OBS_BULLET_BILL_HEAD = 19;
    public static final int OBS_BACKGROUND = 63;
    public static final int OBS_PLATFORM_SINGLE = 59;
    public static final int OBS_PLATFORM_LEFT = 60;
    public static final int OBS_PLATFORM_RIGHT = 61;
    public static final int OBS_PLATFORM_CENTER = 62;
    public static final int OBS_PLATFORM = 59;
    public static final int OBS_CANNON = 19;
    public static final int OBS_PIPE = 34;
    public static final int OBS_SCENE_OBJECT = 100;
    public static final int OBS_FIREBALL = 16;
    public static final int OBS_GOOMBA = 2;
    public static final int OBS_GOOMBA_WINGED = 3;
    public static final int OBS_RED_KOOPA = 4;
    public static final int OBS_RED_KOOPA_WINGED = 5;
    public static final int OBS_GREEN_KOOPA = 6;
    public static final int OBS_GREEN_KOOPA_WINGED = 7;
    public static final int OBS_SPIKY = 8;
    public static final int OBS_SPIKY_WINGED = 9;
    public static final int OBS_BULLET_BILL = 10;
    public static final int OBS_ENEMY_FLOWER = 11;
    public static final int OBS_MUSHROOM = 12;
    public static final int OBS_FIRE_FLOWER = 13;
    public static final int OBS_SHELL = 14;
    public static final int OBS_LIFE_MUSHROOM = 15;
    public static final int OBS_STOMPABLE_ENEMY = 2;
    public static final int OBS_NONSTOMPABLE_ENEMY = 8;
    public static final int OBS_SPECIAL_ITEM = 12;
    public static final int OBS_ENEMY = 1;
    public final int obsGridWidth = 16;
    public final int obsGridHeight = 16;
    private MarioWorld world;
    private int fallKill;
    private int stompKill;
    private int fireKill;
    private int shellKill;
    private int mushrooms;
    private int flowers;
    private int breakBlock;

    public static int getSpriteTypeGeneralization(SpriteType spriteType, int n) {
        switch (n) {
            case 0: {
                switch (spriteType) {
                    case MARIO: {
                        return 0;
                    }
                }
                spriteType.getValue();
            }
            case 1: {
                switch (spriteType) {
                    case MARIO: {
                        return 0;
                    }
                    case FIREBALL: {
                        return 16;
                    }
                    case MUSHROOM: 
                    case LIFE_MUSHROOM: 
                    case FIRE_FLOWER: {
                        return 12;
                    }
                    case BULLET_BILL: 
                    case SHELL: 
                    case GOOMBA: 
                    case GOOMBA_WINGED: 
                    case GREEN_KOOPA: 
                    case GREEN_KOOPA_WINGED: 
                    case RED_KOOPA: 
                    case RED_KOOPA_WINGED: {
                        return 2;
                    }
                    case SPIKY: 
                    case SPIKY_WINGED: 
                    case ENEMY_FLOWER: {
                        return 8;
                    }
                }
                return 0;
            }
            case 2: {
                switch (spriteType) {
                    case MARIO: 
                    case FIREBALL: 
                    case MUSHROOM: 
                    case LIFE_MUSHROOM: 
                    case FIRE_FLOWER: {
                        return 0;
                    }
                }
                return 1;
            }
        }
        return -42;
    }

    public static int getBlockValueGeneralization(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        switch (n2) {
            case 0: {
                switch (n) {
                    case 48: 
                    case 49: {
                        return 0;
                    }
                    case 6: 
                    case 7: 
                    case 50: 
                    case 51: {
                        return 22;
                    }
                    case 8: 
                    case 11: {
                        return 24;
                    }
                }
                return n + 16;
            }
            case 1: {
                switch (n) {
                    case 47: 
                    case 48: 
                    case 49: {
                        return 0;
                    }
                    case 1: 
                    case 2: 
                    case 14: {
                        return 17;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return 19;
                    }
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        return 34;
                    }
                    case 6: 
                    case 7: 
                    case 50: 
                    case 51: {
                        return 22;
                    }
                    case 8: 
                    case 11: {
                        return 24;
                    }
                    case 15: {
                        return 31;
                    }
                    case 44: 
                    case 45: 
                    case 46: {
                        return 59;
                    }
                }
                return 0;
            }
            case 2: {
                switch (n) {
                    case 47: 
                    case 48: 
                    case 49: {
                        return 0;
                    }
                }
                return 100;
            }
        }
        return -42;
    }

    public MarioForwardModel(MarioWorld marioWorld) {
        this.world = marioWorld;
    }

    public MarioForwardModel clone() {
        MarioForwardModel marioForwardModel = new MarioForwardModel(this.world.clone());
        marioForwardModel.fallKill = this.fallKill;
        marioForwardModel.stompKill = this.stompKill;
        marioForwardModel.fireKill = this.fireKill;
        marioForwardModel.shellKill = this.shellKill;
        marioForwardModel.mushrooms = this.mushrooms;
        marioForwardModel.flowers = this.flowers;
        marioForwardModel.breakBlock = this.breakBlock;
        return marioForwardModel;
    }

    public void advance(boolean[] blArray) {
        this.world.update(blArray);
        for (MarioEvent marioEvent : this.world.lastFrameEvents) {
            if (marioEvent.getEventType() == EventType.FIRE_KILL.getValue()) {
                ++this.fireKill;
            }
            if (marioEvent.getEventType() == EventType.STOMP_KILL.getValue()) {
                ++this.stompKill;
            }
            if (marioEvent.getEventType() == EventType.FALL_KILL.getValue()) {
                ++this.fallKill;
            }
            if (marioEvent.getEventType() == EventType.SHELL_KILL.getValue()) {
                ++this.shellKill;
            }
            if (marioEvent.getEventType() == EventType.COLLECT.getValue()) {
                if (marioEvent.getEventParam() == SpriteType.FIRE_FLOWER.getValue()) {
                    ++this.flowers;
                }
                if (marioEvent.getEventParam() == SpriteType.MUSHROOM.getValue()) {
                    ++this.mushrooms;
                }
            }
            if (marioEvent.getEventType() != EventType.BUMP.getValue() || marioEvent.getEventParam() != 22 || marioEvent.getMarioState() <= 0) continue;
            ++this.breakBlock;
        }
    }

    public GameStatus getGameStatus() {
        return this.world.gameStatus;
    }

    public float getCompletionPercentage() {
        return this.world.mario.x / (float)(this.world.level.exitTileX * 16);
    }

    public float[] getLevelFloatDimensions() {
        return new float[]{this.world.level.width, this.world.level.height};
    }

    public int getRemainingTime() {
        return this.world.currentTimer;
    }

    public float[] getMarioFloatPos() {
        return new float[]{this.world.mario.x, this.world.mario.y};
    }

    public float[] getMarioFloatVelocity() {
        return new float[]{this.world.mario.xa, this.world.mario.ya};
    }

    public boolean getMarioCanJumpHigher() {
        return this.world.mario.jumpTime > 0;
    }

    public int getMarioMode() {
        int n = 0;
        if (this.world.mario.isLarge) {
            n = 1;
        }
        if (this.world.mario.isFire) {
            n = 2;
        }
        return n;
    }

    public boolean isMarioOnGround() {
        return this.world.mario.onGround;
    }

    public boolean mayMarioJump() {
        return this.world.mario.mayJump;
    }

    public float[] getEnemiesFloatPos() {
        ArrayList<MarioSprite> arrayList = this.world.getEnemies();
        float[] fArray = new float[arrayList.size() * 3];
        for (int i = 0; i < arrayList.size(); ++i) {
            fArray[3 * i] = arrayList.get((int)i).type.getValue();
            fArray[3 * i + 1] = arrayList.get((int)i).x;
            fArray[3 * i + 2] = arrayList.get((int)i).y;
        }
        return fArray;
    }

    public int getKillsTotal() {
        return this.fallKill + this.fireKill + this.shellKill + this.stompKill;
    }

    public int getKillsByFire() {
        return this.fireKill;
    }

    public int getKillsByStomp() {
        return this.stompKill;
    }

    public int getKillsByShell() {
        return this.shellKill;
    }

    public int getKillsByFall() {
        return this.fallKill;
    }

    public int getNumLives() {
        return this.world.lives;
    }

    public int getNumCollectedMushrooms() {
        return this.mushrooms;
    }

    public int getNumCollectedFireflower() {
        return this.flowers;
    }

    public int getNumCollectedCoins() {
        return this.world.coins;
    }

    public int getNumDestroyedBricks() {
        return this.breakBlock;
    }

    public int[] getMarioScreenTilePos() {
        return new int[]{(int)((this.world.mario.x - this.world.cameraX) / 16.0f), (int)(this.world.mario.y / 16.0f)};
    }

    public int[][] getScreenCompleteObservation() {
        return this.getScreenCompleteObservation(1, 0);
    }

    public int[][] getScreenEnemiesObservation() {
        return this.getScreenEnemiesObservation(0);
    }

    public int[][] getScreenSceneObservation() {
        return this.getScreenSceneObservation(1);
    }

    public int[][] getMarioCompleteObservation() {
        return this.getMarioCompleteObservation(1, 0);
    }

    public int[][] getMarioEnemiesObservation() {
        return this.getMarioEnemiesObservation(0);
    }

    public int[][] getMarioSceneObservation() {
        return this.getMarioSceneObservation(1);
    }

    public int[][] getScreenCompleteObservation(int n, int n2) {
        return this.world.getMergedObservation(this.world.cameraX + 128.0f, 128.0f, n, n2);
    }

    public int[][] getScreenEnemiesObservation(int n) {
        return this.world.getEnemiesObservation(this.world.cameraX + 128.0f, 128.0f, n);
    }

    public int[][] getScreenSceneObservation(int n) {
        return this.world.getSceneObservation(this.world.cameraX + 128.0f, 128.0f, n);
    }

    public int[][] getMarioCompleteObservation(int n, int n2) {
        return this.world.getMergedObservation(this.world.mario.x, this.world.mario.y, n, n2);
    }

    public int[][] getMarioEnemiesObservation(int n) {
        return this.world.getEnemiesObservation(this.world.mario.x, this.world.mario.y, n);
    }

    public int[][] getMarioSceneObservation(int n) {
        return this.world.getSceneObservation(this.world.mario.x, this.world.mario.y, n);
    }
}

