/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import java.util.ArrayList;
import java.util.HashMap;

public class PlanRunner {
    private int index;
    private int maxTime = -1;
    private boolean[] action = new boolean[5];
    private HashMap<Integer, ArrayList<Event>> events = new HashMap();

    PlanRunner() {
        this.rewind();
    }

    public boolean isDone() {
        return this.index > this.maxTime;
    }

    public boolean isLastAction() {
        return this.index == this.maxTime;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.maxTime;
    }

    public void rewind() {
        this.index = 0;
    }

    public void addKey(int n) {
        this.addKey(n, 0);
    }

    public void addKey(int n, int n2) {
        this.addKeyEvent(n, n2, true);
    }

    public void addKey(int n, int n2, int n3) {
        this.addKeyEvent(n, n2, true);
        this.addKeyEvent(n, n2 + n3, false);
    }

    private void addKeyEvent(int n, int n2, boolean bl) {
        ArrayList<Event> arrayList = this.events.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.events.put(n2, arrayList);
        }
        arrayList.add(new Event(n, bl));
        this.maxTime = Math.max(this.maxTime, n2);
    }

    public boolean[] nextAction() {
        ArrayList<Event> arrayList = this.events.get(this.index);
        if (arrayList != null) {
            for (Event event : arrayList) {
                this.action[event.key] = event.pressed;
            }
        }
        ++this.index;
        return this.action;
    }

    private class Event {
        public int key;
        public boolean pressed;

        Event(int n, boolean bl) {
            this.key = n;
            this.pressed = bl;
        }
    }
}

