/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import engine.core.MarioForwardModel;

public class Sensors {
    private String[][] asciiScene;
    public int[][] levelScene;
    public int[][] enemiesScene;
    public int fireballsOnScreen;
    public static final int EMPTY = 0;
    public static final int COIN = 31;
    public static final int SOLID = 17;
    public static final int PLATFORM = 59;
    public static final int QUESTIONMARK_BOX = 24;
    public static final int BRICK = 23;

    public void updateReadings(MarioForwardModel marioForwardModel) {
        int n;
        int n2;
        this.levelScene = marioForwardModel.getMarioSceneObservation();
        this.enemiesScene = marioForwardModel.getMarioEnemiesObservation();
        this.asciiScene = new String[16][16];
        this.fireballsOnScreen = 0;
        for (n2 = 0; n2 < this.levelScene.length; ++n2) {
            for (n = 0; n < this.levelScene[0].length; ++n) {
                this.asciiScene[n2][n] = this.asciiLevel(this.levelScene[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.enemiesScene.length; ++n2) {
            for (n = 0; n < this.enemiesScene[0].length; ++n) {
                int n3 = this.enemiesScene[n2][n];
                if (n3 == 0) continue;
                if (n3 == 16) {
                    ++this.fireballsOnScreen;
                }
                this.asciiScene[n2][n] = this.asciiEnemy(n3);
            }
        }
    }

    public int[] getMarioPosition() {
        return new int[]{8, 8};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[][] stringArray = this.asciiScene;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            for (String string : stringArray2 = stringArray[i]) {
                stringBuilder.append(string + " ");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private String asciiLevel(int n) {
        switch (n) {
            case 0: {
                return " ";
            }
            case 31: {
                return "O";
            }
            case 17: {
                return "X";
            }
            case 59: {
                return "-";
            }
            case 23: {
                return "B";
            }
            case 24: {
                return "?";
            }
        }
        return "" + n;
    }

    private String asciiEnemy(int n) {
        if (n == 2) {
            return "G";
        }
        if (n == 4 || n == 6) {
            return "n";
        }
        if (n == 3 || n == 5 || n == 7) {
            return "w";
        }
        if (n == 14) {
            return "D";
        }
        if (n == 8) {
            return "^";
        }
        if (n == 9) {
            return "W";
        }
        if (n == 10) {
            return "<";
        }
        if (n == 11) {
            return "V";
        }
        if (n == 13) {
            return "F";
        }
        if (n == 16) {
            return "*";
        }
        return "" + n;
    }
}

