''' Fair division of [0,1] given n buyers with linear valuation functions '''

from re import S
import numpy as np
# import cvxpy as cp
# np.random.seed(888)

# def compute_eq_utilities(B, c, d) # c[i] * theta + d[i] >= 0 for 0 <= theta <= 1

def compute_b_from_x(x, v, B):
    tt = v*x
    return ((tt.T / np.sum(tt, 1)) * B).T

def pr(v, B, max_iter=5000):
    ''' unit supply for each item '''
    n, m = v.shape
    x = np.multiply((B/np.sum(B)), np.ones(shape=(m,n))).T
    b = v*x
    for iter in range(max_iter): # proportional response dynamics
        p = np.sum(b, axis=0) # compute prices
        x = b/p # compute allocations
        b = compute_b_from_x(x, v, B) # new bids
    return x, p

def compute_me_fin_dim(v, B, s, max_iter=1000):
    # scale the item values
    x, p = pr(v * s, B)
    return x*s, p/s