'''helper functions for plotting'''

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rc('font',family='Times New Roman')
import numpy as np

import matplotlib
matplotlib.rcParams['pdf.fonttype'] = 42
matplotlib.rcParams['ps.fonttype'] = 42


def plot_results_dict(results_dict, facecolor, label, linestyle, linecolor, tickers=None, log_scale=False):
    
    objective_means = np.mean(results_dict, axis=0)
    objective_se = np.std(results_dict, axis=0)/np.sqrt(len(results_dict)) 
    
    plt.plot(tickers, objective_means, linestyle, label=label, linewidth=3, color=linecolor)
    plt.fill_between(tickers, objective_means-objective_se, objective_means+objective_se,
                    alpha=1, edgecolor='#1B2ACC', facecolor=facecolor,
        linewidth=0)
    
    if log_scale==True:
        plt.xscale('log')

        
def plot_objectives(objective_means, objective_stds, facecolor, label, linestyle, linecolor, tickers=None, log_scale=False):
    
    objective_means = np.array(objective_means)
    objective_stds = np.array(objective_stds)
    
    plt.plot(tickers, objective_means, linestyle, label=label, linewidth=3, color=linecolor)
    plt.fill_between(tickers, objective_means-objective_stds, objective_means+objective_stds,
                    alpha=1, edgecolor='#1B2ACC', facecolor=facecolor,
        linewidth=0)
    if log_scale==True:
        plt.yscale('log')

