% Plotting Figure 3

figure;

for digi = 1:10
    t1 = []; t2 = []; t3 = []; t4 = [];
    sd1 =[]; sd2 = []; sd3 = []; sd4 = [];
    n_list =  [24, 48, 72, 96, 120];
    for n = n_list
        load(sprintf("data/cifar10_class%d_np%d",digi, n));
        n

        t1 = [t1, mean(s0)];
        t2 = [t2, mean(s1)];
        t3 = [t3, mean(s2)];

        sd1 = [sd1, std(s0)];
        sd2 = [sd2, std(s1)];
        sd3 = [sd3, std(s2)];

    end

    subplot(2,5, digi)
    h = errorbar(n_list, t1, sd1/sqrt(96));
    h.LineWidth = 1;
    h.Color = 'r';
    hold on;
    h = errorbar(n_list+.5, t2, sd2/sqrt(96));
    h.LineWidth = 1;
    h.Color = 'b';
    h = errorbar(n_list+1, t3, sd3/sqrt(96));
    h.LineWidth = 1;
    h.Color = 'b';
    h.LineStyle = '--';
    grid on;
    if(digi== 1)
        xlabel("n_+"); ylabel("AUC");
    end

    load data/cifarlabel.mat
    cifarlabel = string(cifarlabel);
    title(cifarlabel(digi))
end

h = legend(["Two-step", "Logistic", "AUC max"]);
