clear;
t1 = zeros(20,5); t2 = zeros(20,5);
for seed = 1:5
    seed
    rng(seed)
    nnlist = round(linspace(50,2000,5));
    for nn_idx = 1:length(nnlist)
        nn = nnlist(nn_idx)
        % generate training dataset
        dn = 80; np = nn; nq = nn;
        tt = rand(dn, 1)*.5;
        xp = randn(dn, np) + tt;
        xq = randn(dn, nq);

        X = [xp, xq];
        y = [ones(1, np) -ones(1,nq)];

        %%
        % generate testing dataset
        npt = 50000; nqt = 50000;
        xpt = randn(dn, npt) + tt;
        xqt = randn(dn, nqt);
        Xt = [xpt,xqt];
        yt = [ones(1, npt) -ones(1,nqt)];

        %%
        % the proposed method
        para = zeros(dn+1,1);
        old_para = ones(dn+1,1) * inf;
        lambda = 0;
        % initiate the weights to ones.
        w = ones(1,np+nq);
        fea = @(x) x;

        % the first run using (7), without any weights and regularization term.
        opts = optimset('fmincon');
        opts.MaxIter = 100000;
        opts.MaxFunEvals = 1000000;
        opts.GradObj = 'on';
        wp = w(y==1);
        wq = w(y==-1);

        K = fea(X);
        Kp = [K(:,y==1); ones(1,sum(y==1))];
        Kq = [K(:,y==-1); ones(1,sum(y==-1))];

        tic
        % objective function
        obj1 = @(para) rocloss(para, Kp, Kq, wp, wq, lambda);
        n = length(y);
        [para, fval2, oflag] = fmincon(obj1, para,[[K';-K'], [ones(n,1);-ones(n,1)]],...
            [pi/2*ones(n,1); zeros(n,1)], [], [], [], [], [], opts);
        f = @(x) para(1:end-1)'*fea(x) + para(end);
        f = @(x) min(max(f(x), 0), pi/2);

        % computing weights
        atanrhat = f(X);
        w0 = abs(diffCDF(atanrhat,y,atanrhat))*sqrt(2);
        diff = atanrhat+pi/4;
        w= w0 .* sin(diff);
        wp = w(y==1);
        wq = w(y==-1);

        % the second run using (7), with previously calculated weights.
        obj2 = @(para) rocloss(para, Kp, Kq, wp, wq, lambda);
        n = length(y);
        [para, fval2, oflag] = fmincon(obj2, para,[[K';-K'], [ones(n,1);-ones(n,1)]],...
            [pi/2*ones(n,1); zeros(n,1)], [], [], [], [], [], opts);
        t1(seed,nn_idx) = toc;

        fX = fea(X);

        % run auc maximization
        tic
        obj = @(theta) aucmax(theta, fX, y, 0);
        opts = optimoptions("fminunc");
        opts.Display = "none";
        opts.MaxIterations = 10000000;
        opts.MaxFunctionEvaluations = 1000000;
        % opts.CheckGradients = true;
        opts.SpecifyObjectiveGradient = true;
        theta2 = fminunc(obj, zeros(dn,1), opts);
        t2(seed,nn_idx) = toc;

    end
end
%% difference between two CDFs evaluated on rt
function [diff] = diffCDF(r, y, rt)
np = sum(y== 1);
nq = sum(y==-1);
rp = r(y==1);
rq = r(y==-1);

diff = sum(rp' < rt,1)/np - sum(rq' < rt,1)/nq;

end

%% (7) objective, with weights
function [f, g] = rocloss(para, Kp, Kq, wp, wq, lambda)
theta = para;
b = size(Kp,1);

f = mean(wp.*sin(theta' * Kp)) + ...
    mean(wq.*cos(theta' * Kq));

f = -f + lambda*theta(1:b-1)'*theta(1:b-1);

g = mean(wp.*cos(theta' * Kp).*Kp,2) - ...
    mean(wq.*sin(theta' * Kq).*Kq,2);

g = -g + 2*lambda.*[theta(1:b-1);0];
end

%% AUC maximization objective
function [f, g] = aucmax(theta, X, y, lambda)
xp = X(:, y==1);
xq = X(:, y==-1);

np = sum(y==1);
nq = sum(y==-1);
sq = @(x) (1-x).^2;
gsq = @(x) -2*(1-x);
f = sum(sum((sq((theta'*xp)' - theta'*xq))))/np/nq + lambda*theta'*theta;
g = gsq((theta'*xp)' - theta'*xq)/np/nq;
xp = repmat(xp, 1, 1, size(xq,2));
xq = repmat(xq, 1, 1, size(xp,2));
xq = permute(xq, [1,3,2]);

g = repmat(g, 1, 1, size(X,1));
g = permute(g, [3,1,2]);
g = sum(sum(g.*(xp - xq),2),3) + 2*lambda*theta;
end
