function writeInpForCPR(ref,tst,Gij,smo,initialCut,winSize)
    % This is a simple exemple on how to creat .inp file using Matlab
    T1 = size(ref,2);
    [N,T2] = size(tst);
    nPair = size(Gij,1);
    fid=fopen('sample.inp','w+');
    % write problem description
    fprintf(fid,'p %d %d %d %d %d\n',N,T1,T2,nPair,winSize);
    % write ref
    for i = 1:N
       for j = 1:T1
           fprintf(fid,'r %d %d %d\n',j,i,ref(j));
       end
    end
    
    % write tst
    for i = 1:N
       for j = 1:T2
           fprintf(fid,'t %d %d %d\n',j,i,tst(i,j));
       end
    end
    
    % write Gij
    for i = 1:nPair
        fprintf(fid,'g %d %d %d\n',Gij(i,1),Gij(i,2),smo);
    end
    
    % write initialCut
    if(exist('initialCut','var'))
        for i = 1:N
            for j = 1:T1-1
                fprintf(fid,'i %d %d %d\n',j,i,initialCut(i,j)-1);
            end
        end
    end
    fclose(fid);
end