#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from libsvm.svmutil import *
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from parameters_dc import para

from logistic_DC import LogisticRegression_TOPK_DC

kvalue1 = 1000
kvalue2 =20000
train_size = 0.5
val_size = 0.25
seed = 12345

y, X_train = svm_read_problem('./dataset/'+str(para.dataname)+'/'+str(para.dataname), True)
X = X_train.toarray()
y[y < 0] = 0
# y[y > 1] = 0


Model_name = "LogisticRegression"

# classifier = LogisticRegression_TOPK_DC(lr_0=para.lr_0, lr_outer=para.lr_outer, mu=para.mu, num_iter=para.num_iter, T0=para.T0, batch=para.batch, k1_value = kvalue1, k2_value = kvalue2, seed =para.seed, dataname = para.dataname, Model_name=Model_name)
classifier = LogisticRegression_TOPK_DC(lr_0=2, lr_outer=4, mu=200, num_iter=14, T0=50, batch=100, k1_value = kvalue1, k2_value = kvalue2, seed = seed, dataname = para.dataname, Model_name=Model_name)

classifier.fit(X, y, X, y, X ,y)

data_pass_dc = classifier.data_pass
time_dc = classifier.time_list
loss_dc = classifier.loss_list
w1 = classifier.w_1
w2 = classifier.w_2

plot
plt.plot(data_pass_dc[1:], loss_dc[1:])

df1 = pd.DataFrame(data_pass_dc, columns=['data_pass'])
df2 = pd.DataFrame(loss_dc, columns=['loss_dc'])
df3 = pd.DataFrame(w1.T,columns=['w1'])
df4 = pd.DataFrame(w2.T,columns=['w2'])

d1 = df3.join(df4)
d2 = d1.join(df1)
d3 = d2.join(df2)
s = str(para.dataname)+"_lr0="+str(para.lr_0)+"_lr_out="+str(para.lr_outer)+"_mu="+str(para.mu)+"_T0="+str(para.T0)+"_numStages="+str(para.num_iter)+"_batch="+str(para.batch)+"_seed="+str(para.seed)+".csv";
d3.to_csv(s)
