#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Oct 11 00:34:54 2022

@author: yaoyao
"""

import torch
import math
import pandas as pd
from torchvision import transforms, datasets
from torch.utils.data import Dataset
from torch.utils.data import DataLoader
#from libauc.models import DenseNet121
from densenet import DenseNet121
from resnet_cifar import ResNet20
# from chexpert import CheXpert
from TINYIMAGENET_LT import TINYIMAGENET_LT
#from libauc.optimizers import PESG
from pesg import PESG
#from libauc.datasets import ImbalanceSampler
from data_sampler import ImbalanceSampler
from parameters_dc import para
#from PIL import Image
import numpy as np
#from sklearn.metrics import roc_auc_score
from losses import AUCMLoss, CrossEntropyBinaryLoss

def set_all_seeds(SEED):
    # REPRODUCIBILITY
    torch.manual_seed(SEED)
    np.random.seed(SEED)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
       
alpha1 = 0.05
alpha2 = 0.5
SEED = para.seed
BATCH_SIZE = para.batch
num_iter = para.num_iter

root = '../dataset/tiny-imagenet-200/'
#root = '../data/CheXpert-v1.0-small/'
# root = './CheXpert-v1.0-small/'
# root = '/Users/yaoyao/Desktop/DC_deep/cifar-10-batches-py/'
#root = '/dual_data/not_backed_up/CheXpert/CheXpert-v1.0/'

imratio = 0.5
lr = para.lr
# gamma = 500
gamma = para.gamma
#weight_decay = 1e-4
weight_decay = 0
margin = 1.0

#torch.manual_seed(SEED)
set_all_seeds(SEED)

device = "cuda" if torch.cuda.is_available() else "cpu"
print(f'Using {device} device')

n_total = 21549
print("total train data = ", n_total)
n_train = int(n_total * 0.9)
n_val = n_total - n_train

# random split training and validation data
index = torch.randperm(n_total)
train_index = index[0:n_train]
val_index = index[n_train:n_total]

transform_train = transforms.Compose([
            # transforms.RandomCrop(32, padding=4),
            #transforms.RandomHorizontalFlip(),
            transforms.ToTensor(),
            transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
        ])

transform_val = transforms.Compose([
            transforms.ToTensor(),
            transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
        ])

trainSet = TINYIMAGENET_LT(path=root, imb_type='exp', imb_factor=0.01, rand_number=0, train=True,
                            transform=transform_train, target_transform=None, index=train_index, split=True)
valSet = TINYIMAGENET_LT(path=root, imb_type='exp', imb_factor=0.01, rand_number=0, train=True,
                            transform=transform_train, target_transform=None, index=val_index, split=True)
testSet = TINYIMAGENET_LT(path=root, imb_type='exp', imb_factor=0.01, rand_number=0, train=False,
                            transform=transform_val, target_transform=None)

print(testSet.data.size)

trainloader = torch.utils.data.DataLoader(trainSet, batch_size=2*BATCH_SIZE,
                                          sampler=ImbalanceSampler(np.array(trainSet.targets).flatten().astype(int), 2*BATCH_SIZE, pos_num=BATCH_SIZE),
                                          num_workers=0, pin_memory=True, drop_last=True)

valloader = torch.utils.data.DataLoader(valSet, batch_size=1, num_workers=0, drop_last=False, shuffle=False)
testloader = torch.utils.data.DataLoader(testSet, batch_size=1, num_workers=0, drop_last=False, shuffle=False)


print(len(testloader))

n_train = len(trainSet.targets)
print('n_train=', n_train)
n_test = len(testSet.targets)
# n_val = len(valSet.targets)
n_pos = int(sum(trainSet.targets))
n_neg = n_train - n_pos
print(n_pos)
print(n_neg)

n_pos_val = int(sum(valSet.targets))
n_neg_val = n_val - n_pos_val

n_pos_test = int(sum(testSet.targets))
n_neg_test = n_test-n_pos_test

k1_value = int(math.floor(alpha1 * n_neg))
k2_value = int(math.ceil(alpha2 * n_neg))

k1_value_test = int(math.floor(alpha1 * n_neg_test))
k2_value_test = int(math.ceil(alpha2 * n_neg_test))

k1_value_val = int(math.floor(alpha1 * n_neg_val))
k2_value_val = int(math.ceil(alpha2 * n_neg_val))

# model
model = ResNet20(pretrained=False, last_activation='sigmoid', activations='relu', num_classes=1)
model = model.cuda()   
    
pauc_test_list = []
pauc_val_list = []
data_pass_list = []
    
# Training
if True:
    # L_AVG
    Loss = AUCMLoss(imratio=imratio)
    optimizer = PESG(model, 
                     a=Loss.a, 
                     b=Loss.b, 
                     alpha=Loss.alpha, 
                     imratio=imratio, 
                     lr=lr, 
                     gamma=gamma, 
                     margin=margin, 
                     weight_decay=weight_decay)

    print ('-'*30)

    trainloader_copy = iter(trainloader)

    data_pass = 0
    data_pass2 = 0
    num_epoch = 0

    # outer loop
    for i in range(num_iter):
        model.train()
        #print(i)
        
        try:
            data_in, target_in = trainloader_copy.next()
        except:
            trainloader_copy = iter(trainloader)
            data_in, target_in = trainloader_copy.next()
 
        #print(data_in)
        #print(target_in)
        
        data_in, target_in = data_in.cuda(), target_in.cuda()
        preds = model(data_in)
        # y_pred = torch.sigmoid(logits)
        loss = Loss(preds, target_in)
        optimizer.zero_grad()
        loss.backward()
        optimizer.step()
           
        # calculate num of data pass
        data_pass += 2 * BATCH_SIZE
        data_pass2 += 2 * BATCH_SIZE
        
        if data_pass / n_train > 1:
            data_pass = 0
            num_epoch += 1
            data_pass_list.append(data_pass2 / n_train)
            
            model.eval()
         
            test_pred_pos = []
            test_pred_neg = []
            test_pred = []
            test_true = []
            for k, data in enumerate(testloader):
                test_data, test_targets = data
                test_data = test_data.cuda()
                outputs = model(test_data)
                test_pred.append(outputs.detach())
                test_true.append(test_targets.data)
                if test_targets.data > 0.1:
                   test_pred_pos.append(outputs.detach())
                else:
                   test_pred_neg.append(outputs.detach())
                  
            z_pos = torch.tensor(test_pred_pos)
            z_neg = torch.tensor(test_pred_neg)
            ttest_pred = torch.tensor(test_pred)
            ttest_true = torch.tensor(test_true)
       
            n_test_pos = z_pos.shape[0]
       
            sum_loss = 0
            sum_loss_pauc = 0
            for k in range(n_test_pos):
                diff = z_pos[k] - z_neg
                loss_pauc = 0 - diff
                loss_pauc[loss_pauc <= 0] = 0
                loss_pauc[loss_pauc > 0] = 1
                loss_pauc_sort, indices_auc = torch.sort(loss_pauc, descending=True)
                sum_loss_pauc += torch.sum(loss_pauc_sort[k1_value_test:k2_value_test])
            sum_loss_pauc /= (k2_value_test-k1_value_test) * n_test_pos
            pauc_test = 1 - sum_loss_pauc.data
            pauc_test_list.append(pauc_test.cpu().numpy())
            #pauc = partial_AUC(ttest_pred, ttest_true, k1_value_test, k2_value_test, alpha1, alpha2)
       
            # evaluation of validation dataset
            # val_pred_pos = []
            # val_pred_neg = []
            # val_pred = []
            # val_true = []
            # for k, data in enumerate(valloader):
            #     val_data, val_targets = data
            #     val_data = val_data.cuda()
            #     outputs = model(val_data)
            #     val_pred.append(outputs.detach())
            #     val_true.append(val_targets.data)
            #     if val_targets.data > 0.1:
            #         val_pred_pos.append(outputs.detach())
            #     else:
            #         val_pred_neg.append(outputs.detach())
       
            # z_pos_val = torch.tensor(val_pred_pos)
            # z_neg_val = torch.tensor(val_pred_neg)
            # vval_pred = torch.tensor(val_pred)
            # vval_true = torch.tensor(val_true)
       
            # pauc_val = partial_AUC(vval_pred, vval_true, k1_value_val, k2_value_val, alpha1, alpha2).data
            # pauc_val_list.append(pauc_val.cpu().numpy())
            pauc_val_list.append(0)
            
            model.train()
         
            # print results
            # print("valid partial auc=", pauc_val)
            print("test partial auc =", 1-sum_loss_pauc.data) 

        if num_epoch == 5:
            lr = lr / 10

    df1 = pd.DataFrame(pauc_test_list, columns=['pauc_test'])
    df2 = pd.DataFrame(pauc_val_list, columns=['pauc_val'])
    df3 = pd.DataFrame(data_pass_list, columns=['data_pass'])

    d1 = df2.join(df1)
    d2 = d1.join(df3)
    s = "lr="+str(para.lr)+"_num_iter="+str(num_iter)+"_seed="+str(SEED)+"_gamma="+str(gamma)+".csv"
    d2.to_csv(s)       
