avg_loss_dc = mean(loss_dc,2);
avg_loss_base_100 = mean(loss_base_100,2);
avg_loss_base_200 = mean(loss_base_200,2);
avg_pauc_dc = mean(pauc_dc,2);
avg_pauc_base_100 = mean(pauc_base_100,2);
avg_pauc_base_200 = mean(pauc_base_200,2);
std_loss_dc = std(loss_dc,0,2);
std_loss_base_100 = std(loss_base_100,0,2);
std_loss_base_200 = std(loss_base_200,0,2);
std_pauc_dc = std(pauc_dc,0,2);
std_pauc_base_100 = std(pauc_base_100,0,2);
std_pauc_base_200 = std(pauc_base_200,0,2);
avg_time = mean(time,2);

%% plot error bar loss
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
errorbar(datapass_base_200,avg_loss_base_200,std_loss_base_200,'LineWidth',3)
hold off

title('CheXpert\_D5','FontSize',40)
xlim([0 150])
xlabel('# of epoch','fontweight','bold','FontSize',20)
ylabel('Training Loss','fontweight','bold','FontSize',20)
legend({'AGD-SBCD','DCA'},'FontSize',20)
set(gca,'FontSize',20)
set(gca,'yscale','log')
grid on

% create smaller axes in top right, and plot on it
axes('Position',[.25 .3 .6 .4])
box on
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
errorbar(datapass_base_200,avg_loss_base_200,std_loss_base_200,'LineWidth',3)
hold off
xlim([20 140])
set(gca,'FontSize',20)


%% plot error bar pauc
% calculate random classifier 
train_label = readNPY('CheXpert_train_labels_all.npy');
train_data = readNPY('CheXpert_train_hidden_features_all.npy');
y = train_label;
y(y <= 0) = -1;
[n,d] = size(train_data);
num_dis = 5;

y_copy = y;
y_copy(y_copy <= 0) = 0;
n_neg = n - sum(y_copy(:,num_dis));

k1 = 10000;
k2 = 100000;
fpr1 = k1 / n_neg;
fpr2 = k2 / n_neg;
area = (fpr1+fpr2) / 2;
area_list = [area;area];
datapass = [0;150];

errorbar(datapass_dc,avg_pauc_dc,std_pauc_dc,'LineWidth',3)
hold on
errorbar(datapass_base_200,avg_pauc_base_200,std_pauc_base_200,'LineWidth',3)
hold on
plot(datapass,area_list,'--','LineWidth',3)
hold off

title('CheXpert\_D5','FontSize',40)
xlim([0 150])
ylim([0.2 0.75])
xlabel('# of epoch','fontweight','bold','FontSize',20)
ylabel('pAUC on Training set','fontweight','bold','FontSize',20)
legend({'AGD-SBCD','DCA','Random Classifier'},'FontSize',20)
set(gca,'FontSize',20)
grid on

