# test code

We do provide our test suit, in the testAll.py file. To test the different methods, you first need to download the code from their respective git repositories (on the commit we used, as given by the url below):

AANet: https://github.com/haofeixu/aanet/tree/f689abf81ef072b4e50eb480d3a73db66eebda44
ACVNet: https://github.com/gangweiX/ACVNet/tree/8ed55c6a7f4ee20f9a6373e1fd4749b7b8f02955
AnyNet: https://github.com/mileyan/AnyNet/tree/83badc75af596e76edce67e4917ba4fbacbb7c1d
CascadeStereo: https://github.com/alibaba/cascade-stereo/tree/b3b03719036ae1ce2cec48609063d58c87de4298
CREStereo: https://github.com/megvii-research/CREStereo/tree/ad3a1613bdedd88b93247e5f002cb7c80799762d
DeepPruner: https://github.com/uber-research/DeepPruner/tree/40b188cf954577e21d5068db2be2bedc6b0e8781
GANet: https://github.com/feihuzhang/GANet/tree/0d9d94fa9016c741eafc7044a9764ee2b16c59ab
GwcNet: https://github.com/xy-guo/GwcNet/tree/0987074f48b098c6e975a58ca5aacf233b0fb0eb
HighResStereo: https://github.com/gengshan-y/high-res-stereo/tree/cb60fde567066f59caea709dca1ac26b2ea27380
Lac-GwcNet: https://github.com/SpadeLiu/Lac-GwcNet/tree/2d432ad14549edd8934890df7352badd20194607
MobileStereoNet: https://github.com/cogsys-tuebingen/mobilestereonet/tree/3c2931ab87561535469206bc366b942af67a2230
PSMNet: https://github.com/JiaRenChang/PSMNet/tree/87ac9093afbf6545c093bd9d26c5ffd66e49a7b8
RAFT-Stereo: https://github.com/princeton-vl/RAFT-Stereo/tree/0e2a12746143a7552e30ef2f4b1d4c3214388a1a
RealTimeStereo: https://github.com/JiaRenChang/RealtimeStereo/tree/67d622785c8560a66a4917db0b3bb7ddfd7e127b
SMD-Net: https://github.com/fabiotosi92/SMD-Nets/tree/fbc646834af50b73a754be32cc76d8149b3ddd0a
SRH-Net: https://github.com/hongzhidu/SRHNet/tree/00ab17f26045092151a153238d85b500ba15eea3
StereoNet and ActiveStereoNet: https://github.com/meteorshowers/X-StereoLab/tree/ff8ec7e3c96625cb85b91bcc657829970e316e1f

Then, you need to apply the patch files we provide. This is done with git as:

	git apply changes.patch

You also need to make sure that the "callable.py" file we do provide for each method is present in the repository.

The test suite should then be able to automatically call the model.

# Finetuning code

For the methods we finetuned, a "finetune_exrdataset.py" or "finetune_[modelname]_exrdataset.py" file has been provided. Please refer to the -h help option of each file for more information.

Below we provide the time required to finetune each method for 10 epochs. Note that some methods required more memory for training than our GPU could afford and as such these methods were trained on the CPU, which has access to the RAM and the SWAP memory:

## Method [Device]: Time

ACVNet [CPU] : 24h27m14s
AnyNet [GPU] : 17m10s
CascadeStereo [CPU] : 11h14m03s
MobileStereoNet [CPU] : 3h46m51s
RealTimeStereo [GPU] : 10m05s
ActiveStereoNet [GPU] : 9m47s
StereoNet [GPU] : 12m32s 
