c_mm <- function(pdmp, burnin = 1){
  ## Calc Marginal
  d <- nrow(pdmp$positions)-1
  in_model <- (pdmp$positions[d+1, ] == 1 & pdmp$thetas[d+1, ] == 0)
  times <- pdmp$times
  positions <- pdmp$positions
  thetas <- pdmp$thetas

  maxIter <- length(times)
  marg_mean <- rep(0, d)

  for( mi in 1:d){
    beta_mean <- 0
    total_time <- 0
    for(i in (burnin):(maxIter-1)){
      if(in_model[i]){
        tauv <- (times[i+1] - times[i])
        total_time <- total_time + tauv
        beta_mean = beta_mean + (tauv*positions[mi,i] + thetas[mi,i]*tauv^2/2)
        marg_mean[mi] = beta_mean/total_time
      }

    }
  }
  return(marg_mean)
}
c_mm2 <- function(pdmp, burnin = 1){
  ## Calc Marginal 2 mom
  d <- nrow(pdmp$positions)-1
  in_model <- (pdmp$positions[d+1, ] == 1 & pdmp$thetas[d+1, ] == 0)
  times <- pdmp$times
  positions <- pdmp$positions
  thetas <- pdmp$thetas

  maxIter <- length(times)
  marg_mean <- rep(0, d)

  for( mi in 1:d){
    beta_mean <- 0
    total_time <- 0
    for(i in (burnin):(maxIter-1)){
      if(in_model[i]){
        tv <- (times[i+1] - times[i])
        total_time <- total_time + tv
        x_t <- positions[mi,i]; v_t <- thetas[mi,i]
        beta_mean = beta_mean +
          (tv*x_t^2 + tv^2*v_t*x_t + tv^3*v_t^2/3)
        marg_mean[mi] = beta_mean/total_time
      }

    }
  }
  return(marg_mean)
}

load("gmm/gmm_data.Rdata")
exact_mom_1 <- rowMeans(mu_mat)
exact_mom_2 <- rowMeans(mu_mat^2 + dat$sigma[1])
num_reps = 20
alphas <- c(.1, .2, .3, .5, .7, .8)[6:1]
est_ZZ_all_2 <-est_ZZ_all_1 <- matrix(0, nrow = 8, ncol = num_reps)

j=1
for(j in 1:6){
  alpha <- alphas[j]
  est1_ZZ <- est2_ZZ <- est1_ZZ1 <-
    est2_ZZ1 <- matrix(0, nrow = 2, ncol = num_reps)

  n_iter <- rep(0, num_reps)

  stick_to_one <- rep(0,num_reps)
  comp_eff <- matrix(0, num_reps, 2)
  ngrad <- matrix(0, num_reps, 2)
  i=1
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",alpha,"_iter_",i,".Rdata"))

    if(fe){
      load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",alpha,"_iter_",i,".Rdata"))
      nr <- 2

      stick_to_one[i] = 1- rjpdmp::model_probabilities(zigzag_fit_ada$times, thetas = zigzag_fit_ada$thetas, marginals = 3)$marginal_prob
      est1_ZZ[,i] <- c_mm(zigzag_fit_ada); est2_ZZ[,i] <- c_mm2(zigzag_fit_ada)
      est_ZZ_all_1[j+1,i] <- est1_ZZ[1,i]
      est_ZZ_all_2[j+1,i] <- est2_ZZ[1,i]
      ngrad[i,1] <- zigzag_fit_ada$nits

      comp_eff[i,1] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits

      load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- c_mm(zigzag_fit_ada); est2_ZZ1[,i] <- c_mm2(zigzag_fit_ada)
      est_ZZ_all_1[1,i] <- est1_ZZ1[1,i]
      est_ZZ_all_2[1,i] <- est2_ZZ1[1,i]
      comp_eff[i,2] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits
      ngrad[i,2] <- zigzag_fit_ada$nits

    } else{
      ind_rem <- c(ind_rem, i)
    }
  }
  prob_1 <- c(1,mean(stick_to_one))
  comp <- colMeans(comp_eff)[2:1]

  ngrad2 <- rbind(ngrad[,2],ngrad[,2])
  ngrad1 <- rbind(ngrad[,1],ngrad[,1])
  rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - exact_mom_1)^2 * ngrad2 )),
                  sqrt(rowMeans((est1_ZZ - exact_mom_1)^2 *ngrad1)))
  rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                  rmse_1[1,]/rmse_1[2,])
  rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - exact_mom_2)^2 * ngrad2)),
                  sqrt(rowMeans((est2_ZZ - exact_mom_2)^2 * ngrad1)))
  rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                  rmse_2[1,]/rmse_2[2,])
  method <- c("Zig-Zag", "ctZig-Zag")
  if(j ==1){
    row_add <- data.frame(method = method, alpha = c(1,alpha),
                          prob_1 = prob_1, Ex = rmse_1,
                          Ex2 = rmse_2, computation = comp)
  } else {
    row_add <- rbind(row_add,
                     data.frame(method = method, alpha = c(1,alpha),
                                prob_1 = prob_1, Ex = rmse_1,
                                Ex2 = rmse_2, computation = comp)[-1,])
  }
}
row_add

## Add in the Importance Sampling version (alpha = 0)....
alpha <- 0
est1_ZZ <- est2_ZZ <- est1_ZZ1 <-
  est2_ZZ1 <- matrix(0, nrow = 2, ncol = num_reps)

n_iter <- rep(0, num_reps)

stick_to_one <- rep(0,num_reps)
ngrad <- comp_eff <- matrix(0, num_reps, 2)
i=1
for( i in 1:num_reps ){
  fe <- file.exists(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",alpha,"_iter_",i,".Rdata"))

  if(fe){
    load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",alpha,"_iter_",i,".Rdata"))
    nr <- 2

    stick_to_one[i] = 1- rjpdmp::model_probabilities(zigzag_fit_ada$times, thetas = zigzag_fit_ada$thetas, marginals = 3)$marginal_prob

    est1_ZZ[,i] <- colSums(t(zigzag_samplesl$samples[1:nr,])*w_1_zz_norml)
    est2_ZZ[,i] <- diag(crossprod(t(zigzag_samplesl$samples[1:nr,])*w_1_zz_norml, t(zigzag_samplesl$samples[1:nr,])))

    est_ZZ_all_1[8,i] <- est1_ZZ[1,i]
    est_ZZ_all_2[8,i] <- est2_ZZ[1,i]
    comp_eff[i,1] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits
    ngrad[i,1] <- zigzag_fit_ada$nits +length(w_1_zz_norml)

    load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",1,"_iter_",i,".Rdata"))
    est1_ZZ1[,i] <- c_mm(zigzag_fit_ada); est2_ZZ1[,i] <- c_mm2(zigzag_fit_ada)
    ngrad[i,2] <- zigzag_fit_ada$nits
    comp_eff[i,2] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits

  } else{
    ind_rem <- c(ind_rem, i)
  }
}
prob_1 <- c(1,mean(stick_to_one))
comp <- colMeans(comp_eff)[2:1]
ngrad2 <- rbind(ngrad[,2],ngrad[,2])
ngrad1 <- rbind(ngrad[,1],ngrad[,1])
rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - exact_mom_1)^2 * ngrad2 )),
                sqrt(rowMeans((est1_ZZ - exact_mom_1)^2 *ngrad1)))
rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                rmse_1[1,]/rmse_1[2,])
rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - exact_mom_2)^2 * ngrad2)),
                sqrt(rowMeans((est2_ZZ - exact_mom_2)^2 * ngrad1)))
rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                rmse_2[1,]/rmse_2[2,])
method <- c("Zig-Zag", "ctZig-Zag")

row_add <- rbind(row_add,
                 data.frame(method = method, alpha = c(1,alpha),
                            prob_1 = prob_1, Ex = rmse_1,
                            Ex2 = rmse_2, computation = comp)[-1,])
row_add
knitr::kable(row_add, digits = 3)

stargazer::stargazer(row_add, summary = F)

## Add in PT
rg <- expand.grid(NT = c(3,5,7),S = c(0.1,1,2), IT=c(0.1,0.3,0.5,0.7))
j=1
for(j in 1:nrow(rg)){
  est1_PT <- est2_PT <- est1_ZZ1 <-
    est2_ZZ1 <- matrix(0, nrow = 2, ncol = num_reps)

  n_iter <- rep(0, num_reps)

  stick_to_one <- rep(0,num_reps)
  ngrad <- comp_eff <- matrix(0, num_reps, 2)
  i=1
  NT <- rg[j,1]; S = rg[j,2]; IT = rg[j,3]
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("gmm/Cluser Code/pt/res_S_",S,"_NT_",NT,"_NR_TRUE_rep_",i,"_IT_",IT,".Rdata"))

    if(fe){
      load(paste0("gmm/Cluser Code/pt/res_S_",S,"_NT_",NT,"_NR_TRUE_rep_",i,"_IT_",IT,".Rdata"))
      nr <- 2
      burn <- 10000

      est1_PT[,i] <- colMeans(res$out[-c(1:burn),])
      est2_PT[,i] <- colMeans(res$out[-c(1:burn),]^2)

      comp_eff[i,1] <- mean(res$prop_swap[,3])
      ngrad[i,1] <- res$n_grad_eval - res$n_eval[burn]

      load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- c_mm(zigzag_fit_ada); est2_ZZ1[,i] <- c_mm2(zigzag_fit_ada)
      ngrad[i,2] <- zigzag_fit_ada$nits
      comp_eff[i,2] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits

    } else{
      ind_rem <- c(ind_rem, i)
      print(ind_rem)
    }
  }
  prob_1 <- c(1,mean(stick_to_one))
  comp <- colMeans(comp_eff)[2:1]
  ngrad2 <- rbind(ngrad[,2],ngrad[,2])
  ngrad1 <- rbind(ngrad[,1],ngrad[,1])
  rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - exact_mom_1)^2 * ngrad2 )),
                  sqrt(rowMeans((est1_PT - exact_mom_1)^2 *ngrad1)))
  rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                  rmse_1[1,]/rmse_1[2,])
  rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - exact_mom_2)^2 * ngrad2)),
                  sqrt(rowMeans((est2_PT - exact_mom_2)^2 * ngrad1)))
  rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                  rmse_2[1,]/rmse_2[2,])
  method <- c("Zig-Zag", paste0("[NR] PT (",IT,")"))

  row_add <- rbind(row_add,
                   data.frame(method = method, alpha = c(1,NT),
                              prob_1 = S, Ex = rmse_1,
                              Ex2 = rmse_2, computation = comp)[-1,])
  ##################################################################
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("gmm/Cluser Code/pt/res_S_",S,"_NT_",NT,"_NR_FALSE_rep_",i,"_IT_",IT,".Rdata"))

    if(fe){
      load(paste0("gmm/Cluser Code/pt/res_S_",S,"_NT_",NT,"_NR_FALSE_rep_",i,"_IT_",IT,".Rdata"))
      nr <- 2
      burn <- 10000

      est1_PT[,i] <- colMeans(res$out[-c(1:burn),])
      est2_PT[,i] <- colMeans(res$out[-c(1:burn),]^2)

      comp_eff[i,1] <- mean(res$prop_swap[,3])
      ngrad[i,1] <- res$n_grad_eval - res$n_eval[burn]

      load(paste0("gmm/Cluser Code/ZZ/gmm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- c_mm(zigzag_fit_ada); est2_ZZ1[,i] <- c_mm2(zigzag_fit_ada)
      ngrad[i,2] <- zigzag_fit_ada$nits
      comp_eff[i,2] <- length(zigzag_fit_ada$times)/zigzag_fit_ada$nits

    } else{
      ind_rem <- c(ind_rem, i)
      print(ind_rem)
    }
  }
  prob_1 <- c(1,mean(stick_to_one))
  comp <- colMeans(comp_eff)[2:1]
  ngrad2 <- rbind(ngrad[,2],ngrad[,2])
  ngrad1 <- rbind(ngrad[,1],ngrad[,1])
  rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - exact_mom_1)^2 * ngrad2 )),
                  sqrt(rowMeans((est1_PT - exact_mom_1)^2 *ngrad1)))
  rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                  rmse_1[1,]/rmse_1[2,])
  rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - exact_mom_2)^2 * ngrad2)),
                  sqrt(rowMeans((est2_PT - exact_mom_2)^2 * ngrad1)))
  rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                  rmse_2[1,]/rmse_2[2,])
  method <- c("Zig-Zag", paste0("[R] PT (",IT,")"))

  row_add <- rbind(row_add,
                   data.frame(method = method, alpha = c(1,NT),
                              prob_1 = S, Ex = rmse_1,
                              Ex2 = rmse_2, computation = comp)[-1,])
}

indso <- 8:nrow(row_add)
indsn <- c(2*c(1:((nrow(row_add)-8)/2))-1,2*c(1:((nrow(row_add)-8)/2)))
row_add[c(1:8,8+indsn),]


knitr::kable(row_add[c(1,5:8,8+indsn),-8], digits = 2, row.names = F)

