using JLD2, Plots

@load "bernstein.jld2"


plot(xlabel="Rounds(t)", ylabel="Regret", legend=:topleft)

for (data, name) in zip((data1, data2), ("Easy", "Hard"))
    ER = sum(data) / reps
    if false
        σR = sqrt.(sum(x -> (x[1].-ER).^2, data)/reps^2)
    else
        let q =
            [
                let s = sort(getindex.(data,t))
                s[floor(Int64,.25*reps)], s[ceil(Int64,.75*reps)]
                end
                for t in 1:T
            ]
            σR = (ER .- getindex.(q,1), getindex.(q,2).-ER)
        end
    end
    plot!(ER, ribbon=σR, label=name)
end


#plot(histogram(data1, label="lucky"),
#     histogram(data2, label="hard"))

# histogram([data2 data1], normalize=:pdf, bins=[25 2], ylim=(0,0.05), label=["hard" "easy"], xlabel="Regret", ylabel="Density")

plot!(size=div.((600,400).*3,5))
#
savefig("graph_bernstein.pdf")
gui()
