# solve matrix game
#
# min_{p∈Δ} max_{q∈Δ} p'A*q
# =
# min_{p, λ : p'A ≤ λ} λ
#

using JuMP, GLPK

function bimat(A)
    M, N = size(A);
    model = Model(GLPK.Optimizer)
    @variable(model, p[1:M] >= 0)
    @variable(model, λ)
    @objective(model, Min, λ)
    @constraint(model, c1, sum(p) == 1)
    @constraint(model, c2, λ .≥ A'p)
    #print(model)
    optimize!(model)
    [objective_value(model), value.(p), dual.(c2)]
end




function test_bimat()
    V = [
        first(bimat(randn(2,2)))
        for it in 1:100000
    ];
    histogram(V)
end
