import argparse
import numpy as np
import pdd

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('r', type=float)
    args = parser.parse_args()
    
    r = args.r
    cell = np.array([[8]])
    S_motif = np.mod(np.array([[0], [r], [2 + r], [4]]), cell[0][0])
    Q_motif = np.mod(np.array([[0], [2 + r], [4], [4 + r]]), cell[0][0])
    
    S_pdd = pdd.pdd((S_motif, cell), 10)
    Q_pdd = pdd.pdd((Q_motif, cell), 10)
    
    print(f'S({r}):', [tuple(p) for p in S_motif])
    print('PDD:')
    print(S_pdd, '\n')

    print(f'Q({r}):', [tuple(p) for p in Q_motif])
    print('PDD:')
    print(Q_pdd, '\n')

    dist = pdd.emd(S_pdd, Q_pdd)

    print(f'EMD between S({r}) and Q({r}):', dist)
