#!/bin/bash


####################################################
# Stage II: train with identity loss + idmmd loss
####################################################

epochs=6
batch_size=512
lr=1e-2
input_type='grey'
img_root_F='path to generated nirvis dataset'
train_list_F='path to nirvis data list'


###################
save_path="path to save models"
model="LightCNN-29" # or "LightCNN-9"
vis_pretrain_weight='path to model from stage I'


prefix=''
num_img_per_id=8
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python train_112_cosface_imglist_idmmd.py \
      --img_root_F=$img_root_F --train_list_F=$train_list_F \
      --vis_pretrain_weight=$vis_pretrain_weight \
      --save_path=$save_path \
      --model=$model\
      --lr=$lr\
      --num_img_per_id=$num_img_per_id\
      -b $batch_size \
      -p 200 \
      --input_type=$input_type\
      --prefix=$prefix\
      --epochs=$epochs | tee $save_path'train_'$prefix'.log'
