import tensorflow as tf
import numpy as np

def read_file(file_name,num):
    file_handle = open(file_name, mode='r')
    contents = file_handle.readlines()
    mean = np.zeros(num, dtype=float)
    std = np.zeros(num, dtype=float)
    corr = np.zeros((num,num), dtype=float)
    i = 0
    j = 0
    for each in contents:
        each = each.strip('\n').split(' ')
        if i==0:
            i += 1
            continue
        elif 0<i<=num:
            mean[j] = float(each[1])
            std[j] = float(each[2])
            i += 1
            j += 1
        elif i > num:
            m = int(each[1])-1
            n = int(each[2])-1
            corr[m,n]=float(each[3])
            corr[n,m]=float(each[3])
    cov = calculate_cov(num, corr, std)
    print(cov)
    return mean, std, cov

def calculate_cov(num,corr, std):
    ## calculate covariance with the aid of correlation and standard deviation
    cov=np.zeros((num,num))
    for i in range(num):
        for j in range(num):
            cov[i,j] = corr[i,j]*std[i]*std[j]
    return cov

def generate_u(s2,num):
    rv = np.random.randn(1,s2)
    u_norm = np.linalg.norm(rv, keepdims=None)
    rv_norm = rv/u_norm
    index = np.random.randint(1,num,size=s2)
    u = np.zeros(num)
    u[index] = rv_norm
    return u

def f(x, cov, mean, r, lam):
    ## calculate the objective function
    term_1 = np.dot(np.dot(x,cov), x.T)/(2*(np.sum(x)**2))
    a = np.sum(np.multiply(mean,x))/np.sum(x) - r
    term_2 =lam*(np.minimum(a,0)**2)
    func = term_1+ term_2
    return func

