(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     72105,       1334]
NotebookOptionsPosition[     68415,       1268]
NotebookOutlinePosition[     68837,       1285]
CellTagsIndexPosition[     68794,       1282]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.851416681970087*^9, 3.851416695838147*^9}, {
   3.851416744580942*^9, 3.851416776876783*^9}, {3.8514276657877483`*^9, 
   3.851427666926367*^9}, {3.851428689471511*^9, 3.851428766455718*^9}, {
   3.851428850863173*^9, 3.851428855250512*^9}, {3.851429037748074*^9, 
   3.851429048063833*^9}, {3.8514295948774977`*^9, 3.851429597409131*^9}, {
   3.851492271674643*^9, 3.8514922775559464`*^9}, {3.851981625066977*^9, 
   3.851981641867505*^9}, {3.860521840562456*^9, 3.860521846470766*^9}, {
   3.8605230283220673`*^9, 3.860523051375208*^9}, {3.860523209706254*^9, 
   3.860523210831297*^9}, {3.860525332366425*^9, 3.860525335564784*^9}, {
   3.860615127378584*^9, 3.8606151283085117`*^9}, {3.860615206949522*^9, 
   3.860615207458865*^9}, {3.860739761710928*^9, 3.86073976294777*^9}, {
   3.860837035837792*^9, 3.860837039554085*^9}, {3.860837879091494*^9, 
   3.8608378806076612`*^9}, {3.8608385077839537`*^9, 
   3.8608385344327707`*^9}, {3.860839267165841*^9, 3.8608392679439373`*^9}, {
   3.8608410094701557`*^9, 3.860841020520677*^9}, {3.860841068783939*^9, 
   3.860841077891548*^9}, {3.860841142130082*^9, 3.860841143072803*^9}, 
   3.8608415618590107`*^9, 3.860842250709689*^9, {3.861042131372472*^9, 
   3.861042157967301*^9}, {3.861043583271585*^9, 3.86104358471206*^9}, 
   3.861429309941463*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"aeb57f6b-479b-4d5c-8a38-3c1b1554e676"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Verifiable", " ", "version", " ", "of", " ", "the", " ", 
      "determinant"}], "-", 
     RowBox[{"based", " ", "estimator", " ", "of", " ", "Chien"}]}], ",", " ", 
    RowBox[{
     RowBox[{"Rasmussen", " ", "&"}], " ", "Sinclair", " ", 
     RowBox[{"(", "2003", ")"}], " ", "for", " ", "the", " ", "permanent", 
     " ", "of", " ", "A"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", " ", "=", " ", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "1", "0", "0"},
        {"1", "1", "1", "0"},
        {"0", "1", "1", "1"},
        {"0", "0", "1", "1"}
       }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Expected", " ", "value"}], " ", "*)"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Permanent", "[", "A", "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.851416681970087*^9, 3.851416695838147*^9}, {
   3.851416744580942*^9, 3.851416776876783*^9}, {3.8514276657877483`*^9, 
   3.851427666926367*^9}, {3.851428689471511*^9, 3.851428766455718*^9}, {
   3.851428850863173*^9, 3.851428855250512*^9}, {3.851429037748074*^9, 
   3.851429048063833*^9}, {3.8514295948774977`*^9, 3.851429597409131*^9}, {
   3.851492271674643*^9, 3.8514922775559464`*^9}, {3.851981625066977*^9, 
   3.851981641867505*^9}, {3.860521840562456*^9, 3.860521846470766*^9}, {
   3.8605230283220673`*^9, 3.860523051375208*^9}, {3.860523209706254*^9, 
   3.860523210831297*^9}, {3.860525332366425*^9, 3.860525335564784*^9}, {
   3.860615127378584*^9, 3.8606151283085117`*^9}, {3.860615206949522*^9, 
   3.860615207458865*^9}, {3.860739761710928*^9, 3.86073976294777*^9}, {
   3.860837035837792*^9, 3.860837039554085*^9}, {3.860837879091494*^9, 
   3.8608378806076612`*^9}, {3.8608385077839537`*^9, 
   3.8608385344327707`*^9}, {3.860839267165841*^9, 3.8608392679439373`*^9}, {
   3.8608410094701557`*^9, 3.860841020520677*^9}, {3.860841068783939*^9, 
   3.860841077891548*^9}, {3.860841142130082*^9, 3.860841143072803*^9}, {
   3.8608415618590107`*^9, 3.860841562784436*^9}, {3.860842723009726*^9, 
   3.8608427510589657`*^9}, {3.861044816407934*^9, 3.861044825611081*^9}, {
   3.861168934884203*^9, 3.861168953525947*^9}, {3.861428931173815*^9, 
   3.861428937152966*^9}, {3.861429015371316*^9, 3.86142913483313*^9}, {
   3.861429207468275*^9, 3.861429222390382*^9}, 3.8616857954071827`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"051279dc-4e36-4fe6-9211-c8e9c16744c8"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{
  3.860841583085887*^9, 3.860842044132687*^9, 3.860842185934085*^9, 
   3.860842324400453*^9, 3.860842416281815*^9, {3.860842472178389*^9, 
   3.860842488064124*^9}, 3.860842613196743*^9, 3.860842720911375*^9, 
   3.860842864805811*^9, {3.861042660205179*^9, 3.8610427049767227`*^9}, 
   3.861042739718444*^9, 3.86104284153461*^9, {3.861042904494514*^9, 
   3.861042916802416*^9}, 3.86104329981217*^9, 3.861043502595995*^9, 
   3.861043600837058*^9, 3.861043717532187*^9, {3.8610438376679792`*^9, 
   3.8610438587328863`*^9}, 3.861043938068459*^9, 3.86104471213732*^9, 
   3.861044795505618*^9, 3.8610448835133343`*^9, 3.861168896363462*^9, 
   3.86117102741895*^9, 3.861355122792797*^9, 3.861355969291992*^9, 
   3.861356044111123*^9, {3.8613561642244596`*^9, 3.86135618363211*^9}, 
   3.861356215609993*^9, 3.8613562671172113`*^9, {3.8613565345586147`*^9, 
   3.8613565415090017`*^9}, 3.861356628992518*^9, {3.861356959669886*^9, 
   3.861356981953999*^9}, {3.8613570167579823`*^9, 3.8613570445172567`*^9}, {
   3.861357225596965*^9, 3.861357272400991*^9}, {3.861357440092293*^9, 
   3.86135745428868*^9}, 3.861357495500177*^9, 3.861357530703734*^9, 
   3.861357562355769*^9, 3.861357607827717*^9, 3.861357729419777*^9, 
   3.86135836098883*^9, 3.8613583932088757`*^9, 3.861358458000931*^9, 
   3.861358799871408*^9, 3.861358914190365*^9, {3.861358998829688*^9, 
   3.86135901894663*^9}, {3.86135909415422*^9, 3.861359108262824*^9}, {
   3.8613591427206993`*^9, 3.8613591489666033`*^9}, 3.861359207146715*^9, 
   3.861360266701338*^9, {3.861360360059492*^9, 3.8613603853589087`*^9}, 
   3.861360429112884*^9, 3.861360601434202*^9, 3.861360695064013*^9, {
   3.861360979402645*^9, 3.8613609893973227`*^9}, 3.861361072078507*^9, 
   3.861361109002775*^9, 3.861361815602085*^9, 3.8613619731084948`*^9, 
   3.861362137822812*^9, 3.861362243559876*^9, 3.861362287533514*^9, 
   3.8614315352192383`*^9, 3.861432113419135*^9, 3.861685634817672*^9, {
   3.861685785930464*^9, 3.861685801125908*^9}, 3.861686788378169*^9, 
   3.861686887465255*^9, 3.862560367057724*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"7833c3c4-ec41-4ea3-9a63-b78a301b8faf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "number", " ", "of", " ", "samples", " ", "used", " ", "for",
       " ", "estimation"}], " ", "-", " ", 
     RowBox[{
     "rather", " ", "slow", " ", "since", " ", "we", " ", "need", " ", "10", 
      "nK", " ", "samples", " ", "for", " ", "the", " ", "interpolation"}]}], 
    ",", " ", 
    RowBox[{"so", " ", "avoid", " ", "large", " ", "values"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"K", " ", "=", " ", "25"}]}]], "Input",
 CellChangeTimes->{
  3.861349135226012*^9, {3.861360987346487*^9, 3.861360987638401*^9}, {
   3.861361881368072*^9, 3.86136188151859*^9}, {3.861362125726551*^9, 
   3.861362183516049*^9}, {3.861362242209749*^9, 3.861362242405962*^9}, {
   3.86136228602122*^9, 3.861362286104995*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"355caf0a-b1ce-41e2-aef7-5f38ccf9381d"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{
  3.86116889636677*^9, 3.8611710274312363`*^9, 3.861355122806651*^9, 
   3.861355969306353*^9, 3.861356044125111*^9, {3.8613561642400713`*^9, 
   3.861356183650133*^9}, 3.861356215626586*^9, 3.8613562671339293`*^9, {
   3.861356534576372*^9, 3.861356541525413*^9}, 3.8613566290098467`*^9, {
   3.861356959686286*^9, 3.861356981969667*^9}, {3.861357016775317*^9, 
   3.861357044537603*^9}, {3.8613572256147537`*^9, 3.861357272417116*^9}, {
   3.861357440111759*^9, 3.861357454308515*^9}, 3.861357495522915*^9, 
   3.861357530720714*^9, 3.861357562372156*^9, 3.861357607843302*^9, 
   3.861357729435272*^9, 3.861358361005919*^9, 3.861358393223781*^9, 
   3.861358458016407*^9, 3.861358799886999*^9, 3.861358914207938*^9, {
   3.8613589988451*^9, 3.8613590189610567`*^9}, {3.861359094168419*^9, 
   3.8613591082781887`*^9}, {3.861359142735824*^9, 3.861359148980105*^9}, 
   3.8613592071634073`*^9, 3.8613602667181873`*^9, {3.861360360073318*^9, 
   3.861360385376883*^9}, 3.861360429127301*^9, 3.861360601447709*^9, 
   3.861360695079197*^9, {3.861360979419086*^9, 3.861360989414777*^9}, 
   3.861361072093478*^9, 3.861361109017008*^9, 3.861361815619239*^9, 
   3.861361973122349*^9, 3.861362137838295*^9, 3.861362243574108*^9, 
   3.861362287555637*^9, 3.861431535241172*^9, 3.861432113430728*^9, 
   3.861685634832302*^9, {3.86168578594198*^9, 3.86168580113787*^9}, 
   3.86168678839144*^9, 3.861686887481963*^9, 3.862560367072617*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"d4bf25fd-0660-491e-a99e-3064160e6db7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", "1000000009", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Pick", " ", "a", " ", "prime", " ", "of", " ", "the", " ", "form", " ", 
     "4", "k"}], "+", 
    RowBox[{
    "1", " ", "to", " ", "be", " ", "used", " ", "as", " ", "a", " ", 
     "modulus"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.851416681970087*^9, 3.851416695838147*^9}, {
   3.851416744580942*^9, 3.851416776876783*^9}, {3.8514276657877483`*^9, 
   3.851427666926367*^9}, {3.851428689471511*^9, 3.851428766455718*^9}, {
   3.851428850863173*^9, 3.851428855250512*^9}, {3.851429037748074*^9, 
   3.851429048063833*^9}, {3.8514295948774977`*^9, 3.851429597409131*^9}, {
   3.851492271674643*^9, 3.8514922775559464`*^9}, {3.851981625066977*^9, 
   3.851981641867505*^9}, {3.860521840562456*^9, 3.860521846470766*^9}, {
   3.8605230283220673`*^9, 3.860523051375208*^9}, {3.860523209706254*^9, 
   3.860523210831297*^9}, {3.860525332366425*^9, 3.860525335564784*^9}, {
   3.860615127378584*^9, 3.8606151283085117`*^9}, {3.860615206949522*^9, 
   3.860615207458865*^9}, {3.860739761710928*^9, 3.86073976294777*^9}, {
   3.860837035837792*^9, 3.860837039554085*^9}, {3.860837879091494*^9, 
   3.8608378806076612`*^9}, {3.8608385077839537`*^9, 
   3.8608385344327707`*^9}, {3.860839267165841*^9, 3.8608392679439373`*^9}, {
   3.8608410094701557`*^9, 3.860841020520677*^9}, {3.860841068783939*^9, 
   3.860841077891548*^9}, {3.860841142130082*^9, 3.860841143072803*^9}, {
   3.8608415618590107`*^9, 3.860841562784436*^9}, 3.8611689279623423`*^9, {
   3.861429238483293*^9, 3.861429269185915*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0f1573dc-8cfc-45ed-b0c3-be70d19fb8cb"],

Cell[BoxData["1000000009"], "Output",
 CellChangeTimes->{
  3.860523091119032*^9, 3.860523397368081*^9, 3.8605234907706738`*^9, {
   3.8605244643833027`*^9, 3.8605244893803873`*^9}, 3.860524579426282*^9, {
   3.86052461416553*^9, 3.860524662750978*^9}, {3.86052512275636*^9, 
   3.8605251336906347`*^9}, 3.8605252743189783`*^9, 3.860525337592906*^9, 
   3.860525480456151*^9, 3.8606151347685947`*^9, 3.860738877118655*^9, 
   3.860738948753373*^9, {3.860739466573361*^9, 3.8607394998189793`*^9}, 
   3.860739712942108*^9, 3.860739822371644*^9, 3.8607398644708433`*^9, 
   3.860739999922781*^9, {3.86074003383237*^9, 3.8607400512453737`*^9}, 
   3.86074016486444*^9, 3.860740365763193*^9, {3.860740419754957*^9, 
   3.860740481303742*^9}, {3.860740573305729*^9, 3.860740603326371*^9}, 
   3.860836170504222*^9, {3.8608368406517553`*^9, 3.860836867863603*^9}, 
   3.8608369154118147`*^9, 3.8608371143107767`*^9, 3.8608374183768187`*^9, 
   3.860837503472522*^9, 3.8608377605127287`*^9, 3.860837899176331*^9, {
   3.8608380704173594`*^9, 3.86083809129955*^9}, 3.860838252441441*^9, 
   3.860838286263748*^9, 3.860838541115569*^9, 3.8608393208027477`*^9, 
   3.860839358056937*^9, 3.860839670016199*^9, 3.860840791130588*^9, 
   3.860841035046089*^9, {3.860841073252667*^9, 3.860841083064074*^9}, 
   3.86084119640164*^9, 3.860841259167708*^9, 3.860841359077222*^9, 
   3.860841531587105*^9, 3.86084158310925*^9, 3.860842044160858*^9, 
   3.86084218596052*^9, 3.860842324430765*^9, 3.860842416306181*^9, {
   3.8608424722030783`*^9, 3.860842488091331*^9}, 3.860842613222439*^9, 
   3.860842864831614*^9, {3.861042660228099*^9, 3.861042705000843*^9}, 
   3.861042739743829*^9, 3.8610428415586243`*^9, {3.861042904517503*^9, 
   3.861042916833001*^9}, 3.861043299840085*^9, 3.861043502622342*^9, 
   3.861043600866604*^9, 3.861043717560966*^9, {3.861043837696616*^9, 
   3.861043858762014*^9}, 3.861043938095188*^9, 3.8610447121645823`*^9, 
   3.8610447955331078`*^9, 3.8610448835393333`*^9, 3.86116889638527*^9, 
   3.8611710274436913`*^9, 3.8613551228107567`*^9, 3.86135596932154*^9, 
   3.86135604414011*^9, {3.8613561642563543`*^9, 3.8613561836665077`*^9}, 
   3.861356215641362*^9, 3.8613562671503983`*^9, {3.861356534593738*^9, 
   3.861356541541046*^9}, 3.861356629026895*^9, {3.861356959701984*^9, 
   3.861356981985292*^9}, {3.8613570167910967`*^9, 3.861357044557617*^9}, {
   3.861357225631015*^9, 3.8613572724341993`*^9}, {3.861357440130054*^9, 
   3.861357454328629*^9}, 3.861357495543537*^9, 3.861357530738554*^9, 
   3.861357562387103*^9, 3.8613576078581467`*^9, 3.861357729449759*^9, 
   3.861358361024741*^9, 3.8613583932390127`*^9, 3.861358458031089*^9, 
   3.8613587999014473`*^9, 3.861358914224769*^9, {3.861358998861024*^9, 
   3.861359018974164*^9}, {3.86135909417312*^9, 3.8613591082917147`*^9}, {
   3.86135914274972*^9, 3.861359148993327*^9}, 3.861359207168297*^9, 
   3.861360266733719*^9, {3.8613603600875187`*^9, 3.8613603853949213`*^9}, 
   3.861360429141623*^9, 3.861360601461543*^9, 3.861360695093216*^9, {
   3.861360979435691*^9, 3.8613609894291353`*^9}, 3.861361072106667*^9, 
   3.8613611090308323`*^9, 3.861361815634638*^9, 3.861361973135914*^9, 
   3.861362137851675*^9, 3.861362243587833*^9, 3.861362287568686*^9, 
   3.861431535251033*^9, 3.8614321134434443`*^9, 3.861685634846059*^9, {
   3.861685785952537*^9, 3.861685801149025*^9}, 3.8616867884034367`*^9, 
   3.861686887498538*^9, 3.862560367083723*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"9211221a-1848-4f2f-a07d-a99bd6df4508"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "More", " ", "efficient", " ", "InterpolatingPolynomial", " ", "for", " ", 
    
    RowBox[{"Z", "/", "pZ"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"InterpolatingPolynomialMod", "[", 
    RowBox[{"y_", ",", " ", "x_"}], "]"}], " ", ":=", " ", 
   RowBox[{"(", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "*", " ", 
         RowBox[{"Product", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", " ", "-", " ", "j"}], ")"}], 
            RowBox[{"PowerMod", "[", 
             RowBox[{
              RowBox[{"i", " ", "-", " ", "j"}], ",", 
              RowBox[{"p", "-", "2"}], ",", "p"}], "]"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"j", ",", " ", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"k", "!=", "i"}], ",", "k", ",", 
                 RowBox[{
                  RowBox[{"##", "&"}], "[", "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", 
                 RowBox[{
                  RowBox[{"Dimensions", "[", "y", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}],
           "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", 
          RowBox[{
           RowBox[{"Dimensions", "[", "y", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}], ",", "p"}], 
     "]"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.861041163641878*^9, 3.8610412407606792`*^9}, {
   3.861041333567437*^9, 3.861041343486315*^9}, {3.86104139855153*^9, 
   3.861041518441334*^9}, {3.861041561285063*^9, 3.8610415657781363`*^9}, 
   3.861041608775947*^9, {3.8610416417115803`*^9, 3.8610416725606813`*^9}, {
   3.861041741171322*^9, 3.861041845359171*^9}, {3.861041900991781*^9, 
   3.861041920160315*^9}, {3.861042056078546*^9, 3.861042070609756*^9}, {
   3.8610421892076473`*^9, 3.861042215470908*^9}, {3.8610422503841953`*^9, 
   3.861042278136446*^9}, {3.8610424859232807`*^9, 3.861042490089868*^9}, {
   3.861042563994916*^9, 3.861042572226665*^9}, {3.8610426126523037`*^9, 
   3.861042664655149*^9}, {3.861042694935421*^9, 3.861042737605617*^9}, {
   3.861042794452064*^9, 3.861042799941368*^9}, {3.861043068685729*^9, 
   3.861043088402647*^9}, {3.861043170851461*^9, 3.8610431742032757`*^9}, {
   3.861043264908429*^9, 3.86104326625912*^9}, {3.861043297156538*^9, 
   3.861043298274489*^9}, {3.8610434465903254`*^9, 3.8610435001965103`*^9}, {
   3.8610437066717033`*^9, 3.8610437147765303`*^9}, {3.8611696537622957`*^9, 
   3.861169660536841*^9}, {3.861169741794979*^9, 3.8611697770983*^9}, {
   3.861361431682209*^9, 3.861361445314548*^9}, {3.861361493697667*^9, 
   3.8613614964315434`*^9}, {3.861361631361614*^9, 3.861361670062635*^9}, 
   3.861428922554987*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"ce8ddf80-aee9-48c8-8dac-e65481c99f39"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n", "=", 
  RowBox[{
   RowBox[{"Dimensions", "[", "A", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.851417812065854*^9, 3.851417841778015*^9}, {
   3.851417930420417*^9, 3.8514179310322943`*^9}, {3.8608392778845863`*^9, 
   3.8608393383936577`*^9}, {3.8608396524755907`*^9, 
   3.8608396571514997`*^9}, {3.860840780412834*^9, 3.86084078851693*^9}, 
   3.8608408665424833`*^9, 3.86084102881581*^9, 3.860841064119059*^9, {
   3.8608411633566017`*^9, 3.860841194230896*^9}, 3.8608415675818577`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"82f9f139-1ac3-4fef-af66-8c8fb95cb2c6"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.860841583119582*^9, 3.860842044187739*^9, 3.86084218598627*^9, 
   3.860842324458125*^9, 3.8608424163305883`*^9, {3.860842472227086*^9, 
   3.86084248811747*^9}, 3.860842613246179*^9, 3.860842864855288*^9, {
   3.86104266027715*^9, 3.8610427050380077`*^9}, 3.8610427397906637`*^9, 
   3.861042841605515*^9, {3.861042904564692*^9, 3.8610429168726892`*^9}, 
   3.861043299892934*^9, 3.861043502659828*^9, 3.8610436009203978`*^9, 
   3.861043717598544*^9, {3.861043837747273*^9, 3.861043858815778*^9}, 
   3.861043938147416*^9, 3.861044712215151*^9, 3.861044795587501*^9, 
   3.861044883592499*^9, 3.8611688964112167`*^9, 3.861171027471278*^9, 
   3.8613551228271093`*^9, 3.861355969338904*^9, 3.861356044157115*^9, {
   3.861356164275345*^9, 3.86135618368823*^9}, 3.86135621566228*^9, 
   3.861356267169352*^9, {3.861356534613797*^9, 3.8613565415635347`*^9}, 
   3.861356629047523*^9, {3.8613569597196703`*^9, 3.86135698200439*^9}, {
   3.86135701680926*^9, 3.861357044581601*^9}, {3.861357225650647*^9, 
   3.861357272455369*^9}, {3.861357440151142*^9, 3.8613574543520527`*^9}, 
   3.861357495567483*^9, 3.861357530758552*^9, 3.861357562405287*^9, 
   3.861357607877062*^9, 3.861357729468081*^9, 3.86135836104841*^9, 
   3.861358393259431*^9, 3.861358458051958*^9, 3.861358799921673*^9, 
   3.861358914246746*^9, {3.861358998880212*^9, 3.86135901898983*^9}, {
   3.861359094189299*^9, 3.8613591083082037`*^9}, {3.8613591427660007`*^9, 
   3.861359149010262*^9}, 3.86135920718477*^9, 3.861360266754838*^9, {
   3.8613603601045218`*^9, 3.8613603854168777`*^9}, 3.8613604291586847`*^9, 
   3.8613606015321217`*^9, 3.861360695111264*^9, {3.86136097945544*^9, 
   3.861360989449512*^9}, 3.861361072123107*^9, 3.8613611090487137`*^9, 
   3.8613618156584053`*^9, 3.861361973157434*^9, 3.861362137870825*^9, 
   3.86136224360747*^9, 3.861362287588745*^9, 3.861431535265448*^9, 
   3.861432113460712*^9, 3.861685634861742*^9, {3.861685785968894*^9, 
   3.8616858011655283`*^9}, 3.861686788420867*^9, 3.861686887521682*^9, 
   3.862560367100676*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"a50871bd-1739-4d21-be87-90ffbf6428d3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Random", " ", "pairs", " ", "from", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], "^", "3"}], " ", "since", " ", 
    "we", " ", "operate", " ", "with", " ", "fourth", " ", "roots", " ", "of",
     " ", "unity", " ", "and", " ", "quaternion", " ", "basis"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "first", " ", "two", " ", "bits", " ", "are", " ", "used", " ",
     "to", " ", "pick", " ", "a", " ", "random", " ", "2", "\[Times]", "2", 
    " ", "submatrix", " ", "and", " ", "the", " ", "last", " ", "bit", " ", 
    "determines", " ", "its", " ", "sign"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"xs", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"RandomInteger", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"j", ",", " ", "3"}], "}"}]}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", " ", "1", ",", " ", 
          RowBox[{"10", " ", "*", " ", 
           RowBox[{"Ceiling", "[", 
            RowBox[{"Log2", "[", "K", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"n", "*", "n"}]}], "}"}]}], "]"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.851429379885448*^9, 3.85142939918229*^9}, 
   3.85142955346804*^9, {3.851491809099801*^9, 3.851491811651771*^9}, {
   3.851491848297344*^9, 3.8514918867081623`*^9}, {3.851491939056222*^9, 
   3.851491970357894*^9}, {3.8516808787622843`*^9, 3.851680908288288*^9}, {
   3.85168094676272*^9, 3.8516809920443783`*^9}, {3.851681042547407*^9, 
   3.851681051026404*^9}, {3.851681093968948*^9, 3.8516810950161667`*^9}, {
   3.8516813400820827`*^9, 3.851681341283841*^9}, {3.851692022375203*^9, 
   3.85169202860121*^9}, {3.852973049444162*^9, 3.852973049815905*^9}, {
   3.852973166312801*^9, 3.8529731664440813`*^9}, {3.852977832174547*^9, 
   3.852977853475643*^9}, 3.852982629665619*^9, 3.8605233959252853`*^9, 
   3.8605243018165283`*^9, {3.8605244362545958`*^9, 3.860524484790409*^9}, 
   3.8605245235911083`*^9, {3.8605254077154293`*^9, 3.860525476642808*^9}, 
   3.860738947348825*^9, {3.860787175852433*^9, 3.8607871880170937`*^9}, {
   3.860836518422082*^9, 3.860836520390162*^9}, {3.8608368661012497`*^9, 
   3.860836866405863*^9}, {3.8608380611410217`*^9, 3.860838090153343*^9}, {
   3.860838284878063*^9, 3.860838285160431*^9}, {3.8608394122426043`*^9, 
   3.860839451700057*^9}, {3.8608395238826847`*^9, 3.8608395328250647`*^9}, {
   3.860841080851153*^9, 3.860841081269136*^9}, {3.860841257439563*^9, 
   3.860841257887751*^9}, {3.860841528620553*^9, 3.860841530380664*^9}, {
   3.860841679384409*^9, 3.86084168920498*^9}, {3.8610438363604183`*^9, 
   3.861043857581164*^9}, {3.861044594913907*^9, 3.861044609083235*^9}, 
   3.861044787963146*^9, {3.8611697253612003`*^9, 3.861169728991346*^9}, {
   3.861169904399485*^9, 3.8611699386938562`*^9}, {3.8612690501490192`*^9, 
   3.86126907050275*^9}, {3.861429446538576*^9, 3.861429483147459*^9}, {
   3.861686001428444*^9, 3.861686001585615*^9}, 3.86168682506806*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"3a9c4d00-56a9-4e49-a2fb-b2e31ede68e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"omega", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", "/.", " ", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "==", 
        RowBox[{"-", "1"}]}], ",", "x", ",", " ", 
       RowBox[{"Modulus", " ", "->", " ", "p"}]}], "]"}]}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"The", " ", "fourth", " ", "root", " ", "of", " ", "unity"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.8516815068153563`*^9, 3.851681509079809*^9}, {
   3.8516820636311827`*^9, 3.8516820899551363`*^9}, {3.851682121408633*^9, 
   3.8516821428116217`*^9}, {3.851682323327739*^9, 3.851682361190667*^9}, {
   3.85168241721692*^9, 3.851682424501685*^9}, {3.851688975871439*^9, 
   3.851688982278104*^9}, {3.851690161754356*^9, 3.851690285032618*^9}, {
   3.8516919098112497`*^9, 3.851691977474369*^9}, {3.851761022390148*^9, 
   3.851761028876663*^9}, 3.852973280526024*^9, {3.852974847482667*^9, 
   3.852974903379108*^9}, {3.860523448636697*^9, 3.860523488381818*^9}, {
   3.8605238738938*^9, 3.8605238812012157`*^9}, {3.860524210154974*^9, 
   3.860524214251045*^9}, {3.860524411504335*^9, 3.860524426658371*^9}, {
   3.860524571849186*^9, 3.8605245763790483`*^9}, {3.86052464229317*^9, 
   3.8605246611615*^9}, {3.860524695736415*^9, 3.8605247172043943`*^9}, {
   3.8605250613605623`*^9, 3.860525098465068*^9}, {3.860525497264624*^9, 
   3.860525497582837*^9}, {3.8608413464048634`*^9, 3.860841353933055*^9}, {
   3.860841410642335*^9, 3.8608414228746233`*^9}, 3.8608415397426567`*^9, {
   3.8608423512856913`*^9, 3.860842413196747*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"f9154fa4-954a-4aec-83f6-416dfcae8fc5"],

Cell[BoxData["430477711"], "Output",
 CellChangeTimes->{
  3.8608415832002907`*^9, 3.860842044268393*^9, 3.860842186064979*^9, 
   3.860842324522841*^9, 3.860842416389676*^9, {3.8608424722801533`*^9, 
   3.860842488178562*^9}, 3.860842613306944*^9, 3.860842864914042*^9, {
   3.861042660335849*^9, 3.861042705099156*^9}, 3.8610427398479433`*^9, 
   3.861042841657275*^9, {3.861042904616001*^9, 3.8610429169345512`*^9}, 
   3.861043299951955*^9, 3.861043502724962*^9, 3.861043600983028*^9, 
   3.8610437176618843`*^9, {3.861043837807496*^9, 3.861043858873527*^9}, 
   3.861043938200293*^9, 3.861044712275663*^9, 3.861044795652351*^9, 
   3.861044883653911*^9, 3.8611688964519243`*^9, 3.8611710274910173`*^9, 
   3.861355122854793*^9, 3.8613559693621387`*^9, 3.861356044181553*^9, {
   3.8613561643007727`*^9, 3.861356183710908*^9}, 3.8613562156884117`*^9, 
   3.8613562671981*^9, {3.861356534640931*^9, 3.861356541590499*^9}, 
   3.861356629077091*^9, {3.8613569597470417`*^9, 3.861356982031075*^9}, {
   3.861357016836997*^9, 3.861357044611619*^9}, {3.8613572256783533`*^9, 
   3.861357272481536*^9}, {3.8613574401793756`*^9, 3.861357454381612*^9}, 
   3.861357495596753*^9, 3.861357530780245*^9, 3.861357562425993*^9, 
   3.861357607899284*^9, 3.861357729488337*^9, 3.861358361075138*^9, 
   3.861358393286644*^9, 3.861358458078944*^9, 3.861358799950128*^9, 
   3.861358914272668*^9, {3.8613589989029493`*^9, 3.861359019011224*^9}, {
   3.861359094210548*^9, 3.8613591083305273`*^9}, {3.861359142787004*^9, 
   3.8613591490307283`*^9}, 3.861359207204236*^9, 3.861360266779272*^9, {
   3.861360360126436*^9, 3.8613603854404583`*^9}, 3.8613604291794567`*^9, 
   3.8613606017113028`*^9, 3.8613606951318398`*^9, {3.86136097947838*^9, 
   3.8613609894745617`*^9}, 3.861361072144767*^9, 3.861361109070068*^9, 
   3.861361815685245*^9, 3.861361973180007*^9, 3.861362137892322*^9, 
   3.861362243628252*^9, 3.861362287610488*^9, 3.8614315352912416`*^9, 
   3.861432113474872*^9, 3.861685634876205*^9, {3.861685785983055*^9, 
   3.861685801180996*^9}, 3.861686788529537*^9, 3.861686887552302*^9, 
   3.8625603671309853`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"2aac001f-8e36-4a3a-87d3-7411bc97d972"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subset", "-", 
    RowBox[{"sum", " ", "expansion"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"y", "[", 
    RowBox[{"t_", ",", " ", "x_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", " ", "+", " ", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], " ", "-", " ", "1"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", " ", 
            RowBox[{
             RowBox[{"Dimensions", "[", "t", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}], ")"}], " ", 
      "/", " ", "2"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "3"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8516815068153563`*^9, 3.851681509079809*^9}, {
   3.8516820636311827`*^9, 3.8516820899551363`*^9}, {3.851682121408633*^9, 
   3.8516821428116217`*^9}, {3.851682323327739*^9, 3.851682361190667*^9}, {
   3.85168241721692*^9, 3.851682424501685*^9}, {3.851688975871439*^9, 
   3.851688982278104*^9}, {3.851690161754356*^9, 3.851690285032618*^9}, {
   3.8516919098112497`*^9, 3.851691977474369*^9}, {3.851761022390148*^9, 
   3.851761028876663*^9}, 3.852973280526024*^9, {3.852974847482667*^9, 
   3.852974903379108*^9}, {3.860523448636697*^9, 3.860523488381818*^9}, {
   3.8605238738938*^9, 3.8605238812012157`*^9}, {3.860524210154974*^9, 
   3.860524214251045*^9}, {3.860524411504335*^9, 3.860524426658371*^9}, {
   3.860524571849186*^9, 3.8605245763790483`*^9}, {3.86052464229317*^9, 
   3.8605246611615*^9}, {3.860524695736415*^9, 3.8605247172043943`*^9}, {
   3.8605250613605623`*^9, 3.860525098465068*^9}, {3.860525497264624*^9, 
   3.860525497582837*^9}, {3.8608413464048634`*^9, 3.860841353933055*^9}, {
   3.860841410642335*^9, 3.8608414228746233`*^9}, 3.8608415397426567`*^9, {
   3.860841953955105*^9, 3.860842042644532*^9}, {3.8611708182828817`*^9, 
   3.861170826843334*^9}, {3.861350050725739*^9, 3.8613500597641172`*^9}, {
   3.8613501177091*^9, 3.861350159844606*^9}, {3.861350619273567*^9, 
   3.861350676680285*^9}, {3.861360286443431*^9, 3.861360296326538*^9}, {
   3.861686005212801*^9, 3.861686029605754*^9}, {3.861686948168131*^9, 
   3.861686958089861*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"20f8c214-df7c-4fce-ba0d-7476cc636656"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Convert", " ", "randomness", " ", "into", " ", "a", " ", 
     "\"\<quaternion\>\""}], "-", 
    RowBox[{"valued", " ", "matrix"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"RandomSubset", "[", "m_", "]"}], " ", ":=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1"}], "}"}], "]"}], "==", "1"}], ",", "k", 
       ",", 
       RowBox[{
        RowBox[{"##", "&"}], "[", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "m"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8516858188783617`*^9, 3.8516858305000963`*^9}, {
   3.851685926645191*^9, 3.851685939207974*^9}, {3.8516860190589733`*^9, 
   3.851686071533526*^9}, {3.851686174238771*^9, 3.8516862139242363`*^9}, {
   3.851686871735155*^9, 3.851686893791285*^9}, {3.85168834581247*^9, 
   3.851688363753331*^9}, {3.851690487157887*^9, 3.8516904882759333`*^9}, {
   3.851691702782745*^9, 3.8516917334306717`*^9}, {3.8519811488648443`*^9, 
   3.851981225206666*^9}, {3.852975661221488*^9, 3.852975691052268*^9}, 
   3.86052551749686*^9, 3.860841541840817*^9, {3.861361917771346*^9, 
   3.861361941978031*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"1f3fe976-e47f-4e17-8f60-193e32f82a65"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomSeq", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{
      RowBox[{"RandomSubset", "[", 
       RowBox[{
        RowBox[{"Dimensions", "[", 
         RowBox[{"x", "[", 
          RowBox[{"[", "j", "]"}], "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", " ", 
      RowBox[{"x", "[", 
       RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"n", " ", "*", " ", "n"}]}], "}"}]}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.8516858188783617`*^9, 3.8516858305000963`*^9}, {
   3.851685926645191*^9, 3.851685939207974*^9}, {3.8516860190589733`*^9, 
   3.851686071533526*^9}, {3.851686174238771*^9, 3.8516862139242363`*^9}, {
   3.851686871735155*^9, 3.851686893791285*^9}, {3.85168834581247*^9, 
   3.851688363753331*^9}, {3.851690487157887*^9, 3.8516904882759333`*^9}, {
   3.851691702782745*^9, 3.8516917334306717`*^9}, {3.8519811488648443`*^9, 
   3.851981225206666*^9}, {3.852975661221488*^9, 3.852975691052268*^9}, 
   3.86052551749686*^9, 3.860841541840817*^9, {3.8610446921847067`*^9, 
   3.8610447048541393`*^9}, {3.861347763265815*^9, 3.86134778287466*^9}, {
   3.8613480692602587`*^9, 3.861348100085516*^9}, {3.861349461412743*^9, 
   3.861349482688596*^9}, {3.861349599725971*^9, 3.861349630584852*^9}, {
   3.861349675142578*^9, 3.861349679144717*^9}, {3.861349721319648*^9, 
   3.861349757653138*^9}, {3.86135071333827*^9, 3.861350799173691*^9}, {
   3.86135124987368*^9, 3.861351261756645*^9}, {3.8613512996459627`*^9, 
   3.861351342770216*^9}, {3.861352920441765*^9, 3.8613529298193417`*^9}, {
   3.861352987488059*^9, 3.86135299425622*^9}, {3.861353891954767*^9, 
   3.8613540530890827`*^9}, {3.861354100614037*^9, 3.861354241762601*^9}, {
   3.8613552331448298`*^9, 3.861355271360837*^9}, {3.861355305505252*^9, 
   3.861355310901614*^9}, {3.8613554918084173`*^9, 3.861355492747903*^9}, {
   3.861355871189209*^9, 3.861355883983633*^9}, {3.861355944344294*^9, 
   3.861355944890585*^9}, {3.861355977644856*^9, 3.861355987809243*^9}, {
   3.861356034060316*^9, 3.861356039189603*^9}, {3.861686071049506*^9, 
   3.8616860761473494`*^9}, {3.861686682383143*^9, 3.8616866824945927`*^9}, {
   3.861686830701667*^9, 3.861686841967844*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"6e036173-6137-4674-a284-8eacc6a383a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Pick", " ", "an", " ", "interpolating", " ", "polynomial", " ", "for", 
    " ", "a", " ", "matrix", " ", "entry", " ", "based", " ", "on", " ", 
    "where", " ", "in", " ", "the", " ", "submatrix", " ", "we", " ", "are"}],
    " ", "*)"}], 
  RowBox[{
   RowBox[{"SubEntry", "[", 
    RowBox[{"seq_", ",", "i_", ",", "j_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"seq", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"i", "==", "0"}], "&&", " ", 
         RowBox[{"j", "==", "0"}]}], ",", " ", 
        RowBox[{"InterpolatingPolynomial", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "omega", ",", " ", "0", ",", " ", "0"}], "}"}], 
          ",", "x"}], "]"}], ",", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i", "==", "0"}], " ", "&&", " ", 
           RowBox[{"j", "==", "1"}]}], ",", " ", 
          RowBox[{"InterpolatingPolynomial", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", " ", "0", ",", " ", "1", ",", "omega"}], "}"}],
             ",", "x"}], "]"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"j", "==", "0"}], ",", " ", 
            RowBox[{"InterpolatingPolynomial", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", " ", 
                RowBox[{"omega", "^", "2"}], ",", " ", "omega"}], "}"}], ",", 
              "x"}], "]"}], ",", 
            RowBox[{"InterpolatingPolynomial", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"omega", "^", "3"}], ",", " ", "0", ",", " ", "0"}], 
               "}"}], ",", "x"}], "]"}]}], "]"}]}], "]"}]}], "]"}], " ", "/.",
       " ", 
      RowBox[{"x", "->", " ", 
       RowBox[{
        RowBox[{"seq", "[", 
         RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
        RowBox[{"2", 
         RowBox[{"seq", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "+", "1"}]}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8516858188783617`*^9, 3.8516858305000963`*^9}, {
   3.851685926645191*^9, 3.851685939207974*^9}, {3.8516860190589733`*^9, 
   3.851686071533526*^9}, {3.851686174238771*^9, 3.8516862139242363`*^9}, {
   3.851686871735155*^9, 3.851686893791285*^9}, {3.85168834581247*^9, 
   3.851688363753331*^9}, {3.851690487157887*^9, 3.8516904882759333`*^9}, {
   3.851691702782745*^9, 3.8516917334306717`*^9}, {3.8519811488648443`*^9, 
   3.851981225206666*^9}, {3.852975661221488*^9, 3.852975691052268*^9}, 
   3.86052551749686*^9, 3.860841541840817*^9, {3.8610446921847067`*^9, 
   3.8610447048541393`*^9}, {3.861347763265815*^9, 3.86134778287466*^9}, {
   3.8613480692602587`*^9, 3.861348100085516*^9}, {3.861349461412743*^9, 
   3.861349482688596*^9}, {3.861349599725971*^9, 3.861349630584852*^9}, {
   3.861349675142578*^9, 3.861349679144717*^9}, {3.861349721319648*^9, 
   3.861349757653138*^9}, {3.86135071333827*^9, 3.861350799173691*^9}, {
   3.86135124987368*^9, 3.861351261756645*^9}, {3.8613512996459627`*^9, 
   3.861351342770216*^9}, {3.861352920441765*^9, 3.8613529298193417`*^9}, {
   3.861352987488059*^9, 3.86135299425622*^9}, {3.861353891954767*^9, 
   3.8613540530890827`*^9}, {3.861354100614037*^9, 3.861354241762601*^9}, {
   3.8613552331448298`*^9, 3.861355271360837*^9}, {3.861355305505252*^9, 
   3.861355310901614*^9}, {3.8613554918084173`*^9, 3.861355492747903*^9}, {
   3.861355871189209*^9, 3.861355883983633*^9}, {3.861355944344294*^9, 
   3.861355944890585*^9}, {3.861355977644856*^9, 3.861355987809243*^9}, {
   3.861356034060316*^9, 3.8613560422441683`*^9}, 3.861356264135043*^9, {
   3.861356527891904*^9, 3.861356533190568*^9}, {3.8613572365472403`*^9, 
   3.861357243665914*^9}, {3.861357445508009*^9, 3.86135745265878*^9}, {
   3.861357591671865*^9, 3.8613576067022142`*^9}, {3.861357664620584*^9, 
   3.8613576805364733`*^9}, {3.8613586468944073`*^9, 
   3.8613586875685472`*^9}, {3.861359012787483*^9, 3.861359061930973*^9}, {
   3.8613590930314217`*^9, 3.861359093088286*^9}, {3.861360303015318*^9, 
   3.861360372061426*^9}, {3.861360646283411*^9, 3.8613606562398643`*^9}, {
   3.861360963079701*^9, 3.861360975519657*^9}, {3.861429790824069*^9, 
   3.861429823321103*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"49642877-642a-4d21-866e-92bd12577c5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RandomMatrix", "[", 
   RowBox[{"A_", ",", " ", "seq_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"A", "[", 
           RowBox[{"[", 
            RowBox[{"Quotient", "[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"Quotient", "[", 
            RowBox[{
             RowBox[{"j", "+", "1"}], ",", "2"}], "]"}], "]"}], "]"}], 
         RowBox[{"SubEntry", "[", 
          RowBox[{
           RowBox[{"seq", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"Quotient", "[", 
               RowBox[{
                RowBox[{"j", "+", "1"}], ",", "2"}], "]"}], " ", "+", " ", 
              RowBox[{
               RowBox[{"Quotient", "[", 
                RowBox[{
                 RowBox[{"i", " ", "-", " ", "1"}], ",", "2"}], "]"}], " ", 
               "*", " ", "n"}]}], "]"}], "]"}], ",", " ", 
           RowBox[{"Mod", "[", 
            RowBox[{"i", ",", "2"}], "]"}], ",", " ", 
           RowBox[{"Mod", "[", 
            RowBox[{"j", ",", "2"}], "]"}]}], "]"}]}], ",", "p"}], "]"}], ",",
       " ", 
      RowBox[{"{", 
       RowBox[{"j", ",", " ", 
        RowBox[{"2", "n"}]}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", 
      RowBox[{"2", "n"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8516858188783617`*^9, 3.8516858305000963`*^9}, {
   3.851685926645191*^9, 3.851685939207974*^9}, {3.8516860190589733`*^9, 
   3.851686071533526*^9}, {3.851686174238771*^9, 3.8516862139242363`*^9}, {
   3.851686871735155*^9, 3.851686893791285*^9}, {3.85168834581247*^9, 
   3.851688363753331*^9}, {3.851690487157887*^9, 3.8516904882759333`*^9}, {
   3.851691702782745*^9, 3.8516917334306717`*^9}, {3.8519811488648443`*^9, 
   3.851981225206666*^9}, {3.852975661221488*^9, 3.852975691052268*^9}, 
   3.86052551749686*^9, 3.860841541840817*^9, {3.8610446921847067`*^9, 
   3.8610447048541393`*^9}, {3.861347763265815*^9, 3.86134778287466*^9}, {
   3.8613480692602587`*^9, 3.861348100085516*^9}, {3.861349461412743*^9, 
   3.861349482688596*^9}, {3.861349599725971*^9, 3.861349630584852*^9}, {
   3.861349675142578*^9, 3.861349679144717*^9}, {3.861349721319648*^9, 
   3.861349757653138*^9}, {3.86135071333827*^9, 3.861350799173691*^9}, {
   3.86135124987368*^9, 3.861351261756645*^9}, {3.8613512996459627`*^9, 
   3.861351342770216*^9}, {3.861352920441765*^9, 3.8613529298193417`*^9}, {
   3.861352987488059*^9, 3.86135299425622*^9}, {3.861353891954767*^9, 
   3.8613540530890827`*^9}, {3.861354100614037*^9, 3.861354241762601*^9}, {
   3.8613552331448298`*^9, 3.861355271360837*^9}, {3.861355305505252*^9, 
   3.861355310901614*^9}, {3.8613554918084173`*^9, 3.861355492747903*^9}, {
   3.861355871189209*^9, 3.861355883983633*^9}, {3.861355944344294*^9, 
   3.861355944890585*^9}, {3.861355977644856*^9, 3.861355987809243*^9}, {
   3.861356034060316*^9, 3.861356043053565*^9}, {3.861356161735446*^9, 
   3.861356182218515*^9}, 3.861356213933599*^9, {3.861356251382921*^9, 
   3.8613562641359797`*^9}, {3.861356540263007*^9, 3.86135655437009*^9}, {
   3.8613566272821503`*^9, 3.861356633909095*^9}, {3.861356958358204*^9, 
   3.8613570430827103`*^9}, {3.861357104979727*^9, 3.861357107854061*^9}, {
   3.861357217937265*^9, 3.86135722311348*^9}, {3.861357270850239*^9, 
   3.861357271206841*^9}, {3.86135733776831*^9, 3.861357397314033*^9}, {
   3.861357486716516*^9, 3.861357487471212*^9}, {3.861357551184948*^9, 
   3.861357561072135*^9}, {3.861358280769125*^9, 3.861358303232604*^9}, {
   3.861358385624086*^9, 3.8613583919136667`*^9}, {3.861358428919319*^9, 
   3.861358463690565*^9}, {3.861358793939259*^9, 3.861358798673532*^9}, {
   3.861358910265868*^9, 3.861358912921863*^9}, {3.861358995262865*^9, 
   3.861358997599506*^9}, {3.861360422105361*^9, 3.8613604276712313`*^9}, {
   3.86136195864957*^9, 3.861361971469339*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"dc02f99d-2ecc-499d-a011-2a859c79f77a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "the", " ", "degree", " ", "of", " ", "the", " ", "circuit"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"n", " ", "*", " ", "10", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Degree", " ", "5", " ", "per", " ", "entry"}], ",", " ", 
      RowBox[{
      "the", " ", "determinant", " ", "of", " ", "a", " ", "2", "n", " ", 
       "by", " ", "2", "n", " ", "matrix"}]}], " ", "*)"}]}]}]}]], "Input",
 CellChangeTimes->{{3.851685285454323*^9, 3.851685285458108*^9}, {
   3.8516855167367363`*^9, 3.8516855482814703`*^9}, {3.851685612389552*^9, 
   3.851685615940838*^9}, 3.851685806493462*^9, {3.851685861628491*^9, 
   3.851685866702497*^9}, {3.851686626109811*^9, 3.851686649681285*^9}, {
   3.851686841174923*^9, 3.851686842820869*^9}, {3.8516870381360407`*^9, 
   3.8516870415962276`*^9}, 3.8516874949040747`*^9, 3.8516910751108637`*^9, {
   3.8516916537226*^9, 3.851691657087916*^9}, 3.851691862601757*^9, 
   3.851691893297988*^9, {3.85198113799102*^9, 3.851981143985396*^9}, {
   3.852975693410816*^9, 3.852975693787801*^9}, {3.852977739776073*^9, 
   3.852977740415421*^9}, {3.8529778100735197`*^9, 3.85297784283352*^9}, 
   3.8529780400524282`*^9, {3.860524609402326*^9, 3.860524610795507*^9}, {
   3.860525132162751*^9, 3.860525132734621*^9}, {3.860525396064147*^9, 
   3.860525396251546*^9}, {3.86073876610643*^9, 3.860738781731564*^9}, {
   3.860738813545021*^9, 3.860738875502713*^9}, {3.860738939826693*^9, 
   3.8607389408182907`*^9}, {3.860836493854023*^9, 3.8608365628045187`*^9}, 
   3.8608366399522943`*^9, {3.8608369071557198`*^9, 3.860836908019453*^9}, {
   3.860837030685266*^9, 3.860837031000005*^9}, {3.8608371101473827`*^9, 
   3.860837112814241*^9}, 3.86084154612351*^9, {3.861170855466889*^9, 
   3.861170864740206*^9}, {3.8613591365868063`*^9, 3.861359205222074*^9}, {
   3.8613605922060423`*^9, 3.8613605965579023`*^9}, {3.86136107075428*^9, 
   3.8613610709821367`*^9}, {3.8613611038527613`*^9, 3.861361104199321*^9}, {
   3.861361852812736*^9, 3.861361864966791*^9}, {3.8616853685440397`*^9, 
   3.861685374293582*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"810f589d-69b0-4b56-a09d-5c7763a01e34"],

Cell[BoxData["40"], "Output",
 CellChangeTimes->{
  3.8608396904162197`*^9, 3.860840791283392*^9, 3.8608410352060966`*^9, {
   3.860841073498802*^9, 3.860841083223195*^9}, 3.8608411965703917`*^9, 
   3.860841259331408*^9, 3.860841359247487*^9, {3.8608415801658297`*^9, 
   3.8608415832516108`*^9}, 3.8608420443175097`*^9, 3.860842186122101*^9, 
   3.860842324571607*^9, 3.860842416439312*^9, {3.860842472330759*^9, 
   3.860842488241623*^9}, 3.8608426133587837`*^9, 3.860842864958538*^9, {
   3.8610426603701*^9, 3.861042705133938*^9}, 3.861042739882025*^9, 
   3.861042841695855*^9, {3.861042904658389*^9, 3.861042916981577*^9}, 
   3.861043299986642*^9, 3.861043502762492*^9, 3.8610436010303707`*^9, 
   3.861043717707761*^9, {3.861043837858716*^9, 3.861043858920579*^9}, 
   3.861043938247471*^9, 3.861044712323217*^9, 3.861044795704013*^9, 
   3.861044883704233*^9, 3.8611688964795837`*^9, 3.861171027525868*^9, 
   3.861355122921788*^9, 3.861355969407935*^9, 3.861356044246593*^9, {
   3.861356164371504*^9, 3.861356183773548*^9}, 3.861356215757683*^9, 
   3.8613562672686853`*^9, {3.861356534709831*^9, 3.861356541678954*^9}, 
   3.861356629145411*^9, {3.8613569598087397`*^9, 3.861356982094495*^9}, {
   3.861357016898848*^9, 3.861357044694865*^9}, {3.861357225745904*^9, 
   3.861357272849313*^9}, {3.8613574403273783`*^9, 3.861357454534924*^9}, 
   3.861357498763872*^9, {3.861357533994754*^9, 3.86135756251637*^9}, 
   3.861357608022807*^9, 3.8613577296092167`*^9, 3.861358361197917*^9, 
   3.861358393349235*^9, 3.861358458136945*^9, 3.861358800016938*^9, 
   3.861358914348468*^9, {3.8613589990233727`*^9, 3.8613590190879393`*^9}, {
   3.861359094355874*^9, 3.861359108449839*^9}, {3.861359142897275*^9, 
   3.861359149136421*^9}, 3.861359207311078*^9, 3.861360267126889*^9, {
   3.8613603603049726`*^9, 3.861360385668346*^9}, 3.86136051426094*^9, 
   3.86136060179082*^9, 3.861360695192227*^9, {3.8613609795375347`*^9, 
   3.861360989523282*^9}, 3.861361072195326*^9, 3.861361109124181*^9, 
   3.86136181574265*^9, 3.861361973240597*^9, 3.8613621379392633`*^9, 
   3.8613622436771917`*^9, 3.861362287660324*^9, 3.861431535322749*^9, 
   3.861432113499848*^9, 3.8616856349047823`*^9, {3.861685786007864*^9, 
   3.8616858012051077`*^9}, 3.8616867885700274`*^9, 3.8616868875813313`*^9, 
   3.862560367156624*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"c1e39992-506d-44e9-8558-4b5019567c2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "number", " ", "of", " ", "required", " ", "evaluations", " ", 
    "for", " ", "interpolation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"e", " ", "=", " ", 
   RowBox[{
    RowBox[{"K", " ", "*", " ", "d"}], " ", "+", " ", "1"}]}]}]], "Input",
 CellChangeTimes->{{3.851685285454323*^9, 3.851685285458108*^9}, {
   3.8516855167367363`*^9, 3.8516855482814703`*^9}, {3.851685612389552*^9, 
   3.851685615940838*^9}, 3.851685806493462*^9, {3.851685861628491*^9, 
   3.851685866702497*^9}, {3.851686626109811*^9, 3.851686649681285*^9}, {
   3.851686841174923*^9, 3.851686842820869*^9}, {3.8516870381360407`*^9, 
   3.8516870415962276`*^9}, 3.8516874949040747`*^9, 3.8516910751108637`*^9, {
   3.8516916537226*^9, 3.851691657087916*^9}, 3.851691862601757*^9, 
   3.851691893297988*^9, {3.85198113799102*^9, 3.851981143985396*^9}, {
   3.852975693410816*^9, 3.852975693787801*^9}, {3.852977739776073*^9, 
   3.852977740415421*^9}, {3.8529778100735197`*^9, 3.85297784283352*^9}, 
   3.8529780400524282`*^9, {3.860524609402326*^9, 3.860524610795507*^9}, {
   3.860525132162751*^9, 3.860525132734621*^9}, {3.860525396064147*^9, 
   3.860525396251546*^9}, {3.86073876610643*^9, 3.860738781731564*^9}, {
   3.860738813545021*^9, 3.860738875502713*^9}, {3.860738939826693*^9, 
   3.8607389408182907`*^9}, {3.860836493854023*^9, 3.8608365628045187`*^9}, 
   3.8608366399522943`*^9, {3.8608369071557198`*^9, 3.860836908019453*^9}, {
   3.860837030685266*^9, 3.860837031000005*^9}, {3.8608371101473827`*^9, 
   3.860837112814241*^9}, {3.86084154612351*^9, 3.860841547563661*^9}, {
   3.861170884800027*^9, 3.861170905327635*^9}, {3.861685447739072*^9, 
   3.861685474323957*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"e38959a0-868f-4921-bc92-a54564e70970"],

Cell[BoxData["1001"], "Output",
 CellChangeTimes->{
  3.860841583275053*^9, 3.860842044340432*^9, 3.860842186147523*^9, 
   3.8608423245961733`*^9, 3.860842416463994*^9, {3.8608424723562183`*^9, 
   3.8608424882803307`*^9}, 3.860842613382913*^9, 3.860842864984085*^9, {
   3.861042660394228*^9, 3.861042705158675*^9}, 3.861042739905273*^9, 
   3.8610428417175293`*^9, {3.861042904680477*^9, 3.861042917005869*^9}, 
   3.8610433000107203`*^9, 3.861043502788588*^9, 3.8610436010555973`*^9, 
   3.861043717733182*^9, {3.8610438378841343`*^9, 3.861043858945869*^9}, 
   3.861043938270875*^9, 3.861044712347571*^9, 3.8610447957296963`*^9, 
   3.861044883729047*^9, 3.86116889649289*^9, 3.8611710275382643`*^9, 
   3.8613551229357758`*^9, 3.861355969422805*^9, 3.861356044263011*^9, {
   3.8613561643858557`*^9, 3.861356183788355*^9}, 3.861356215772629*^9, 
   3.861356267283882*^9, {3.861356534724712*^9, 3.861356541695005*^9}, 
   3.861356629161337*^9, {3.861356959823676*^9, 3.8613569821103497`*^9}, {
   3.861357016913951*^9, 3.861357044704163*^9}, {3.861357225762205*^9, 
   3.861357272869503*^9}, {3.8613574403499804`*^9, 3.8613574545553703`*^9}, 
   3.8613574988140383`*^9, {3.861357534044552*^9, 3.861357562530899*^9}, 
   3.861357608039424*^9, 3.861357729623199*^9, 3.8613583612153683`*^9, 
   3.8613583933559027`*^9, 3.861358458151471*^9, 3.861358800033928*^9, 
   3.8613589143660707`*^9, {3.861358999036603*^9, 3.8613590191014442`*^9}, {
   3.861359094371414*^9, 3.861359108464855*^9}, {3.861359142907113*^9, 
   3.861359149149714*^9}, 3.861359207327033*^9, 3.8613602671444263`*^9, {
   3.861360360322743*^9, 3.861360385684276*^9}, 3.861360601804233*^9, 
   3.8613606952055283`*^9, {3.861360979553412*^9, 3.8613609895375233`*^9}, 
   3.861361072207622*^9, 3.861361109138785*^9, 3.8613618157590837`*^9, 
   3.861361973254209*^9, 3.861362137952611*^9, 3.8613622436936007`*^9, 
   3.861362287674811*^9, 3.861431535333*^9, 3.861432113509658*^9, 
   3.861685634915876*^9, {3.861685786017948*^9, 3.861685801215989*^9}, 
   3.861686788587865*^9, 3.8616868875933313`*^9, 3.862560367167067*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"73ac5db6-8c80-4cf5-a562-6847a0627628"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"inputs", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomSeq", "[", "xs", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "K"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.851685285454323*^9, 3.851685285458108*^9}, {
   3.8516855167367363`*^9, 3.8516855482814703`*^9}, {3.851685612389552*^9, 
   3.851685615940838*^9}, 3.851685806493462*^9, {3.851685861628491*^9, 
   3.851685866702497*^9}, {3.851686626109811*^9, 3.851686649681285*^9}, {
   3.851686841174923*^9, 3.851686842820869*^9}, {3.8516870381360407`*^9, 
   3.8516870415962276`*^9}, 3.8516874949040747`*^9, 3.8516910751108637`*^9, {
   3.8516916537226*^9, 3.851691657087916*^9}, 3.851691862601757*^9, 
   3.851691893297988*^9, {3.85198113799102*^9, 3.851981143985396*^9}, {
   3.852975693410816*^9, 3.852975693787801*^9}, {3.852977739776073*^9, 
   3.852977740415421*^9}, {3.8529778100735197`*^9, 3.85297784283352*^9}, 
   3.8529780400524282`*^9, {3.860524609402326*^9, 3.860524610795507*^9}, {
   3.860525132162751*^9, 3.860525132734621*^9}, {3.860525396064147*^9, 
   3.860525396251546*^9}, {3.86073876610643*^9, 3.860738781731564*^9}, {
   3.860738813545021*^9, 3.860738875502713*^9}, {3.860738939826693*^9, 
   3.8607389408182907`*^9}, {3.860836493854023*^9, 3.8608365628045187`*^9}, 
   3.8608366399522943`*^9, {3.8608369071557198`*^9, 3.860836908019453*^9}, {
   3.860837030685266*^9, 3.860837031000005*^9}, {3.8608371101473827`*^9, 
   3.860837112814241*^9}, {3.86084154612351*^9, 3.860841547563661*^9}, {
   3.8616868763317966`*^9, 3.8616868765086184`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"5a0088c9-9492-4355-ae20-492916342b50"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "a", " ", "single", " ", "variable", " ", "circuit", " ", 
    "of", " ", "the", " ", "estimator", " ", "and", " ", "evaluate", " ", 
    "it"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"circuit", "[", "y_", "]"}], " ", ":=", " ", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Det", "[", 
      RowBox[{"RandomMatrix", "[", 
       RowBox[{"A", ",", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"InterpolatingPolynomialMod", "[", 
             RowBox[{
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"inputs", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "[", 
                 RowBox[{"[", "k", "]"}], "]"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"i", ",", " ", "K"}], "}"}]}], "]"}], ",", "y"}], 
             "]"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"k", ",", " ", "3"}], "}"}]}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"j", ",", " ", 
            RowBox[{"n", " ", "*", " ", "n"}]}], "}"}]}], "]"}]}], "]"}], 
      "]"}], ",", "p"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852982690223474*^9, 3.852982691275523*^9}, {
   3.860525623311987*^9, 3.860525676783456*^9}, {3.860738984345974*^9, 
   3.86073902151257*^9}, {3.860739051524284*^9, 3.860739211767859*^9}, {
   3.860739247895329*^9, 3.8607392558259583`*^9}, {3.8607393180290747`*^9, 
   3.860739396712019*^9}, {3.8607394480809097`*^9, 3.860739480511197*^9}, {
   3.860739606880981*^9, 3.8607396425303097`*^9}, {3.860739676156146*^9, 
   3.860739677535603*^9}, {3.8607398383006067`*^9, 3.860739840330625*^9}, {
   3.860739963824671*^9, 3.860739995239841*^9}, {3.860740032059767*^9, 
   3.860740032856098*^9}, {3.860740141283057*^9, 3.860740141417281*^9}, {
   3.860740183343217*^9, 3.860740186464333*^9}, {3.8607404581534157`*^9, 
   3.860740463192748*^9}, {3.860836590327116*^9, 3.860836592379979*^9}, {
   3.860836644031631*^9, 3.86083669274726*^9}, {3.8608368064625587`*^9, 
   3.860836811743595*^9}, {3.860836912060841*^9, 3.860836912249692*^9}, {
   3.8608374091684504`*^9, 3.860837445231764*^9}, {3.8608377516337147`*^9, 
   3.860837758503718*^9}, {3.860837892045484*^9, 3.860837892297962*^9}, {
   3.8608382263027563`*^9, 3.860838251060595*^9}, {3.860841310929798*^9, 
   3.860841330387953*^9}, 3.8608415503749104`*^9, {3.860842453350664*^9, 
   3.8608424573843317`*^9}, {3.8610428227400618`*^9, 3.861042902617837*^9}, {
   3.861043288981011*^9, 3.8610432907199802`*^9}, {3.861043568594781*^9, 
   3.861043570843495*^9}, {3.861170934724453*^9, 3.8611709517097883`*^9}, {
   3.861355096947008*^9, 3.861355120067051*^9}, {3.8616852757831783`*^9, 
   3.861685327966049*^9}, {3.861685540973887*^9, 3.8616855424796047`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"a22f1870-c09e-4297-b8f9-f083591b3a32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"outputs", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"circuit", "[", "i", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "e"}], "}"}]}], "]"}]}], " ", ";"}]], "Input",
 CellChangeTimes->{{3.852982690223474*^9, 3.852982691275523*^9}, {
   3.860525623311987*^9, 3.860525676783456*^9}, {3.860738984345974*^9, 
   3.86073902151257*^9}, {3.860739051524284*^9, 3.860739211767859*^9}, {
   3.860739247895329*^9, 3.8607392558259583`*^9}, {3.8607393180290747`*^9, 
   3.860739396712019*^9}, {3.8607394480809097`*^9, 3.860739480511197*^9}, {
   3.860739606880981*^9, 3.8607396425303097`*^9}, {3.860739676156146*^9, 
   3.860739677535603*^9}, {3.8607398383006067`*^9, 3.860739840330625*^9}, {
   3.860739963824671*^9, 3.860739995239841*^9}, {3.860740032059767*^9, 
   3.860740032856098*^9}, {3.860740141283057*^9, 3.860740141417281*^9}, {
   3.860740183343217*^9, 3.860740186464333*^9}, {3.8607404581534157`*^9, 
   3.860740463192748*^9}, {3.860836590327116*^9, 3.860836592379979*^9}, {
   3.860836644031631*^9, 3.86083669274726*^9}, {3.8608368064625587`*^9, 
   3.860836811743595*^9}, {3.860836912060841*^9, 3.860836912249692*^9}, {
   3.8608374091684504`*^9, 3.860837445231764*^9}, {3.8608377516337147`*^9, 
   3.860837758503718*^9}, {3.860837892045484*^9, 3.860837892297962*^9}, {
   3.8608382263027563`*^9, 3.860838251060595*^9}, {3.860841310929798*^9, 
   3.860841330387953*^9}, {3.8608415503749104`*^9, 3.860841551531384*^9}, 
   3.8616854775825777`*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"5dda541d-eae0-4581-bc46-672c0759813c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Mean", "[", 
    RowBox[{"outputs", "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "K"}], "]"}], "]"}], "]"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.852982690223474*^9, 3.852982691275523*^9}, {
   3.860525623311987*^9, 3.860525676783456*^9}, {3.860738984345974*^9, 
   3.86073902151257*^9}, {3.860739051524284*^9, 3.860739211767859*^9}, {
   3.860739247895329*^9, 3.8607392558259583`*^9}, {3.8607393180290747`*^9, 
   3.860739396712019*^9}, {3.8607394480809097`*^9, 3.860739480511197*^9}, {
   3.860739606880981*^9, 3.8607396425303097`*^9}, {3.860739676156146*^9, 
   3.860739677535603*^9}, {3.8607398383006067`*^9, 3.860739840330625*^9}, {
   3.860739963824671*^9, 3.860739995239841*^9}, {3.860740032059767*^9, 
   3.860740032856098*^9}, {3.860740141283057*^9, 3.860740141417281*^9}, {
   3.860740183343217*^9, 3.860740186464333*^9}, {3.8607404581534157`*^9, 
   3.860740463192748*^9}, {3.860836590327116*^9, 3.860836592379979*^9}, {
   3.860836644031631*^9, 3.86083669274726*^9}, {3.8608368064625587`*^9, 
   3.860836811743595*^9}, {3.860836912060841*^9, 3.860836912249692*^9}, {
   3.8608374091684504`*^9, 3.860837445231764*^9}, {3.8608377516337147`*^9, 
   3.860837758503718*^9}, {3.860837892045484*^9, 3.860837892297962*^9}, {
   3.8608382263027563`*^9, 3.860838251060595*^9}, {3.860841310929798*^9, 
   3.860841330387953*^9}, {3.8608415503749104`*^9, 3.860841554395996*^9}, 
   3.861685832745741*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"330444ce-8d55-45d7-83be-0064bbeef89b"],

Cell[BoxData["5.64`"], "Output",
 CellChangeTimes->{
  3.8608424165414467`*^9, {3.86084247243639*^9, 3.860842478302713*^9}, 
   3.860842648543284*^9, 3.860842903947976*^9, {3.8610426892675953`*^9, 
   3.86104270523367*^9}, 3.861042739997657*^9, 3.8610428436279793`*^9, 
   3.8610429064168386`*^9, 3.8610435599756107`*^9, 3.861043656607211*^9, 
   3.8610437746558847`*^9, 3.8610439183448257`*^9, 3.861044002262097*^9, 
   3.861044767683237*^9, 3.8610449390154257`*^9, 3.861168958889965*^9, 
   3.861171087322139*^9, 3.8613551229805307`*^9, 3.861355969474485*^9, 
   3.861356044301859*^9, {3.861356164425153*^9, 3.861356183836083*^9}, 
   3.8613562158170633`*^9, 3.8613562673248377`*^9, {3.861356534767202*^9, 
   3.8613565417380457`*^9}, 3.861356629268711*^9, {3.8613569598655653`*^9, 
   3.861356982153439*^9}, {3.8613570169723377`*^9, 3.861357044748526*^9}, {
   3.861357225805298*^9, 3.861357274366961*^9}, {3.8613574405909147`*^9, 
   3.861357454760022*^9}, 3.861357499568536*^9, {3.861357534770022*^9, 
   3.861357562731382*^9}, 3.8613576082378807`*^9, 3.8613577298342733`*^9, 
   3.8613583614262257`*^9, 3.8613583934077873`*^9, 3.861358458203899*^9, 
   3.861358800091084*^9, 3.861358914425104*^9, {3.861358999236305*^9, 
   3.861359019145385*^9}, {3.861359094577347*^9, 3.861359108666204*^9}, {
   3.86135914311721*^9, 3.861359149347834*^9}, 3.861359207530004*^9, 
   3.861360267345525*^9, {3.861360360730098*^9, 3.861360385885586*^9}, 
   3.861360603025132*^9, 3.861360696295525*^9, 3.861360980666059*^9, 
   3.861361025848524*^9, 3.861361087112954*^9, 3.861361139455223*^9, 
   3.861361846029119*^9, 3.861362277853034*^9, 3.8613623490004063`*^9, 
   3.8614315897489634`*^9, 3.861432167944284*^9, 3.861685689874753*^9, 
   3.861685856423279*^9, 3.86168694203211*^9, 3.862560430823591*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"c0cc712b-451e-4387-bdab-b2184414e2fe"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Compute", " ", "the", " ", "proof", " ", "polynomial", " ", "by", " ", 
    "interpolating", " ", "over", " ", "the", " ", "outputs", " ", "and", " ",
     "compare", " ", "it", " ", "against", " ", "the", " ", "circuit"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"proof", "[", "y_", "]"}], " ", ":=", " ", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"InterpolatingPolynomial", "[", 
       RowBox[{"outputs", ",", "x"}], "]"}], " ", "/.", " ", 
      RowBox[{"x", " ", "->", " ", "y"}]}], ",", "p"}], "]"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdyDtIQgEARmEtItCIcAgiM6IUEZKGBnNKEC1QicYCo4dZBtaQWEZD4KAN
QWaWJBINleCjyKVokB5qWqJjZNQUKqZhEZqW3f8Ohw9Ox8T8sKqGQqEwieAZ
R9pb9mdFzYkZ0vtyWqK8zooYDLscChh0XZCwNH2yDPPBhVUotyxtQvNhZRv2
a39skJ8LOGEybDuGcVuND16MNp3Bak/yCsqKQyHIqRqj0NV5Smpx3r3AFSvt
FfonDXkYcqs/oSNNLUKuqpU01uiqCxEqRzykB+UMDSaeFHQYTom74R/vjfRS
H2n7JoxwG1iwvXatC26kd3hw4CEmgKaovg/OFqgSaPitJy1Mso3QoTkywSnp
lxfqWHEf3FtcC8CUyUzKPxnMQNXH+Dv5A89zRUKmRqaF4mrUDClu2ToM5x7L
UMGTVeCufUttv8mK9ktCDcwL2R7rbVY01nLuhf8ZERN+
  "],
 CellLabel->"In[21]:=",ExpressionUUID->"a650314b-7365-4d55-9fde-ec64c98afdc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "p"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.86074006022542*^9, 3.860740065659564*^9}, {
  3.860740155317368*^9, 3.860740171719946*^9}, {3.860740244370369*^9, 
  3.860740305037929*^9}, {3.8607404427640944`*^9, 3.8607404438305397`*^9}, {
  3.8607405870205584`*^9, 3.860740587991579*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"f5760ba8-b7b7-4b7c-9f23-4519ad2c80a2"],

Cell[BoxData["808577099"], "Output",
 CellChangeTimes->{
  3.860740308296973*^9, 3.8607403694543867`*^9, {3.860740423302894*^9, 
   3.8607404847202673`*^9}, {3.860740576714788*^9, 3.860740606792307*^9}, 
   3.8608361740853577`*^9, {3.860836843622134*^9, 3.8608368735952673`*^9}, {
   3.86083807163419*^9, 3.860838111167921*^9}, 3.860838273613738*^9, 
   3.860839321278166*^9, 3.8608396906876574`*^9, 3.8608407914049788`*^9, 
   3.860841035268158*^9, 3.860841073581902*^9, 3.860841259495968*^9, 
   3.8608424165692253`*^9, {3.860842472468792*^9, 3.860842478331612*^9}, 
   3.8608426485730543`*^9, 3.860842903980962*^9, {3.861042689293105*^9, 
   3.8610427052600718`*^9}, 3.8610427400233107`*^9, 3.861042843657867*^9, 
   3.8610429064439087`*^9, 3.861043560034916*^9, 3.861043656637206*^9, 
   3.861043774686981*^9, 3.861043918372882*^9, 3.8610440022928133`*^9, 
   3.861044767709649*^9, 3.861044939041401*^9, 3.861168958914937*^9, 
   3.861171087338036*^9, 3.861355123013611*^9, 3.8613559695014763`*^9, 
   3.8613560443224983`*^9, {3.8613561644454393`*^9, 3.861356183860347*^9}, 
   3.861356215841902*^9, 3.8613562673463793`*^9, {3.86135653478858*^9, 
   3.8613565417616034`*^9}, 3.861356629288641*^9, {3.861356959877326*^9, 
   3.861356982177166*^9}, {3.8613570169917517`*^9, 3.8613570447605762`*^9}, {
   3.861357225828869*^9, 3.861357274426147*^9}, {3.86135744061488*^9, 
   3.861357454783533*^9}, 3.86135749957722*^9, {3.861357534787567*^9, 
   3.861357562749816*^9}, 3.861357608256297*^9, 3.861357729854653*^9, 
   3.861358361444951*^9, 3.861358393426231*^9, 3.861358458223938*^9, 
   3.861358800112363*^9, 3.8613589144464006`*^9, {3.8613589992440557`*^9, 
   3.861359019161241*^9}, {3.861359094587831*^9, 3.861359108683735*^9}, {
   3.861359143136538*^9, 3.861359149364525*^9}, 3.861359207547188*^9, 
   3.861360267364828*^9, {3.8613603607588863`*^9, 3.861360385906653*^9}, 
   3.8613606030450153`*^9, 3.861360696313195*^9, 3.861360980690885*^9, 
   3.8613610258681803`*^9, 3.86136108712997*^9, 3.861361139470818*^9, 
   3.861361846060811*^9, 3.8613622778745213`*^9, 3.861362349029277*^9, 
   3.861431589763687*^9, 3.8614321679586906`*^9, 3.8616856898912907`*^9, 
   3.861685856439987*^9, 3.86168694204734*^9, 3.86256043084161*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"72925c41-f259-4cba-902e-eddfae24aa48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"proof", "[", "z", "]"}], " ", "==", " ", 
    RowBox[{"circuit", "[", "z", "]"}]}], ",", " ", 
   RowBox[{
   "\"\<The polynomial and the circuit match at x = \>\"", " ", "<>", " ", 
    RowBox[{"ToString", "[", "z", "]"}]}], ",", " ", 
   RowBox[{"\"\<Polynomials do not match at x = \>\"", " ", "<>", "  ", 
    RowBox[{"ToString", "[", "z", "]"}], " ", "<>", " ", "\"\< (\>\"", " ", "<>",
     " ", 
    RowBox[{"ToString", "[", 
     RowBox[{"proof", "[", "z", "]"}], "]"}], " ", "<>", " ", "\"\< != \>\"", 
    " ", "<>", " ", 
    RowBox[{"ToString", "[", 
     RowBox[{"circuit", "[", "z", "]"}], "]"}], " ", "<>", " ", 
    "\"\<)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.860740312062007*^9, 3.860740417791567*^9}, {
   3.860740479730033*^9, 3.860740495470106*^9}, {3.860740529781794*^9, 
   3.8607405712026167`*^9}, 3.860740602129788*^9, {3.860838474918707*^9, 
   3.860838491171773*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"c7f286bc-5be8-4bcd-a18e-f97fe36b5d19"],

Cell[BoxData["\<\"The polynomial and the circuit match at x = \
808577099\"\>"], "Output",
 CellChangeTimes->{
  3.861043919712332*^9, 3.861044003648432*^9, 3.8610447690566187`*^9, 
   3.861044940365844*^9, 3.861168961088895*^9, 3.861171088867566*^9, 
   3.861355123041877*^9, 3.86135596953508*^9, 3.861356044348207*^9, 
   3.8613561838875933`*^9, 3.861356215870949*^9, 3.861356267373082*^9, {
   3.8613565348154287`*^9, 3.861356541789239*^9}, 3.861356629342526*^9, {
   3.8613569599024143`*^9, 3.8613569822128897`*^9}, {3.861357017021821*^9, 
   3.861357044787386*^9}, {3.861357225857202*^9, 3.861357280327943*^9}, {
   3.861357441121099*^9, 3.8613574552830877`*^9}, 3.861357499613886*^9, {
   3.86135753482355*^9, 3.861357562766509*^9}, 3.861357608274151*^9, 
   3.861357729871559*^9, 3.861358361468165*^9, 3.861358393454357*^9, 
   3.861358458250524*^9, 3.861358800146624*^9, {3.861358999260841*^9, 
   3.8613590191860237`*^9}, {3.861359094610587*^9, 3.861359108700551*^9}, {
   3.861359143154572*^9, 3.861359149381933*^9}, 3.8613592075656013`*^9, 
   3.861360267383243*^9, {3.861360382085723*^9, 3.861360385924892*^9}, 
   3.8613606031688766`*^9, 3.8613606963970957`*^9, 3.861360980781879*^9, 
   3.861361028583658*^9, 3.8613610876609077`*^9, 3.861361140774767*^9, 
   3.861361847363112*^9, 3.861362279342052*^9, 3.861362351680479*^9, 
   3.8614315921448402`*^9, 3.861432170284832*^9, 3.861685692218029*^9, 
   3.8616858587980633`*^9, 3.8616869443735456`*^9, 3.862560433609977*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"2603d040-5a4e-4aa1-99a9-48c8e5a7172d"]
}, Open  ]]
},
WindowSize->{1386, 762},
WindowMargins->{{0, Automatic}, {0, Automatic}},
Magnification:>1.2 Inherited,
FrontEndVersion->"13.0 for Linux x86 (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"cf005094-1fe1-4167-ac9f-52d274e3d788"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1479, 21, 35, "Input",ExpressionUUID->"aeb57f6b-479b-4d5c-8a38-3c1b1554e676"],
Cell[CellGroupData[{
Cell[2062, 45, 2529, 47, 178, "Input",ExpressionUUID->"051279dc-4e36-4fe6-9211-c8e9c16744c8"],
Cell[4594, 94, 2190, 31, 39, "Output",ExpressionUUID->"7833c3c4-ec41-4ea3-9a63-b78a301b8faf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6821, 130, 911, 20, 60, "Input",ExpressionUUID->"355caf0a-b1ce-41e2-aef7-5f38ccf9381d"],
Cell[7735, 152, 1562, 22, 39, "Output",ExpressionUUID->"d4bf25fd-0660-491e-a99e-3064160e6db7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9334, 179, 1690, 28, 35, "Input",ExpressionUUID->"0f1573dc-8cfc-45ed-b0c3-be70d19fb8cb"],
Cell[11027, 209, 3517, 49, 39, "Output",ExpressionUUID->"9211221a-1848-4f2f-a07d-a99bd6df4508"]
}, Open  ]],
Cell[14559, 261, 3148, 67, 109, "Input",ExpressionUUID->"ce8ddf80-aee9-48c8-8dac-e65481c99f39"],
Cell[CellGroupData[{
Cell[17732, 332, 635, 11, 35, "Input",ExpressionUUID->"82f9f139-1ac3-4fef-af66-8c8fb95cb2c6"],
Cell[18370, 345, 2169, 31, 39, "Output",ExpressionUUID->"a50871bd-1739-4d21-be87-90ffbf6428d3"]
}, Open  ]],
Cell[20554, 379, 3412, 63, 84, "Input",ExpressionUUID->"3a9c4d00-56a9-4e49-a2fb-b2e31ede68e3"],
Cell[CellGroupData[{
Cell[23991, 446, 1731, 31, 35, "Input",ExpressionUUID->"f9154fa4-954a-4aec-83f6-416dfcae8fc5"],
Cell[25725, 479, 2194, 31, 39, "Output",ExpressionUUID->"2aac001f-8e36-4a3a-87d3-7411bc97d972"]
}, Open  ]],
Cell[27934, 513, 2544, 50, 60, "Input",ExpressionUUID->"20f8c214-df7c-4fce-ba0d-7476cc636656"],
Cell[30481, 565, 1412, 32, 60, "Input",ExpressionUUID->"1f3fe976-e47f-4e17-8f60-193e32f82a65"],
Cell[31896, 599, 2418, 42, 35, "Input",ExpressionUUID->"6e036173-6137-4674-a284-8eacc6a383a3"],
Cell[34317, 643, 4591, 94, 182, "Input",ExpressionUUID->"49642877-642a-4d21-866e-92bd12577c5d"],
Cell[38911, 739, 4170, 80, 84, "Input",ExpressionUUID->"dc02f99d-2ecc-499d-a011-2a859c79f77a"],
Cell[CellGroupData[{
Cell[43106, 823, 2255, 37, 60, "Input",ExpressionUUID->"810f589d-69b0-4b56-a09d-5c7763a01e34"],
Cell[45364, 862, 2401, 34, 39, "Output",ExpressionUUID->"c1e39992-506d-44e9-8558-4b5019567c2f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47802, 901, 1825, 29, 60, "Input",ExpressionUUID->"e38959a0-868f-4921-bc92-a54564e70970"],
Cell[49630, 932, 2169, 30, 39, "Output",ExpressionUUID->"73ac5db6-8c80-4cf5-a562-6847a0627628"]
}, Open  ]],
Cell[51814, 965, 1696, 27, 35, "Input",ExpressionUUID->"5a0088c9-9492-4355-ae20-492916342b50"],
Cell[53513, 994, 3085, 59, 60, "Input",ExpressionUUID->"a22f1870-c09e-4297-b8f9-f083591b3a32"],
Cell[56601, 1055, 1607, 26, 35, "Input",ExpressionUUID->"5dda541d-eae0-4581-bc46-672c0759813c"],
Cell[CellGroupData[{
Cell[58233, 1085, 1553, 25, 35, "Input",ExpressionUUID->"330444ce-8d55-45d7-83be-0064bbeef89b"],
Cell[59789, 1112, 1874, 26, 60, "Output",ExpressionUUID->"c0cc712b-451e-4387-bdab-b2184414e2fe"]
}, Open  ]],
Cell[61678, 1141, 1223, 26, 60, "Input",ExpressionUUID->"a650314b-7365-4d55-9fde-ec64c98afdc6"],
Cell[CellGroupData[{
Cell[62926, 1171, 496, 9, 35, "Input",ExpressionUUID->"f5760ba8-b7b7-4b7c-9f23-4519ad2c80a2"],
Cell[63425, 1182, 2315, 32, 39, "Output",ExpressionUUID->"72925c41-f259-4cba-902e-eddfae24aa48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65777, 1219, 1055, 22, 60, "Input",ExpressionUUID->"c7f286bc-5be8-4bcd-a18e-f97fe36b5d19"],
Cell[66835, 1243, 1564, 22, 39, "Output",ExpressionUUID->"2603d040-5a4e-4aa1-99a9-48c8e5a7172d"]
}, Open  ]]
}
]
*)

