import pennylane as qml
from pennylane.ops import CNOT, RX, RY, RZ, CZ
from pennylane import numpy as np
import random
import numpy.linalg as la
import math
from math import pi
from datetime import datetime
import os
import optimizer





mole, symbols = "LiH", ["Li", "H"]
geometry = np.array([0.0, 0.0, 0.0, 0.0, 0.0, 2.969280527])
n_e, n_elec, n_orbitals = 0, 2, 5


# Parameters
n_time = 5
n_check = 20
n_layer = 1
iteration = 100

H, qubits = qml.qchem.molecular_hamiltonian(symbols, geometry, active_electrons=n_elec, active_orbitals=n_orbitals, charge=n_e)
print("Number of qubits = ", qubits)

dev = qml.device("default.qubit", wires=qubits)
# @qml.qnode(dev)
# @qml.qnode(dev, interface="torch")
@qml.qnode(dev, interface="autograd", diff_method="backprop")


def givens_circuit(params, obs=None, qubits=None, excitations=None):
    hf_state = qml.qchem.hf_state(n_elec, qubits)
    qml.BasisState(hf_state, wires=range(qubits))
    for i, excitation in enumerate(excitations):
        if len(excitation) == 4:
            qml.DoubleExcitation(2*params[i], wires=excitation)
        else:
            qml.SingleExcitation(2*params[i], wires=excitation)
    return qml.expval(obs)



ansatz = givens_circuit

singles, doubles = qml.qchem.excitations(n_elec, qubits)
excitations_whole = doubles+singles
excitations_select = excitations_whole

#circuit_gradient = qml.grad(givens_circuit)
#params = np.array(np.zeros(len(singles)+len(doubles)), requires_grad=True)
#grads = circuit_gradient(params, obs=H(geometry_init), qubits=qubits, excitations=excitations_whole)
#excitations_select = [excitations_whole[i] for i in range(len(excitations_whole)) if abs(grads[i]) > 1.0e-6]

print("number of selected excitations: ", len(excitations_select))
print(excitations_select)
excitations_save = np.zeros((len(excitations_select),4))
for i in range(len(excitations_select)):
    if(len(excitations_select[i]) == 2):
        excitations_save[i][0] = excitations_select[i][0]
        excitations_save[i][1] = excitations_select[i][1]
        excitations_save[i][2] = -1
        excitations_save[i][3] = -1
    if(len(excitations_select[i]) == 4):
        excitations_save[i][0] = excitations_select[i][0]
        excitations_save[i][1] = excitations_select[i][1]
        excitations_save[i][2] = excitations_select[i][2]
        excitations_save[i][3] = excitations_select[i][3]
if not os.path.exists("./"+mole):
    os.makedirs("./"+mole)
np.save("./"+mole+"/exitations_selected.txt", excitations_save)


excitations = []
for i in range(n_layer):
    excitations = excitations + excitations_select
n_params = len(excitations)
gamma = 1/(96*64*n_params)**0.5

t1 = datetime.now()

lr = 0.01

# constant noise
optimizer.chem_adam_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)
optimizer.chem_adam_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)
optimizer.chem_adam_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)

# noiseless
optimizer.chem_adam_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)
optimizer.chem_adam_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)
optimizer.chem_adam_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)

# adaptive noise
optimizer.chem_adam_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)
optimizer.chem_adam_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)
optimizer.chem_adam_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)


lr = 0.1

# constant noise
optimizer.chem_gd_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)
optimizer.chem_gd_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)
optimizer.chem_gd_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, math.sqrt(1/1000), 0, lr, iteration, n_time, n_check)

# noiseless
optimizer.chem_gd_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)
optimizer.chem_gd_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)
optimizer.chem_gd_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 0, lr, iteration, n_time, n_check)

# adaptive noise
optimizer.chem_gd_gaussian(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)
optimizer.chem_gd_zero(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)
optimizer.chem_gd_uniform(ansatz, mole, H, excitations, qubits, n_params, gamma, 0, 1, lr, iteration, n_time, n_check)

t2 = datetime.now()
print("qubits: ", qubits, "params: ", n_params, 'seconds for ', mole,  (t2-t1).seconds)