import os

#####################################################################################################################
# DATA OPTIONS
#####################################################################################################################
data_root_dir    = "./out/dataset"
data_deform4d_root_dir = "/****/DeformingThings4D_processed_dataset"
data_deform4d_seq_root_dir = "/****/DeformingThings4D_processed_dataset"

experiments_dir  = "./out/experiments"
train_split = "train_seen" 
iden_seen_split = "template_seq_identity_seen"
iden_unseen_split = "template_seq_identity_unseen"
val_unseen_motion_split = "val_unseen_motions_raw"
val_unseen_motion_clean_split = "val_unseen_motions"
val_unseen_iden_split = "val_unseen_identities"
val_unseen_iden_clean_split = "val_unseen_identities"

#####################################################################################################################
# DATA LOADING OPTIONS
#####################################################################################################################
num_worker_threads = 0 # 0 means that the base thread does all the job (that makes sense when hdf5 is already loaded into memory).
num_threads = 4

#####################################################################################################################
# MODEL INFO
#####################################################################################################################
# Pretrained model
initialize_from_other  = False
saved_model_path = ""
saved_model_iteration = 0

#####################################################################################################################
# GENERAL OPTIONS
#####################################################################################################################
# Shuffle batch
shuffle = True

# Detect anomalies, such as when gradients explode
detect_anomaly = False

#####################################################################################################################
# TRAINING OPTIONS
#####################################################################################################################
flow_batch_size = 4
epochs = 100
flow_learning_rate = 5e-4
weight_decay = 0

# Losses
lambda_flow = 1.0 


#####################################################################################################################
# PRINT HYPERPARAMS
#####################################################################################################################
def print_hyperparams(data, experiment_name):
    print()
    print("HYPERPARAMETERS:")
    print()

    print("\tDATA:                        ", data)
    print("\tEXPERIMENT:                  ", experiment_name)

    print()
    print("\tnum_worker_threads           ", num_worker_threads)
    print("\tnum_threads                  ", num_threads)
