## Maximum likelihood experiments:

See `vae_ident_mle.nb`. This is a Mathematica notebook which is used to perform numerical integrations in computing the likelihood.

## Simulated experiments:

- We build on the codebase https://github.com/mperezcarrasco/Pytorch-VaDE and all our codes are in the `simulated/` folder.
- To generate a "Random parallelograms" dataset and run VaDE on this dataset 5 times, run

```
python3 expt.py
```

- To generate a pinwheels dataset and run VaDE on this dataset 5 times, uncomment lines 262, 263 and comment out line 261 in `expt.py`. Run 

```
python3 expt.py
```

- The models are saved in `saved_models/` folder.
- We include the original data and trained models for three "Random parallelograms" dataset in the `outputs/` and `saved_models/` folders respectively. 
- To compute dist_{Aff, L2}, set the proper folder with the models in Line 79 of `compare_latent.py`, then run

```
python3 compare_latent.py
```

- To compute MCC distance, add the correct folder name in L41-45 in `compare_latent_mcc.py` and run

```
python3 compare_latent_mcc.py
```


## MNIST experiments:

Running the MFCVAE code:

- Follow the instructions to run MFCVAE (e.g. install dependencies, log on to wandb.ai) - https://github.com/FabianFalck/mfcvae.
- Modify the configuration file `configs/mnist.yml` to use the desired architecture
- Main changes include activation, model_type, n_clusters_j_list and z_j_dim_list (see an example at `mnist/mfcvae_mnist_modified.yml`)
- Remove the manual seeding done in L328-329 of `train.py`
- Execute the training 10 times using a script, where each run is done using (replace config path with the correct one)

```
python3 train.py --config_args_path "configs/mnist_modified.yml"
```

- Use the saved checkpoints or download them manually from wandb and save them in a new folder.
- Run our Python code `mnist/mfcvae_mcc.py` (after modifying L37 to the correct folder) to evalute the MCCS (strong and weak, out of sample)

Running iVAE code:

- Use the codebase from https://github.com/MatthewWilletts/algostability
- Modify `configs/mnist_mlp.yaml` to use desired feature_size (we set latent dimension = 5) and set num_components to be 25.
- To use the desired architecture and activations, modify self.linear in the classes FullMLPencoder and FullMLPdecoder in `models/nets.py` (see L252-314). See a sample at our modified code `mnist/ivae_nets.py`.
- Run the iVAE code with

```
python3 -u main.py --config mnist_mlp.yaml --n-sims 10 --representation --baseline --ivae -z 5
```

- The MCCs are evaluated using

```
python3 -u main.py --config mnist_mlp.yaml --n-sims 10 --representation --baseline --ivae -z 5 --all --mcc
```