#include <set>
#include <map>
#include <iostream>
#include "mm_Knuth.h"
#include "mm_Game.h"

namespace mm{

static void
collect( std::vector<unsigned>& buf,
         unsigned pos,
         unsigned numColor,
         std::vector<std::vector<unsigned> >& storage )
{
    if( pos == buf.size()-1 ){
        for( unsigned i=0; i<numColor; i++ ){
            buf[pos] = i;
            storage.push_back( buf );
        }
    }
    else{
        for( unsigned i=0; i<numColor; i++ ){
            buf[pos] = i;
            collect( buf, pos+1, numColor, storage );
        }
    }
}

void
getAllCodes( const unsigned numPeg,
             const unsigned numColor,
             std::vector<std::vector<unsigned> >& storage )
{
    storage.clear();
    std::vector<unsigned> buf( numPeg );
    collect( buf, 0, numColor, storage );
}
    
Knuth::Knuth( const unsigned numPeg,
              const unsigned numColor )
    : Player{ numPeg, numColor }
{
    getAllCodes( numPeg, numColor, _all );
}

void
Knuth::guess( std::vector<unsigned>& guess )
{
    if( _candidates.empty() ){
        unsigned color1 = rand() % _numColor;
        unsigned color2 = rand() % (_numColor-1);
        if( color2 >= color1 ) color2++;
        unsigned half = _numPeg/2;
        guess = std::vector<unsigned>( half, color1 );
        guess.resize( _numPeg, color2 );
        return;
    }
    std::set<std::vector<unsigned> > canSet( _candidates.begin(),
                                             _candidates.end());
    unsigned score = _all.size();
    bool isCandidate = false;
    for( unsigned i=0; i<_all.size(); i++ ){
        std::map<std::pair<unsigned,unsigned>,unsigned> counter;
        for( unsigned ii=0; ii<_candidates.size(); ii++ ){
            counter[ get_feedback( _all[i], _candidates[ii] )]++;
        }
        unsigned newscore = 0;
        for( std::map<std::pair<unsigned,unsigned>,unsigned>::iterator
                 iter = counter.begin(); iter != counter.end(); iter++ ){
            if( newscore < iter->second ) newscore = iter->second;
        }
        if( score < newscore ) continue;
        if( score > newscore ){
            guess = _all[i];
            score = newscore;
            isCandidate = ( canSet.find(guess) != canSet.end());
            continue;
        }
        if( isCandidate ) continue;
        if( canSet.find(_all[i]) != canSet.end()){
            guess = _all[i];
            isCandidate = true;
        }
    }
}

void
Knuth::read( const std::vector<unsigned>& guess,
             const std::pair<unsigned,unsigned>& feedback )
{
    std::vector<std::vector<unsigned> > storage;
    std::vector<std::vector<unsigned> >& candidates = _candidates.empty()? _all:_candidates;
    for( unsigned i=0; i<candidates.size(); i++ ){
        if( get_feedback( guess, candidates[i] ) == feedback ){
            storage.push_back( candidates[i] );
        }
    }
    _candidates = storage;
    if( _candidates.empty()) throw std::runtime_error("codemaker lied");
}

}
