#ifndef MM_GAME_H
#define MM_GAME_H

#include <vector>
#include <string>

namespace mm{

class Game{
public:
    Game( const unsigned, const unsigned );
    virtual ~Game(){}
    virtual std::pair<unsigned,unsigned> feedback( const std::vector<unsigned>&);
    virtual double stats( std::ostream& ){return 0;}
    std::string code();
protected:
    std::vector<unsigned> _code;
};

std::string code_to_string( const std::vector<unsigned>& );
std::string pair_to_string( const std::pair<unsigned,unsigned>& );
std::pair<unsigned,unsigned> get_feedback( const std::vector<unsigned>&,
                                           const std::vector<unsigned>& );

}

#endif

