total_time = 1024 * 8;
K = 25; % 10 20 30
T_range = [5, 10, 25, 50, 75, 100];
T_range = 200;
%T_range = round(logspace(log10(5),log10(1000),10)); %30 2000 60 4000
error_probs1 = zeros(length(T_range), 2);
for ii = 1 : length(T_range)
    T = T_range(ii);
    error_prob1 = zeros(total_time, 1);
    error_prob2 = zeros(total_time, 1);
    parfor jj = 1 : total_time
        rng((T + 1) * total_time + jj);
        [theta, A] = many_sub_data_generator(K);
        %theta = theta / 2;
        [~ , I] = max(theta' * A);
        best_arm = myalgo(theta, A, T);
        if I ~= best_arm
            error_prob1(jj) = 1;
        end
        best_arm = LTS(theta, A, T);
        if I ~= best_arm
            error_prob2(jj) = 1;
        end
        [jj, T]
    end
    error_probs1(ii, :) = sum([error_prob1, error_prob2]) / total_time;
end


figure('Position',[0 0 450 300]);
set(gcf,'PaperPositionMode','auto');
markers = {'none', '.', '*', 'x'};
for i = 1 : 2
    h = semilogx(T_range, error_probs1(:, i),'Linewidth', 1.2, 'Marker', markers{i});
    hold on;
end
grid;
xlabel('$T$', 'FontSize',16,'Interpreter','latex');
ylabel('Error probability', 'FontSize',16,'Interpreter','latex');
legend('OD-LinBAI', 'LT\&S', 'FontSize', 16, 'Interpreter','latex',  'Location', 'NorthWest');
ylim([0 1]);
saveas(gcf,'matlab_plot/figs/K=10_fixed','epsc');
% xlim([50 2000]);
% xticks([50 100 500 1000 2000]);
% xticklabels({'5\times10^1','10^2', '5\times10^2', '10^3','2\times10^3'});

%save('K=100.mat','T_range', 'error_probs1');