class DLADatasetManager extends THREE.Object3D {
    constructor(data, particleSprite, particleSize) {
        super()

        this.data = data;

        this.dlaDatasets = [];
        for (let i = 0; i < this.data.dla.length; i++) {
            this.dlaDatasets.push(new Dataset(this.data.dla[i], 0.2, 0.9, 1, particleSprite, particleSize));
            this.add(this.dlaDatasets[i])
        }

        this.flowDatasets = [];
        for (let i = 0; i < this.data.flow.length; i++) {
            this.flowDatasets.push(new Dataset(this.data.flow[i], 1, 0, 0, particleSprite, particleSize));
            this.add(this.flowDatasets[i])
        }

        this.likelihoodDataset = null;
        if (this.data.likelihood.length > 0) {
            this.likelihoodDataset = new Dataset(
                this.data.likelihood,
                0.9, 0.9, 0.0,
                particleSprite, particleSize / 2,
                undefined, undefined, 0.1
            )
            this.add(this.likelihoodDataset)
        }
    }

    setDimensions(dim0, dim1) {
        for (let i = 0; i < this.dlaDatasets.length; i++) {
            this.dlaDatasets[i].setDimensions(dim0, dim1);
        }
        for (let i = 0; i < this.flowDatasets.length; i++) {
            this.flowDatasets[i].setDimensions(dim0, dim1);
        }
        if (this.hasLikelihoodData()) {
            this.likelihoodDataset.setDimensions(dim0, dim1)
        }
    }

    hasLikelihoodData() {
        return this.likelihoodDataset != null;
    }

    limits() {
        return {
            min: this.data.dla_minima,
            max: this.data.dla_maxima
        }
    }
}