import rsa.utils as utils
from rsa.utils.arg_parser import parse_args

import numpy as np
import os
import pandas as pd


def main():
    params = parse_args()
    os.makedirs(params['logdir'])
    n_traj = params['n_demos']
    rets = []
    for i in range(n_traj):
        traj = utils.load_trajectory(params['data_folder'], i)
        ret = sum([frame['rew'] for frame in traj])
        rets.append(ret)

    rets = np.array(rets)
    avg = rets.mean()
    std = rets.std()
    print('avg', avg)

    num = 10000

    data = {
        'Epoch': np.arange(num),
        'TotalEnvInteracts': np.arange(num) * params['eval_freq'],
        'AverageTestEpRet': [avg] * num,
        'StdTestEpRet': [std] * num,
    }
    df = pd.DataFrame(data=data)
    df.to_csv(os.path.join(params['logdir'], 'progress.csv'))


if __name__ == '__main__':
    main()
