using Profile
using Distributed
using StaticArrays
using ProgressBars

addprocs(6)
@everywhere include("runner.jl")

mdps = [Dict(:N => N, :mu => 1., :lam => lam)
        for N in [5000]
        for lam in [1., 10.]]
τs = [τtrue(args[:N], args[:mu], args[:lam]) for args in mdps]
gaps = [1 - λ2(MDP(args[:N], args[:mu], args[:lam], :cr))
        for args in mdps]
τdf = DataFrame(mdps)
τdf[!, :tau] .= τs
τdf[!, :spectral_gap] .= real.(gaps)
CSV.write("taus.csv", τdf)
τdf = CSV.read("taus.csv")

dfs = dcollect(
    run_summarize_and_save_tsr(; seed=i, path=".",
                               N=5000, T=Int(1e7), μ=1., λ=λ, kwargs...)
    for i in 1:100
    for λ in [1.]
        for kwargs in [
            Dict(:design => :cr,
                 :estimator => :tabular_td,
                 :lr => 0.01, :ɣ => 0.5),
            Dict(:design => :cr,
                 :estimator => :tabular_td,
                 :lr => 0.1, :ɣ => 0.5),
            Dict(:design => :cr,
                 :estimator => :tabular_td,
                 :lr => 1., :ɣ => 0.5),
            Dict(:design => :cr,
                 :estimator => :tabular_td,
                 :lr => 0.001, :ɣ => 0.5),
            Dict(:design=>:cr, :estimator=>:tsr),
            Dict(:design=>:tsr, :estimator=>:tsr),
            Dict(:design=>:cr, :estimator=>:stats),  # LSTD
            Dict(:design=>:cr, :estimator=>:stats,
                 :summ_kwargs=>Dict(:α=>0.1)),
            Dict(:design=>:cr, :estimator=>:stats,
                 :summ_kwargs=>Dict(:α=>1.)),
            ])
