from . import classic_pendulum
from . import swimmer
from . import hopper
from . import inverted_pendulum
from . import real
from . import invpen3
from . import invpen4
from . import minitaur
# from .safety_gym import point


import exp_utils as PQ
import gym
import numpy as np


class FLAGS(PQ.BaseFLAGS):
    id = 'MyPendulum-v0'
    config = {}


@FLAGS.set_defaults
def make_env(*, id, config):
    import rl_utils.wrappers as w

    env = gym.make(id, **config)
    env = w.RescaleAction(env, -1, 1)
    env = w.ClipAction(env)
    env = w.CastDtype(env)
    env.seed(np.random.randint(0, 2**30))
    return env
