#!/bin/bash

data_dirs=(
arcprobs/arc-challenge/
arcprobs/arc-easy/
physicaliqaprobs/
tomprobs/tom
tomprobs/tom0
tomprobs/tom10
tomprobs/tomeasy0
tomprobs/tomeasy10
wordprobs/
    )

data_names=(
arc-challenge
arc-easy
physicaliqaprobs
tom
tom0
tom10
tomeasy0
tomeasy10
wordprobs
    )
gpus=( 3 4 5 6 7 8 9 10 11 12 13 14 15 )

for ((iter=0;iter <${#data_dirs[@]};iter++))
do
    gpu=${gpus[$iter]}
    CUDA_VISIBLE_DEVICES=$gpu python3 t5-train.py --model_name 3B${data_names[$iter]} --data_dir data/${data_dirs[$iter]} &
    if [ $gpu -eq ${gpus[-1]} ]
    then 
        echo waiting at \
            gpu $gpu 
        wait
    fi
done

wait
