%% clearing
clear all;close all;clc
figure('Renderer', 'painters', 'Position', [10 10 900 500])


%% Settings
tf = 500; % final time
tspan = [eps tf]; %eps for numerical problems
%ic = [1,1,0,0]'; %initial condition
ic = [0.1,0.1,0,0]'; %initial condition

H =[2*1e-2,0*1e-3;0*1e-3,5*1e-2]; %hessian


%% Solving the ODE numerically
opts = odeset('RelTol',1e-5,'AbsTol',1e-10);
[t1,y1] = ode45(@(t,y) vanishing_damping(t,y,H), tspan, ic, opts);


%% Plotting
subplot(1,2,1)
XX=-0.1:0.001:0.1;
YY=-0.1:0.001:0.1;
[X,Y] = meshgrid(XX,YY);
Z = H(1,1)*X.^2 + H(2,2)*Y.^2 + H(1,2)*X.*Y+ H(2,1)*X.*Y;
contour(X,Y,Z,100,'Color',[0.8,0.8,0.8],'LevelStep',0.1,'LevelStepMode','manual');hold on;
pbaspect([1 1 1])
plot(y1(:,1),y1(:,2),'Linewidth',3,'Color',[0.499 0.458 0.704]);hold on
plot(0,0,'-kh','MarkerSize', 13,'MarkerFaceColor',[0.839 0.78 0.078]);
xlabel('$x_1$','FontSize',25,'Interpreter','Latex')
ylabel('$x_2$','FontSize',25,'Interpreter','Latex')
xlim([-0.017,0.017])
ylim([-0.017,0.017])
title('Nesterov path (damping $3/t$)','FontSize',25,'Interpreter','Latex')

subplot(1,2,2)
h1=plot(t1,y1(:,1),'Linewidth',3,'Color',[0.314 0.459 0.78]);hold on
h2=plot(t1,y1(:,2),'Linewidth',3,'Color',[0.922 0.333 0.596]);hold on
h3=plot(t1,sqrt(y1(:,2).^2 + y1(:,1).^2) ,'Linewidth',3,'Color',[0.845 0.477 0.199]);hold on
plot(t1,0*t1,'--','Linewidth',3,'Color','k');hold on

xlabel('$t$','FontSize',25,'Interpreter','Latex')
legend([h1,h2,h3],{'$x_1(t)$','$x_2(t)$','$\|x(t)\|_2$'},'FontSize',25,'Interpreter','Latex')
xlim([0,50])
ylim([-0.02,0.04])
saveas(gcf,['nesterov_not_reaching'],'epsc');

grid on

%% function ODE
function dydt = vanishing_damping(t,y,H)
    dydt = 0*y;
    dydt(1:(end/2)) = y((end/2+1):end); % \dot X
    dydt((end/2+1):end) = - (3/t) * y((end/2+1):end) - 2*H * y(1:(end/2)); %\dot V    
end
