import matplotlib.pyplot as plt
import numpy as np

def perform_reduce_op(pd_series, reduce_op):
    if reduce_op == 'mean':
        return pd_series.mean()
    if reduce_op == 'max':
        return pd_series.max()
    if reduce_op == 'min':
        return pd_series.min()

def RepresentsInt(s):
    try:
        int(s)
        return True
    except ValueError:
        return False

def plot_single_eval(run_reader, y, ax, label, color, reduce_op):
    dicts = run_reader.load_data_dicts()
    x_vals = []
    y_vals = []
    for key, data_dict in dicts.items():
        if '_lineval' in key:
            prefix = key.split('_lineval')[0]
            if RepresentsInt(prefix):
                x_vals.append(int(prefix))
            y_vals.append(perform_reduce_op(data_dict[y], reduce_op))
    x_vals = np.array(x_vals)
    y_vals = np.array(y_vals)
    idx = np.argsort(x_vals)
    x_vals = x_vals[idx]
    y_vals = y_vals[idx]
    ax.plot(
        x_vals, 
        y_vals, 
        label=label,
        color=color)

def plot_evals(
    reader,
    y,
    plot_params,
    label_args=[],
    manual_labels={}):
        
    if len(label_args) > 0 or len(manual_labels) > 0:
        labels_to_use = reader.get_labels(label_args=label_args,manual_labels=manual_labels)
    else:
        labels_to_use = reader.labels

    fig, ax = plt.subplots()
    for ind, run_reader in enumerate(reader.run_readers):
        plot_single_eval(
            run_reader,
            y,
            ax,
            labels_to_use[ind],
            reader.cmap(ind),
            plot_params['reduce'])
        

    if 'y_scale' in plot_params:
        ax.set_yscale(plot_params['y_scale'])
    if 'x_scale' in plot_params:
        ax.set_xscale(plot_params['x_scale'])

    ax.set_xlim(plot_params['min_x'], plot_params['max_x'])
    ax.set_ylim(plot_params['min_y'], plot_params['max_y'])

    ax.legend(bbox_to_anchor=(1.01, 1), loc='upper left', ncol=1)
    ax.set_title('epoch v.s. %s' % (y))


