#!/bin/bash

if [ -z "$1" ]; then
    echo "ERROR: CONFIG_ID was not specified"
    exit
fi

## Get config file and load env variables from json
export CONFIG_ID=$1
export CONFIG_FILE=config_$CONFIG_ID.json
for s in $(cat $CONFIG_FILE | jq -r "to_entries|map(\"\(.key)=\(.value|tostring)\")|.[]"); do
    export $s
done

for SLURM_ARRAY_TASK_ID in $(seq $AGENTS_MIN $AGENTS_MAX)
do
    echo Deploying agent $SLURM_ARRAY_TASK_ID
    export SLURM_ARRAY_TASK_ID
    OUTFILE=${scratch_root}logs/$EVAL_SCRIPT_ID.$CONFIG_ID.$SLURM_ARRAY_TASK_ID.out
    # Not using GPU for eval, and only run on single cpu
    num_cpus=$(getconf _NPROCESSORS_ONLN)
    cpu_now=$(echo $(($RANDOM % $num_cpus)))
    CUDA_VISIBLE_DEVICES=-1 taskset -c $cpu_now screen -dmS $EVAL_SCRIPT_ID.$CONFIG_ID.$SLURM_ARRAY_TASK_ID -L -Logfile $OUTFILE python $EVAL_SCRIPT_ID.py
    sleep 1
done