from util_py.arg_parsing  import ArgumentRegistry
from .algodata import AbsAlgoData

from .stop_criterion import get_stop_criterion_arg_registry

import logging

_LOGGER=logging.getLogger(name='optim.abs')


class AbsOptim(object):

    mx_name='maximize'

    @staticmethod
    def get_arg_registries(stct_xtra=None):
        
        arg_reg = ArgumentRegistry('optim')
        arg_reg.register_flag_arg(AbsOptim.mx_name,
                                  'direction of optimization is maximization (def:minimization)',
                                  False, 'store_true') 

        arg_list=[arg_reg, AbsAlgoData.get_arg_registry()]
        
        #unified arg reg for stop criteria
        arg_list.append(get_stop_criterion_arg_registry(stct_xtra))
        
        return arg_list
        
    def __init__(self, objective, 
                 stcrit, algst, arg_dict=None, ismax=False):

        # the obj fcn
        self.objective = objective
        # the stopping criterion
        self.stop_criterion = stcrit
        # recorder of state of the algorihm
        self.algo_state = algst
        
        # are we min or max ? 
        self.step_dirn_mult=1.0
        if arg_dict is not None:        
            argr=self.get_args_registries()[0]
            self.set_minimization( not (arg_dict[argr.get_arg_fullname(AbsOptim.mx_name)]))
            argr.log_args_description(arg_dict,_LOGGER)
        else:
            self.set_minimization (not ismax)
        

    def set_minimization(self, ismin):
        self.is_minimization=ismin
        _LOGGER.info("abs is min: {}".format(self.is_minimization))

        if self.is_minimization :
            self.step_dirn_mult=-1.0

        # now set it to all that care
        self.stop_criterion.is_min(ismin)

    def initialize(self):
        _LOGGER.info("step multi: {} ".format(self.step_dirn_mult))

        self.algo_state.initiate_output(self)
        self.objective.initialize()
        self.stop_criterion.initialize()

    def step(self):
        raise NotImplementedError("Derived classes should be implementing this.")

    def should_itrs_stop(self):
        '''
        Should iterations stop now?
        '''
        return self.stop_criterion.should_stop(self.algo_state) or \
            abs(self.algo_state.objval.value)>1e20



    def terminate(self):
        self.algo_state.terminate_output()
#        self.objective.terminate()
        
