# import torchvision
import json
import os
import sys
sys.path.append(os.path.realpath('.'))
from resnet.experiment import Experiment

# datanums = [1000, 1750, 3060, 5350, 9354, 16355, 28597, 50000]
datanum = 50000
fold = 1
rhos = [1.0, 0.9999, 0.9995, 0.999, 0.995, 0.99, 0.95]
T = 1.0
device_name = 'cuda:0'

for i in range(fold):
    for rho in rhos:

        name = '/resnet/student/vary-soft-ratio/rho-{:.04f}/datanum-{:07d}/fold-{:02d}'.format(
            rho, datanum, i
        )

        test_dir = './experiment/' + name

        if not os.path.exists(test_dir):
            print(name)
            with open('./resnet/default_setting/config.json', 'r', encoding='utf-8') as json_file:
                config = json.load(json_file)
            config['device_name'] = device_name
            config['soft_ratio'] = rho
            config['temperature'] = T
            config['student_datanum'] = datanum
            config['teacher_model_load_path'
                   ] = './experiment/resnet/teacher/net/teacher/teacher.pth'

            experiment = Experiment(name, load_from_exists_config=False, config=config)
            experiment.load_teacher()
            experiment.train_student()
