import os
import sys
sys.path.append(os.path.realpath('.'))
import toy.ops as ops
import matplotlib.pyplot as plt
import numpy as np
import torch

T = 5.0
q_e = torch.linspace(0.0, 7, 5)
rhos = (torch.sigmoid(q_e) - 1.0) / (torch.sigmoid(q_e) - 1.0 - (torch.sigmoid(q_e / T) - 0.5) / T)
x_range = 15.0

x = torch.linspace(-x_range, x_range, 10000)

fig = plt.figure(figsize=(8, 6))
plt.subplots_adjust(left=0.13, right=0.98, bottom=0.13, top=0.95)

l = len(rhos)

for i, (rho) in enumerate(rhos):
    q_eff_correct = ops.f_eff_GD(x, (x > 0).to(x.dtype), rho, T, iter=1000)
    plt.plot(
        x, q_eff_correct, linestyle='solid', color='C{:d}'.format(i), label='{:.02f}'.format(rho)
    )

    if rho < 1.0:
        q_eff_wrong = ops.f_eff_GD(x, (x < 0).to(x.dtype), rho, T, iter=10000)
        plt.plot(x, q_eff_wrong, linestyle='--', color='C{:d}'.format(i))

plt.xlabel(r'$z_\mathrm{t}$', fontdict={'size': 20})
plt.ylabel(r'$z_\mathrm{eff,s}$', fontdict={'size': 20})

plt.legend(
    loc='best',
    title=r'$\rho$',
    fontsize=18,
    title_fontsize=18,
)

plt.tick_params(labelsize=20)

plt.title('vary soft ratio', fontdict={'size': 20})

if not os.path.exists('./figure'):
    os.makedirs('./figure')
fig.savefig('./figure/01a.pdf', format='pdf')
