function [W, L] = getNetworkWeights(settingName, numProcesses)

Id = eye(numProcesses);
E = Id;
if(strcmp(settingName,'Circular'))
    E = Id + Id(:,[2:end 1]) + Id(:,[end 1:end-1]);
elseif(strcmp(settingName,'Connected'))
    E = ones(numProcesses);
    E = E+0*Id;
elseif(strcmp(settingName,'Barbell'))
    if(mod(numProcesses,2)~=0)
        error('numProcesses must be a multiple of 2');
    end
    E = zeros(numProcesses);
    E(1:numProcesses/2,1:numProcesses/2) = ones(numProcesses/2);
    E(numProcesses/2+1:end,numProcesses/2+1:end) = ones(numProcesses/2);
    E(numProcesses/2+1,numProcesses/2) =1;
    E(numProcesses/2,numProcesses/2+1) =1;
    
elseif(strcmp(settingName,'full2'))
    E = ones(numProcesses);
    E = E+5*Id;
elseif(strcmp(settingName,'Disconnected'))
    E = Id;
else
    error('Unknown architecture');
end
% Weight matrix
W = sinkhornKnopp(E);
L = diag(E*ones(numProcesses,1))-E;



